/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.idm.auth;

import java.security.Principal;
import java.security.acl.Group;
import java.util.Collection;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.jacc.PolicyContext;
import javax.servlet.http.HttpServletRequest;
import javax.transaction.TransactionManager;
import org.apache.log4j.Logger;
import org.jboss.identity.idm.api.Attribute;
import org.jboss.identity.idm.api.IdentitySession;
import org.jboss.identity.idm.api.IdentitySessionFactory;
import org.jboss.identity.idm.api.User;
import org.jboss.identity.idm.auth.UserPrincipal;
import org.jboss.identity.idm.auth.UserStatus;
import org.jboss.identity.idm.common.exception.NoSuchUserException;
import org.jboss.identity.idm.common.transaction.TransactionManagerProvider;
import org.jboss.identity.idm.common.transaction.Transactions;
import org.jboss.security.SimpleGroup;
import org.jboss.security.auth.spi.UsernamePasswordLoginModule;

public class JBossIdentityIDMLoginModule
extends UsernamePasswordLoginModule {
    private static Logger log = Logger.getLogger((String)JBossIdentityIDMLoginModule.class.getName());
    protected String identitySessionFactoryJNDIName;
    protected String realmName;
    protected String roleGroupTypeName;
    protected String userEnabledAttributeName;
    protected String additionalRole;
    protected String associatedGroupType;
    protected String associatedGroupName;
    protected String validateUserNameCase;
    protected String userNameToLowerCase;
    protected String manageTransaction;
    private IdentitySessionFactory identitySessionFactory;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        super.initialize(subject, callbackHandler, sharedState, options);
        this.identitySessionFactoryJNDIName = (String)options.get("identitySessionFactoryJNDIName");
        this.realmName = (String)options.get("realmName");
        this.roleGroupTypeName = (String)options.get("roleGroupTypeName");
        this.userEnabledAttributeName = (String)options.get("userEnabledAttributeName");
        this.additionalRole = (String)options.get("additionalRole");
        this.associatedGroupType = (String)options.get("associatedGroupType");
        this.associatedGroupName = (String)options.get("associatedGroupName");
        this.validateUserNameCase = (String)options.get("validateUserNameCase");
        this.userNameToLowerCase = (String)options.get("userNameToLowerCase");
        this.manageTransaction = (String)options.get("transactionAware");
        if (log.isDebugEnabled()) {
            log.debug((Object)("identitySessionFactoryJNDIName = " + this.identitySessionFactoryJNDIName));
        }
        log.debug((Object)("realmName = " + this.realmName));
        log.debug((Object)("groupTypeName = " + this.roleGroupTypeName));
        log.debug((Object)("userEnabledAttributeName = " + this.userEnabledAttributeName));
        log.debug((Object)("additionalRole = " + this.additionalRole));
        log.debug((Object)("havingRole = " + this.associatedGroupName));
        log.debug((Object)("validateUserNameCase = " + this.validateUserNameCase));
        log.debug((Object)("userNameToLowerCase = " + this.userNameToLowerCase));
        log.debug((Object)("transactionAware = " + this.manageTransaction));
    }

    protected String getUsersPassword() throws LoginException {
        return "";
    }

    /*
     * Loose catch block
     */
    protected boolean validatePassword(String inputPassword, String expectedPassword) {
        HttpServletRequest request = null;
        try {
            request = (HttpServletRequest)PolicyContext.getContext((String)"javax.servlet.http.HttpServletRequest");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Object ssoSuccess = request.getAttribute("ssoSuccess");
        if (ssoSuccess != null) {
            return true;
        }
        if (inputPassword != null) {
            try {
                block12: {
                    UserStatus userStatus = this.getUserStatus(inputPassword);
                    request.setAttribute("org.jboss.identity.idm.userStatus", (Object)userStatus);
                    if (userStatus == UserStatus.DISABLE) {
                        return false;
                    }
                    if (userStatus == UserStatus.NOTASSIGNEDTOROLE) {
                        return false;
                    }
                    if (userStatus == UserStatus.UNEXISTING || userStatus == UserStatus.WRONGPASSWORD) {
                        return false;
                    }
                    if (userStatus != UserStatus.OK) break block12;
                    return true;
                }
                log.info((Object)"Unexpected error while logging in");
                return false;
            }
            catch (Exception e) {
                log.info((Object)"Error when validating password: ", (Throwable)e);
                {
                    catch (Exception e2) {
                        log.info((Object)"Failed to validate password: ", (Throwable)e2);
                    }
                }
            }
        }
        return false;
    }

    protected UserStatus getUserStatus(final String inputPassword) {
        UserStatus result = null;
        try {
            TransactionManager tm = TransactionManagerProvider.JBOSS_PROVIDER.getTransactionManager();
            UserStatus tmp = (UserStatus)Transactions.required(tm, new Transactions.Runnable(){

                public Object run() throws Exception {
                    IdentitySession ids = JBossIdentityIDMLoginModule.this.getIdentitySessionFactory().getCurrentIdentitySession(JBossIdentityIDMLoginModule.this.realmName);
                    ids.beginTransaction();
                    if (JBossIdentityIDMLoginModule.this.manageTransaction != null && JBossIdentityIDMLoginModule.this.manageTransaction.equals("true")) {
                        ids.beginTransaction();
                    }
                    UserStatus status = JBossIdentityIDMLoginModule.this._getUserStatus(inputPassword);
                    if (JBossIdentityIDMLoginModule.this.manageTransaction != null && JBossIdentityIDMLoginModule.this.manageTransaction.equals("true")) {
                        ids.getTransaction().commit();
                    }
                    return status;
                }
            });
            if (tmp != null) {
                result = tmp;
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        return result;
    }

    protected UserStatus _getUserStatus(String inputPassword) throws Exception {
        try {
            IdentitySession ids = this.getIdentitySessionFactory().getCurrentIdentitySession(this.realmName);
            User user = ids.getPersistenceManager().findUser(this.getUsername());
            if (user == null) {
                throw new NoSuchUserException("UserModule returned null user object");
            }
            if (this.validateUserNameCase != null && this.validateUserNameCase.equalsIgnoreCase("true") && !this.getUsername().equals(user.getId())) {
                return UserStatus.UNEXISTING;
            }
            if (this.userEnabledAttributeName != null) {
                boolean enabled = false;
                try {
                    Attribute enabledS = ids.getAttributesManager().getAttribute(user, this.userEnabledAttributeName);
                    if (enabledS != null) {
                        enabled = new Boolean(enabledS.toString());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (!enabled) {
                    return UserStatus.DISABLE;
                }
            }
            if (this.associatedGroupName != null && this.associatedGroupType != null) {
                boolean hasTheGroup = false;
                org.jboss.identity.idm.api.Group associatedGroup = ids.getPersistenceManager().findGroup(this.associatedGroupName, this.associatedGroupType);
                if (associatedGroup != null) {
                    hasTheGroup = ids.getRelationshipManager().isAssociated(associatedGroup, user);
                }
                if (!hasTheGroup) {
                    return UserStatus.NOTASSIGNEDTOROLE;
                }
            }
            if (!ids.getAttributesManager().validatePassword(user, inputPassword)) {
                return UserStatus.WRONGPASSWORD;
            }
        }
        catch (NoSuchUserException e1) {
            return UserStatus.UNEXISTING;
        }
        catch (Exception e) {
            throw new LoginException(e.toString());
        }
        return UserStatus.OK;
    }

    protected Group[] getRoleSets() throws LoginException {
        try {
            TransactionManager tm = TransactionManagerProvider.JBOSS_PROVIDER.getTransactionManager();
            return (Group[])Transactions.required(tm, new Transactions.Runnable(){

                public Object run() throws Exception {
                    IdentitySession ids = JBossIdentityIDMLoginModule.this.getIdentitySessionFactory().getCurrentIdentitySession(JBossIdentityIDMLoginModule.this.realmName);
                    ids.beginTransaction();
                    if (JBossIdentityIDMLoginModule.this.manageTransaction != null && JBossIdentityIDMLoginModule.this.manageTransaction.equals("true")) {
                        ids.beginTransaction();
                    }
                    Group[] result = JBossIdentityIDMLoginModule.this._getRoleSets();
                    if (JBossIdentityIDMLoginModule.this.manageTransaction != null && JBossIdentityIDMLoginModule.this.manageTransaction.equals("true")) {
                        ids.getTransaction().commit();
                    }
                    return result;
                }
            });
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            throw new LoginException(cause.toString());
        }
    }

    protected Group[] _getRoleSets() throws Exception {
        SimpleGroup rolesGroup = new SimpleGroup("Roles");
        if (this.additionalRole != null) {
            rolesGroup.addMember(this.createIdentity(this.additionalRole));
        }
        try {
            IdentitySession ids = this.getIdentitySessionFactory().getCurrentIdentitySession(this.realmName);
            User user = ids.getPersistenceManager().findUser(this.getUsername());
            Collection<org.jboss.identity.idm.api.Group> userGroups = ids.getRelationshipManager().findAssociatedGroups(user, this.roleGroupTypeName);
            for (org.jboss.identity.idm.api.Group userGroup : userGroups) {
                String roleName = userGroup.getName();
                try {
                    Principal p = this.createIdentity(roleName);
                    rolesGroup.addMember(p);
                }
                catch (Exception e) {
                    log.info((Object)("Failed to create principal " + roleName), (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            throw new LoginException(e.toString());
        }
        return new Group[]{rolesGroup};
    }

    protected Principal createIdentity(String username) throws Exception {
        return new UserPrincipal(username);
    }

    protected String getUsername() {
        if (this.userNameToLowerCase != null && this.userNameToLowerCase.equalsIgnoreCase("true")) {
            return super.getUsername().toLowerCase();
        }
        return super.getUsername();
    }

    protected String[] getUsernameAndPassword() throws LoginException {
        String[] names = super.getUsernameAndPassword();
        if (this.userNameToLowerCase != null && this.userNameToLowerCase.equalsIgnoreCase("true") && names[0] != null) {
            names[0] = names[0].toLowerCase();
        }
        return names;
    }

    protected IdentitySessionFactory getIdentitySessionFactory() throws NamingException {
        if (this.identitySessionFactory == null) {
            this.identitySessionFactory = (IdentitySessionFactory)new InitialContext().lookup(this.identitySessionFactoryJNDIName);
        }
        return this.identitySessionFactory;
    }
}

