/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.idm.impl.api.query;

import org.jboss.identity.idm.api.Group;
import org.jboss.identity.idm.api.IdentityType;
import org.jboss.identity.idm.api.RoleType;
import org.jboss.identity.idm.api.SortOrder;
import org.jboss.identity.idm.api.User;
import org.jboss.identity.idm.api.query.RoleQuery;
import org.jboss.identity.idm.api.query.RoleQueryBuilder;
import org.jboss.identity.idm.api.query.UnsupportedQueryCriterium;
import org.jboss.identity.idm.impl.api.IdentitySearchCriteriaImpl;
import org.jboss.identity.idm.impl.api.model.GroupId;
import org.jboss.identity.idm.impl.api.model.SimpleGroup;
import org.jboss.identity.idm.impl.api.model.SimpleRoleType;
import org.jboss.identity.idm.impl.api.model.SimpleUser;
import org.jboss.identity.idm.impl.api.query.AbstractQueryBuilder;
import org.jboss.identity.idm.impl.api.query.RoleQueryImpl;

public class RoleQueryBuilderImpl
extends AbstractQueryBuilder
implements RoleQueryBuilder {
    private User user;
    private Group group;
    private RoleType roleType;

    public RoleQuery createQuery() {
        return new RoleQueryImpl(this.searchCriteria, this.user, this.group, this.roleType);
    }

    public RoleQueryBuilder reset() {
        this.searchCriteria = new IdentitySearchCriteriaImpl();
        this.user = null;
        this.group = null;
        this.roleType = null;
        return this;
    }

    public RoleQueryBuilder setUser(User user) {
        this.checkNotNullArgument(user, "User");
        this.user = user;
        return this;
    }

    public RoleQueryBuilder setUser(String id) {
        this.checkNotNullArgument(id, "User id");
        this.user = new SimpleUser(id);
        return this;
    }

    public RoleQueryBuilder setGroup(Group group) {
        this.checkNotNullArgument(group, "Group");
        this.group = group;
        return this;
    }

    public RoleQueryBuilder setGroup(String id) {
        this.checkNotNullArgument(id, "Group id");
        this.group = new SimpleGroup(new GroupId(id));
        return this;
    }

    public RoleQueryBuilder setRoleType(RoleType roleType) {
        this.checkNotNullArgument(roleType, "RoleType");
        this.roleType = roleType;
        return this;
    }

    public RoleQueryBuilder setRoleType(String roleTypeName) {
        this.checkNotNullArgument(roleTypeName, "RoleType name");
        this.roleType = new SimpleRoleType(roleTypeName);
        return this;
    }

    public RoleQueryBuilder setIdentityType(IdentityType identityType) {
        this.checkNotNullArgument(identityType, "IdentityType");
        if (identityType instanceof User) {
            this.user = (User)identityType;
        } else {
            this.group = (Group)identityType;
        }
        return this;
    }

    public RoleQueryBuilder setIdentityTypeId(String id) {
        this.checkNotNullArgument(id, "IdentityType id");
        IdentityType identityType = this.createIdentityTypeFromId(id);
        return this.setIdentityType(identityType);
    }

    public RoleQueryBuilder sort(SortOrder order) throws UnsupportedQueryCriterium {
        return (RoleQueryBuilder)super.sort(order);
    }

    public RoleQueryBuilder sortAttributeName(String name) throws UnsupportedQueryCriterium {
        return (RoleQueryBuilder)super.sortAttributeName(name);
    }

    public RoleQueryBuilder page(int firstResult, int maxResults) throws UnsupportedQueryCriterium {
        return (RoleQueryBuilder)super.page(firstResult, maxResults);
    }

    public RoleQueryBuilder attributeValuesFilter(String attributeName, String[] attributeValue) throws UnsupportedQueryCriterium {
        return (RoleQueryBuilder)super.attributeValuesFilter(attributeName, attributeValue);
    }
}

