/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.idm.impl.store.ldap;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.SortControl;
import org.jboss.identity.idm.common.exception.IdentityException;
import org.jboss.identity.idm.impl.NotYetImplementedException;
import org.jboss.identity.idm.impl.api.SimpleAttribute;
import org.jboss.identity.idm.impl.helper.Tools;
import org.jboss.identity.idm.impl.model.ldap.LDAPIdentityObjectImpl;
import org.jboss.identity.idm.impl.model.ldap.LDAPIdentityObjectRelationshipImpl;
import org.jboss.identity.idm.impl.store.FeaturesMetaDataImpl;
import org.jboss.identity.idm.impl.store.ldap.LDAPIdentityObjectTypeConfiguration;
import org.jboss.identity.idm.impl.store.ldap.LDAPIdentityStoreConfiguration;
import org.jboss.identity.idm.impl.store.ldap.LDAPIdentityStoreSessionImpl;
import org.jboss.identity.idm.impl.store.ldap.SimpleLDAPIdentityStoreConfiguration;
import org.jboss.identity.idm.spi.configuration.IdentityStoreConfigurationContext;
import org.jboss.identity.idm.spi.configuration.metadata.IdentityObjectAttributeMetaData;
import org.jboss.identity.idm.spi.configuration.metadata.IdentityObjectTypeMetaData;
import org.jboss.identity.idm.spi.configuration.metadata.IdentityStoreConfigurationMetaData;
import org.jboss.identity.idm.spi.exception.OperationNotSupportedException;
import org.jboss.identity.idm.spi.model.IdentityObject;
import org.jboss.identity.idm.spi.model.IdentityObjectAttribute;
import org.jboss.identity.idm.spi.model.IdentityObjectCredential;
import org.jboss.identity.idm.spi.model.IdentityObjectRelationship;
import org.jboss.identity.idm.spi.model.IdentityObjectRelationshipType;
import org.jboss.identity.idm.spi.model.IdentityObjectType;
import org.jboss.identity.idm.spi.search.IdentityObjectSearchCriteria;
import org.jboss.identity.idm.spi.store.FeaturesMetaData;
import org.jboss.identity.idm.spi.store.IdentityObjectSearchCriteriaType;
import org.jboss.identity.idm.spi.store.IdentityStore;
import org.jboss.identity.idm.spi.store.IdentityStoreInvocationContext;
import org.jboss.identity.idm.spi.store.IdentityStoreSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LDAPIdentityStoreImpl
implements IdentityStore {
    private static Logger log = Logger.getLogger(LDAPIdentityStoreImpl.class.getName());
    private final String id;
    private FeaturesMetaData supportedFeatures;
    LDAPIdentityStoreConfiguration configuration;
    IdentityStoreConfigurationMetaData configurationMD;
    private static Set<IdentityObjectSearchCriteriaType> supportedSearchCriteriaTypes = new HashSet<IdentityObjectSearchCriteriaType>();
    private Map<String, Map<String, IdentityObjectAttributeMetaData>> attributesMetaData = new HashMap<String, Map<String, IdentityObjectAttributeMetaData>>();

    public LDAPIdentityStoreImpl(String id) {
        this.id = id;
    }

    @Override
    public void bootstrap(IdentityStoreConfigurationContext configurationContext) throws IdentityException {
        if (configurationContext == null) {
            throw new IllegalArgumentException("Configuration context is null");
        }
        this.configurationMD = configurationContext.getStoreConfigurationMetaData();
        this.configuration = new SimpleLDAPIdentityStoreConfiguration(this.configurationMD);
        HashSet<String> readOnlyObjectTypes = new HashSet<String>();
        for (IdentityObjectType identityObjectType : this.configuration.getConfiguredTypes()) {
            if (this.configuration.getTypeConfiguration(identityObjectType.getName()).isAllowCreateEntry()) continue;
            readOnlyObjectTypes.add(identityObjectType.getName());
        }
        this.supportedFeatures = new FeaturesMetaDataImpl(this.configurationMD, supportedSearchCriteriaTypes, false, false, readOnlyObjectTypes);
        for (IdentityObjectTypeMetaData identityObjectTypeMetaData : this.configurationMD.getSupportedIdentityTypes()) {
            HashMap<String, IdentityObjectAttributeMetaData> metadataMap = new HashMap<String, IdentityObjectAttributeMetaData>();
            for (IdentityObjectAttributeMetaData attributeMetaData : identityObjectTypeMetaData.getAttributes()) {
                metadataMap.put(attributeMetaData.getName(), attributeMetaData);
            }
            this.attributesMetaData.put(identityObjectTypeMetaData.getName(), metadataMap);
        }
    }

    @Override
    public IdentityStoreSession createIdentityStoreSession() {
        return new LDAPIdentityStoreSessionImpl("com.sun.jndi.ldap.LdapCtxFactory", this.configuration.getProviderURL(), "simple", this.configuration.getAdminDN(), this.configuration.getAdminPassword());
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public FeaturesMetaData getSupportedFeatures() {
        return this.supportedFeatures;
    }

    @Override
    public IdentityObject createIdentityObject(IdentityStoreInvocationContext invocationCtx, String name, IdentityObjectType identityObjectType) throws IdentityException {
        return this.createIdentityObject(invocationCtx, name, identityObjectType, null);
    }

    @Override
    public IdentityObject createIdentityObject(IdentityStoreInvocationContext invocationCtx, String name, IdentityObjectType type, Map<String, String[]> attributes) throws IdentityException {
        if (name == null) {
            throw new IdentityException("Name cannot be null");
        }
        this.checkIOType(type);
        if (log.isLoggable(Level.FINER)) {
            log.finer(this.toString() + ".createIdentityObject with name: " + name + " and type: " + type.getName());
        }
        LdapContext ldapContext = this.getLDAPContext(invocationCtx);
        try {
            LdapContext ctx = (LdapContext)ldapContext.lookup(this.getTypeConfiguration(invocationCtx, type).getCtxDNs()[0]);
            BasicAttributes attrs = new BasicAttributes(true);
            Map<String, String[]> attributesToAdd = this.getTypeConfiguration(invocationCtx, type).getCreateEntryAttributeValues();
            if (attributes != null) {
                for (Map.Entry<String, String[]> entry : attributes.entrySet()) {
                    if (!attributesToAdd.containsKey(entry.getKey())) {
                        attributesToAdd.put(entry.getKey(), entry.getValue());
                        continue;
                    }
                    List<Object> list1 = Arrays.asList((Object[])attributesToAdd.get(entry.getKey()));
                    List<Object> list2 = Arrays.asList((Object[])entry.getValue());
                    list1.addAll(list2);
                    String[] vals = list1.toArray(new String[list1.size()]);
                    attributesToAdd.put(entry.getKey(), vals);
                }
            }
            for (String attributeName : attributesToAdd.keySet()) {
                String[] attributeValues;
                BasicAttribute attr = new BasicAttribute(attributeName);
                for (String attrValue : attributeValues = attributesToAdd.get(attributeName)) {
                    attr.add(attrValue);
                }
                attrs.put(attr);
            }
            LdapName validLDAPName = new LdapName(this.getTypeConfiguration(invocationCtx, type).getIdAttributeName().concat("=").concat(name));
            log.finer("creating ldap entry for: " + validLDAPName + "; " + attrs);
            ctx.createSubcontext(validLDAPName, (Attributes)attrs);
        }
        catch (Exception e) {
            throw new IdentityException("Failed to create identity object", e);
        }
        finally {
            try {
                ldapContext.close();
            }
            catch (NamingException e) {
                throw new IdentityException("Failed to close LDAP connection", e);
            }
        }
        return this.findIdentityObject(invocationCtx, name, type);
    }

    @Override
    public void removeIdentityObject(IdentityStoreInvocationContext invocationCtx, IdentityObject identity) throws IdentityException {
        LDAPIdentityObjectImpl ldapIdentity;
        String dn;
        if (log.isLoggable(Level.FINER)) {
            log.finer(this.toString() + ".removeIdentityObject: " + identity);
        }
        if ((dn = (ldapIdentity = this.getSafeLDAPIO(invocationCtx, identity)).getDn()) == null) {
            throw new IdentityException("Cannot obtain DN of identity");
        }
        LdapContext ldapContext = this.getLDAPContext(invocationCtx);
        try {
            log.finer("removing entry: " + dn);
            ldapContext.unbind(dn);
        }
        catch (Exception e) {
            throw new IdentityException("Failed to remove identity: ", e);
        }
        finally {
            try {
                ldapContext.close();
            }
            catch (NamingException e) {
                throw new IdentityException("Failed to close LDAP connection", e);
            }
        }
    }

    @Override
    public int getIdentityObjectsCount(IdentityStoreInvocationContext ctx, IdentityObjectType identityType) throws IdentityException {
        if (log.isLoggable(Level.FINER)) {
            log.finer(this.toString() + ".getIdentityObjectsCount for type: " + identityType);
        }
        this.checkIOType(identityType);
        try {
            String filter = this.getTypeConfiguration(ctx, identityType).getEntrySearchFilter();
            filter = filter != null && filter.length() > 0 ? filter.replaceAll("\\{0\\}", "*") : "(".concat(this.getTypeConfiguration(ctx, identityType).getIdAttributeName()).concat("=").concat("*").concat(")");
            String[] entryCtxs = this.getTypeConfiguration(ctx, identityType).getCtxDNs();
            List<SearchResult> sr = this.searchIdentityObjects(ctx, entryCtxs, filter, null, new String[]{this.getTypeConfiguration(ctx, identityType).getIdAttributeName()}, null);
            return sr.size();
        }
        catch (NoSuchElementException e) {
        }
        catch (Exception e) {
            throw new IdentityException("User search failed.", e);
        }
        return 0;
    }

    @Override
    public IdentityObject findIdentityObject(IdentityStoreInvocationContext invocationCtx, String name, IdentityObjectType type) throws IdentityException {
        if (log.isLoggable(Level.FINER)) {
            log.finer(this.toString() + ".findIdentityObject with name: " + name + "; and type: " + type);
        }
        Context ctx = null;
        this.checkIOType(type);
        try {
            if (name == null) {
                throw new IdentityException("Identity object name canot be null");
            }
            String filter = this.getTypeConfiguration(invocationCtx, type).getEntrySearchFilter();
            List<SearchResult> sr = null;
            String[] entryCtxs = this.getTypeConfiguration(invocationCtx, type).getCtxDNs();
            if (filter != null && filter.length() > 0) {
                Object[] filterArgs = new Object[]{name};
                sr = this.searchIdentityObjects(invocationCtx, entryCtxs, filter, filterArgs, new String[]{this.getTypeConfiguration(invocationCtx, type).getIdAttributeName()}, null);
            } else {
                filter = "(".concat(this.getTypeConfiguration(invocationCtx, type).getIdAttributeName()).concat("=").concat(name).concat(")");
                sr = this.searchIdentityObjects(invocationCtx, entryCtxs, filter, null, new String[]{this.getTypeConfiguration(invocationCtx, type).getIdAttributeName()}, null);
            }
            if (sr.size() > 1) {
                throw new IdentityException("Found more than one identity object with name: " + name + "; Posible data inconsistency");
            }
            SearchResult res = sr.iterator().next();
            ctx = (Context)res.getObject();
            String dn = ctx.getNameInNamespace();
            LDAPIdentityObjectImpl io = this.createIdentityObjectInstance(invocationCtx, type, res.getAttributes(), dn);
            ctx.close();
            LDAPIdentityObjectImpl lDAPIdentityObjectImpl = io;
            return lDAPIdentityObjectImpl;
        }
        catch (NoSuchElementException e) {
            try {
                if (ctx != null) {
                    ctx.close();
                }
            }
            catch (NamingException e2) {
                throw new IdentityException("Failed to close LDAP connection", e2);
            }
        }
        catch (NamingException e) {
            throw new IdentityException("IdentityObject search failed.", e);
        }
        finally {
            try {
                if (ctx != null) {
                    ctx.close();
                }
            }
            catch (NamingException e) {
                throw new IdentityException("Failed to close LDAP connection", e);
            }
        }
        return null;
    }

    @Override
    public IdentityObject findIdentityObject(IdentityStoreInvocationContext ctx, String id) throws IdentityException {
        if (log.isLoggable(Level.FINER)) {
            log.finer(this.toString() + ".findIdentityObject with id: " + id);
        }
        LdapContext ldapContext = this.getLDAPContext(ctx);
        try {
            IdentityObjectType[] possibleTypes;
            if (id == null) {
                throw new IdentityException("identity id cannot be null");
            }
            String dn = id;
            IdentityObjectType type = null;
            for (IdentityObjectType possibleType : possibleTypes = this.getConfiguration(ctx).getConfiguredTypes()) {
                String[] typeCtxs;
                for (String typeCtx : typeCtxs = this.getTypeConfiguration(ctx, possibleType).getCtxDNs()) {
                    if (!dn.endsWith(typeCtx)) continue;
                    type = possibleType;
                    break;
                }
                if (type != null) break;
            }
            if (type == null) {
                throw new IdentityException("Cannot recognize identity object type by its DN: " + dn);
            }
            Attributes attrs = ldapContext.getAttributes(dn);
            if (attrs == null) {
                throw new IdentityException("Can't find identity entry with DN: " + dn);
            }
            LDAPIdentityObjectImpl lDAPIdentityObjectImpl = this.createIdentityObjectInstance(ctx, type, attrs, dn);
            return lDAPIdentityObjectImpl;
        }
        catch (NoSuchElementException e) {
            try {
                ldapContext.close();
            }
            catch (NamingException e2) {
                throw new IdentityException("Failed to close LDAP connection", e2);
            }
        }
        catch (NamingException e) {
            throw new IdentityException("Identity object search failed.", e);
        }
        finally {
            try {
                ldapContext.close();
            }
            catch (NamingException e) {
                throw new IdentityException("Failed to close LDAP connection", e);
            }
        }
        return null;
    }

    @Override
    public Collection<IdentityObject> findIdentityObject(IdentityStoreInvocationContext invocationCtx, IdentityObjectType type, IdentityObjectSearchCriteria criteria) throws IdentityException {
        String nameFilter = "*";
        if (criteria != null && criteria.getFilter() != null) {
            nameFilter = criteria.getFilter();
        }
        LdapContext ctx = this.getLDAPContext(invocationCtx);
        this.checkIOType(type);
        LinkedList objects = new LinkedList();
        LDAPIdentityObjectTypeConfiguration typeConfiguration = this.getTypeConfiguration(invocationCtx, type);
        try {
            Control[] requestControls = null;
            if (criteria != null && criteria.isSorted()) {
                requestControls = new Control[]{new SortControl(typeConfiguration.getIdAttributeName(), false)};
            }
            StringBuilder af = new StringBuilder();
            if (criteria != null && criteria.isFiltered()) {
                af.append("(&");
                for (Map.Entry<String, String[]> stringEntry : criteria.getValues().entrySet()) {
                    for (String value : stringEntry.getValue()) {
                        af.append("(").append(stringEntry.getKey()).append("=").append(value).append(")");
                    }
                }
                af.append(")");
            }
            String filter = this.getTypeConfiguration(invocationCtx, type).getEntrySearchFilter();
            List<SearchResult> sr = null;
            String[] entryCtxs = this.getTypeConfiguration(invocationCtx, type).getCtxDNs();
            if (filter != null && filter.length() > 0) {
                Object[] filterArgs = new Object[]{nameFilter};
                sr = this.searchIdentityObjects(invocationCtx, entryCtxs, "(&(" + filter + ")" + af.toString() + ")", filterArgs, new String[]{typeConfiguration.getIdAttributeName()}, requestControls);
            } else {
                filter = "(".concat(typeConfiguration.getIdAttributeName()).concat("=").concat(nameFilter).concat(")");
                sr = this.searchIdentityObjects(invocationCtx, entryCtxs, "(&(" + filter + ")" + af.toString() + ")", null, new String[]{typeConfiguration.getIdAttributeName()}, requestControls);
            }
            for (SearchResult res : sr) {
                ctx = (LdapContext)res.getObject();
                String dn = ctx.getNameInNamespace();
                if (criteria != null && criteria.isSorted()) {
                    if (!criteria.isAscending()) {
                        objects.addFirst(this.createIdentityObjectInstance(invocationCtx, type, res.getAttributes(), dn));
                        continue;
                    }
                    objects.addLast(this.createIdentityObjectInstance(invocationCtx, type, res.getAttributes(), dn));
                    continue;
                }
                objects.add(this.createIdentityObjectInstance(invocationCtx, type, res.getAttributes(), dn));
            }
            ctx.close();
        }
        catch (NoSuchElementException e) {
            try {
                if (ctx != null) {
                    ctx.close();
                }
            }
            catch (NamingException e2) {
                throw new IdentityException("Failed to close LDAP connection", e2);
            }
        }
        catch (Exception e) {
            throw new IdentityException("IdentityObject search failed.", e);
        }
        finally {
            try {
                if (ctx != null) {
                    ctx.close();
                }
            }
            catch (NamingException e) {
                throw new IdentityException("Failed to close LDAP connection", e);
            }
        }
        if (criteria != null && criteria.isPaged()) {
            objects = (LinkedList)this.cutPageFromResults(objects, criteria);
        }
        return objects;
    }

    public Collection<IdentityObject> findIdentityObject(IdentityStoreInvocationContext invocationCtx, IdentityObjectType type) throws IdentityException {
        return this.findIdentityObject(invocationCtx, type, null);
    }

    @Override
    public Collection<IdentityObject> findIdentityObject(IdentityStoreInvocationContext ctx, IdentityObject identity, IdentityObjectRelationshipType relationshipType, boolean parent, IdentityObjectSearchCriteria criteria) throws IdentityException {
        LDAPIdentityObjectImpl ldapFromIO = this.getSafeLDAPIO(ctx, identity);
        LDAPIdentityObjectTypeConfiguration typeConfig = this.getTypeConfiguration(ctx, identity.getIdentityType());
        LdapContext ldapContext = this.getLDAPContext(ctx);
        List<IdentityObject> objects = new LinkedList<IdentityObject>();
        try {
            if (parent) {
                if (typeConfig.getMembershipAttributeName() == null) {
                    throw new IdentityException("Membership attribute name not configured. Given IdentityObjectType cannot havemembers: " + identity.getIdentityType().getName());
                }
                Attributes attrs = ldapContext.getAttributes(ldapFromIO.getDn());
                Attribute member = attrs.get(typeConfig.getMembershipAttributeName());
                if (member != null) {
                    NamingEnumeration<?> memberValues = member.getAll();
                    while (memberValues.hasMoreElements()) {
                        String memberRef = memberValues.nextElement().toString();
                        if (typeConfig.isMembershipAttributeDN()) {
                            if (criteria != null && criteria.getFilter() != null) {
                                String name = Tools.stripDnToName(memberRef);
                                String regex = Tools.wildcardToRegex(criteria.getFilter());
                                if (!Pattern.matches(regex, name)) continue;
                                objects.add(this.findIdentityObject(ctx, memberRef));
                                continue;
                            }
                            objects.add(this.findIdentityObject(ctx, memberRef));
                            continue;
                        }
                        throw new NotYetImplementedException("LDAP limitation. If relationship targets are not refered with FQDNs and only names, it's not possible to map them to proper IdentityType and keep name uniqnes per type. Workaround needed");
                    }
                }
            } else {
                for (IdentityObjectType parentType : this.configuration.getConfiguredTypes()) {
                    this.checkIOType(parentType);
                    LDAPIdentityObjectTypeConfiguration parentTypeConfiguration = this.getTypeConfiguration(ctx, parentType);
                    List<String> allowedTypes = Arrays.asList(parentTypeConfiguration.getAllowedMembershipTypes());
                    if (!allowedTypes.contains(identity.getIdentityType().getName())) continue;
                    String nameFilter = "*";
                    if (criteria != null && criteria.getFilter() != null) {
                        nameFilter = criteria.getFilter();
                    }
                    Control[] requestControls = null;
                    StringBuilder af = new StringBuilder();
                    if (criteria != null && criteria.isFiltered()) {
                        af.append("(&");
                        for (Map.Entry<String, String[]> stringEntry : criteria.getValues().entrySet()) {
                            for (String value : stringEntry.getValue()) {
                                af.append("(").append(stringEntry.getKey()).append("=").append(value).append(")");
                            }
                        }
                        af.append(")");
                    }
                    af.append("(").append(parentTypeConfiguration.getMembershipAttributeName()).append("=");
                    if (parentTypeConfiguration.isMembershipAttributeDN()) {
                        af.append(ldapFromIO.getDn());
                    } else {
                        af.append(ldapFromIO.getName());
                    }
                    af.append(")");
                    String filter = parentTypeConfiguration.getEntrySearchFilter();
                    List<SearchResult> sr = null;
                    String[] entryCtxs = parentTypeConfiguration.getCtxDNs();
                    if (filter != null && filter.length() > 0) {
                        Object[] filterArgs = new Object[]{nameFilter};
                        sr = this.searchIdentityObjects(ctx, entryCtxs, "(&(" + filter + ")" + af.toString() + ")", filterArgs, new String[]{parentTypeConfiguration.getIdAttributeName()}, requestControls);
                    } else {
                        filter = "(".concat(parentTypeConfiguration.getIdAttributeName()).concat("=").concat(nameFilter).concat(")");
                        sr = this.searchIdentityObjects(ctx, entryCtxs, "(&(" + filter + ")" + af.toString() + ")", null, new String[]{parentTypeConfiguration.getIdAttributeName()}, requestControls);
                    }
                    for (SearchResult res : sr) {
                        LdapContext ldapCtx = (LdapContext)res.getObject();
                        String dn = ldapCtx.getNameInNamespace();
                        objects.add(this.createIdentityObjectInstance(ctx, parentType, res.getAttributes(), dn));
                    }
                }
            }
        }
        catch (NamingException e) {
            throw new IdentityException("Failed to resolve relationship", e);
        }
        finally {
            try {
                ldapContext.close();
            }
            catch (NamingException e) {
                throw new IdentityException("Failed to close LDAP connection", e);
            }
        }
        if (criteria != null && criteria.isPaged()) {
            objects = this.cutPageFromResults(objects, criteria);
        }
        if (criteria != null && criteria.isSorted()) {
            this.sortByName(objects, criteria.isAscending());
        }
        return objects;
    }

    @Override
    public Set<IdentityObjectRelationship> resolveRelationships(IdentityStoreInvocationContext ctx, IdentityObject identity, IdentityObjectRelationshipType type, boolean parent, boolean named, String name) throws IdentityException {
        LDAPIdentityObjectImpl ldapIO = this.getSafeLDAPIO(ctx, identity);
        LDAPIdentityObjectTypeConfiguration typeConfig = this.getTypeConfiguration(ctx, identity.getIdentityType());
        LdapContext ldapContext = this.getLDAPContext(ctx);
        HashSet<IdentityObjectRelationship> relationships = new HashSet<IdentityObjectRelationship>();
        try {
            if (parent) {
                Attributes attrs = ldapContext.getAttributes(ldapIO.getDn());
                Attribute member = attrs.get(typeConfig.getMembershipAttributeName());
                if (member != null) {
                    NamingEnumeration<?> memberValues = member.getAll();
                    while (memberValues.hasMoreElements()) {
                        String memberRef = memberValues.nextElement().toString();
                        if (typeConfig.isMembershipAttributeDN()) {
                            relationships.add(new LDAPIdentityObjectRelationshipImpl(null, ldapIO, this.findIdentityObject(ctx, memberRef)));
                            continue;
                        }
                        throw new NotYetImplementedException("LDAP limitation. If relationship targets are not refered with FQDNs and only names, it's not possible to map them to proper IdentityType and keep name uniqnes per type. Workaround needed");
                    }
                }
            } else {
                for (IdentityObjectType parentType : this.configuration.getConfiguredTypes()) {
                    this.checkIOType(parentType);
                    LDAPIdentityObjectTypeConfiguration parentTypeConfiguration = this.getTypeConfiguration(ctx, parentType);
                    List<String> allowedTypes = Arrays.asList(parentTypeConfiguration.getAllowedMembershipTypes());
                    if (!allowedTypes.contains(identity.getIdentityType().getName())) continue;
                    String nameFilter = "*";
                    Control[] requestControls = null;
                    StringBuilder af = new StringBuilder();
                    af.append("(").append(parentTypeConfiguration.getMembershipAttributeName()).append("=");
                    if (parentTypeConfiguration.isMembershipAttributeDN()) {
                        af.append(ldapIO.getDn());
                    } else {
                        af.append(ldapIO.getName());
                    }
                    af.append(")");
                    String filter = parentTypeConfiguration.getEntrySearchFilter();
                    List<SearchResult> sr = null;
                    String[] entryCtxs = parentTypeConfiguration.getCtxDNs();
                    if (filter != null && filter.length() > 0) {
                        Object[] filterArgs = new Object[]{nameFilter};
                        sr = this.searchIdentityObjects(ctx, entryCtxs, "(&(" + filter + ")" + af.toString() + ")", filterArgs, new String[]{parentTypeConfiguration.getIdAttributeName()}, requestControls);
                    } else {
                        filter = "(".concat(parentTypeConfiguration.getIdAttributeName()).concat("=").concat(nameFilter).concat(")");
                        sr = this.searchIdentityObjects(ctx, entryCtxs, "(&(" + filter + ")" + af.toString() + ")", null, new String[]{parentTypeConfiguration.getIdAttributeName()}, requestControls);
                    }
                    for (SearchResult res : sr) {
                        LdapContext ldapCtx = (LdapContext)res.getObject();
                        String dn = ldapCtx.getNameInNamespace();
                        relationships.add(new LDAPIdentityObjectRelationshipImpl(null, this.createIdentityObjectInstance(ctx, parentType, res.getAttributes(), dn), ldapIO));
                    }
                }
            }
        }
        catch (NamingException e) {
            throw new IdentityException("Failed to resolve relationship", e);
        }
        finally {
            try {
                ldapContext.close();
            }
            catch (NamingException e) {
                throw new IdentityException("Failed to close LDAP connection", e);
            }
        }
        return relationships;
    }

    public Collection<IdentityObject> findIdentityObject(IdentityStoreInvocationContext ctx, IdentityObject identity, IdentityObjectRelationshipType relationshipType, boolean parent) throws IdentityException {
        return this.findIdentityObject(ctx, identity, relationshipType, parent, null);
    }

    @Override
    public IdentityObjectRelationship createRelationship(IdentityStoreInvocationContext ctx, IdentityObject fromIdentity, IdentityObject toIdentity, IdentityObjectRelationshipType relationshipType, String name, boolean createNames) throws IdentityException {
        if (log.isLoggable(Level.FINER)) {
            log.finer(this.toString() + ".createRelationship with " + "fromIdentity: " + fromIdentity + "; toIdentity: " + toIdentity + "; relationshipType: " + relationshipType);
        }
        LDAPIdentityObjectRelationshipImpl relationship = null;
        LDAPIdentityObjectImpl ldapFromIO = this.getSafeLDAPIO(ctx, fromIdentity);
        LDAPIdentityObjectImpl ldapToIO = this.getSafeLDAPIO(ctx, toIdentity);
        LDAPIdentityObjectTypeConfiguration fromTypeConfig = this.getTypeConfiguration(ctx, fromIdentity.getIdentityType());
        LdapContext ldapContext = this.getLDAPContext(ctx);
        if (!this.getSupportedFeatures().isRelationshipTypeSupported(fromIdentity.getIdentityType(), toIdentity.getIdentityType(), relationshipType)) {
            throw new IdentityException("Relationship not supported. RelationshipType[ " + relationshipType + " ] " + "beetween: [ " + fromIdentity.getIdentityType().getName() + " ] and [ " + toIdentity.getIdentityType().getName() + " ]");
        }
        try {
            BasicAttributes attrs = new BasicAttributes(true);
            BasicAttribute member = new BasicAttribute(fromTypeConfig.getMembershipAttributeName());
            if (fromTypeConfig.isMembershipAttributeDN()) {
                member.add(ldapToIO.getDn());
            } else {
                member.add(toIdentity.getName());
            }
            attrs.put(member);
            ldapContext.modifyAttributes(ldapFromIO.getDn(), 1, (Attributes)attrs);
            relationship = new LDAPIdentityObjectRelationshipImpl(name, ldapFromIO, ldapToIO);
        }
        catch (NamingException e) {
            throw new IdentityException("Failed to create relationship", e);
        }
        finally {
            try {
                ldapContext.close();
            }
            catch (NamingException e) {
                throw new IdentityException("Failed to close LDAP connection", e);
            }
        }
        return relationship;
    }

    @Override
    public void removeRelationship(IdentityStoreInvocationContext ctx, IdentityObject fromIdentity, IdentityObject toIdentity, IdentityObjectRelationshipType relationshipType, String name) throws IdentityException {
        if (log.isLoggable(Level.FINER)) {
            log.finer(this.toString() + ".removeRelationship with " + "fromIdentity: " + fromIdentity + "; toIdentity: " + toIdentity + "; relationshipType: " + relationshipType);
        }
        LDAPIdentityObjectImpl ldapFromIO = this.getSafeLDAPIO(ctx, fromIdentity);
        LDAPIdentityObjectImpl ldapToIO = this.getSafeLDAPIO(ctx, toIdentity);
        LDAPIdentityObjectTypeConfiguration fromTypeConfig = this.getTypeConfiguration(ctx, fromIdentity.getIdentityType());
        if (!Arrays.asList(fromTypeConfig.getAllowedMembershipTypes()).contains(ldapToIO.getIdentityType().getName())) {
            return;
        }
        LdapContext ldapContext = this.getLDAPContext(ctx);
        if (relationshipType != null && !this.getSupportedFeatures().isRelationshipTypeSupported(fromIdentity.getIdentityType(), toIdentity.getIdentityType(), relationshipType)) {
            throw new IdentityException("Relationship not supported");
        }
        try {
            BasicAttributes attrs = new BasicAttributes(true);
            BasicAttribute member = new BasicAttribute(fromTypeConfig.getMembershipAttributeName());
            if (fromTypeConfig.isMembershipAttributeDN()) {
                member.add(ldapToIO.getDn());
            } else {
                member.add(toIdentity.getName());
            }
            attrs.put(member);
            ldapContext.modifyAttributes(ldapFromIO.getDn(), 3, (Attributes)attrs);
        }
        catch (NamingException e) {
            throw new IdentityException("Failed to remove relationship", e);
        }
        finally {
            try {
                ldapContext.close();
            }
            catch (NamingException e) {
                throw new IdentityException("Failed to close LDAP connection", e);
            }
        }
    }

    @Override
    public void removeRelationships(IdentityStoreInvocationContext ctx, IdentityObject identity1, IdentityObject identity2, boolean named) throws IdentityException {
        if (log.isLoggable(Level.FINER)) {
            log.finer(this.toString() + ".removeRelationships with " + "identity1: " + identity1 + "; identity2: " + identity2);
        }
        this.removeRelationship(ctx, identity1, identity2, null, null);
        this.removeRelationship(ctx, identity2, identity1, null, null);
    }

    @Override
    public Set<IdentityObjectRelationship> resolveRelationships(IdentityStoreInvocationContext ctx, IdentityObject fromIdentity, IdentityObject toIdentity, IdentityObjectRelationshipType relationshipType) throws IdentityException {
        if (log.isLoggable(Level.FINER)) {
            log.finer(this.toString() + ".resolveRelationships with " + "fromIdentity: " + fromIdentity + "; toIdentity: " + toIdentity);
        }
        HashSet<IdentityObjectRelationship> relationships = new HashSet<IdentityObjectRelationship>();
        LDAPIdentityObjectImpl ldapFromIO = this.getSafeLDAPIO(ctx, fromIdentity);
        LDAPIdentityObjectImpl ldapToIO = this.getSafeLDAPIO(ctx, toIdentity);
        LDAPIdentityObjectTypeConfiguration fromTypeConfig = this.getTypeConfiguration(ctx, fromIdentity.getIdentityType());
        if (!Arrays.asList(fromTypeConfig.getAllowedMembershipTypes()).contains(ldapToIO.getIdentityType().getName())) {
            return relationships;
        }
        LdapContext ldapContext = this.getLDAPContext(ctx);
        try {
            Attributes attrs = ldapContext.getAttributes(ldapFromIO.getDn());
            Attribute member = attrs.get(fromTypeConfig.getMembershipAttributeName());
            if (member != null) {
                NamingEnumeration<?> memberValues = member.getAll();
                while (memberValues.hasMoreElements()) {
                    String memberRef = memberValues.nextElement().toString();
                    if ((!fromTypeConfig.isMembershipAttributeDN() || !memberRef.equals(ldapToIO.getDn())) && (fromTypeConfig.isMembershipAttributeDN() || !memberRef.equals(ldapToIO.getName()))) continue;
                    relationships.add(new LDAPIdentityObjectRelationshipImpl(null, ldapFromIO, ldapToIO));
                }
            }
        }
        catch (NamingException e) {
            throw new IdentityException("Failed to resolve relationship", e);
        }
        finally {
            try {
                ldapContext.close();
            }
            catch (NamingException e) {
                throw new IdentityException("Failed to close LDAP connection", e);
            }
        }
        return relationships;
    }

    @Override
    public String createRelationshipName(IdentityStoreInvocationContext ctx, String name) throws IdentityException, OperationNotSupportedException {
        throw new OperationNotSupportedException("Named relationships are not supported by this implementation of LDAP IdentityStore");
    }

    @Override
    public String removeRelationshipName(IdentityStoreInvocationContext ctx, String name) throws IdentityException, OperationNotSupportedException {
        throw new OperationNotSupportedException("Named relationships are not supported by this implementation of LDAP IdentityStore");
    }

    @Override
    public Set<String> getRelationshipNames(IdentityStoreInvocationContext ctx, IdentityObjectSearchCriteria criteria) throws IdentityException, OperationNotSupportedException {
        throw new OperationNotSupportedException("Named relationships are not supported by this implementation of LDAP IdentityStore");
    }

    public Set<String> getRelationshipNames(IdentityStoreInvocationContext ctx) throws IdentityException, OperationNotSupportedException {
        throw new OperationNotSupportedException("Named relationships are not supported by this implementation of LDAP IdentityStore");
    }

    @Override
    public Set<String> getRelationshipNames(IdentityStoreInvocationContext ctx, IdentityObject identity, IdentityObjectSearchCriteria criteria) throws IdentityException, OperationNotSupportedException {
        throw new OperationNotSupportedException("Named relationships are not supported by this implementation of LDAP IdentityStore");
    }

    public Set<String> getRelationshipNames(IdentityStoreInvocationContext ctx, IdentityObject identity) throws IdentityException, OperationNotSupportedException {
        throw new OperationNotSupportedException("Named relationships are not supported by this implementation of LDAP IdentityStore");
    }

    @Override
    public Map<String, String> getRelationshipNameProperties(IdentityStoreInvocationContext ctx, String name) throws IdentityException, OperationNotSupportedException {
        throw new OperationNotSupportedException("Named relationships are not supported by this implementation of LDAP IdentityStore");
    }

    @Override
    public void setRelationshipNameProperties(IdentityStoreInvocationContext ctx, String name, Map<String, String> properties) throws IdentityException, OperationNotSupportedException {
        throw new OperationNotSupportedException("Named relationships are not supported by this implementation of LDAP IdentityStore");
    }

    @Override
    public void removeRelationshipNameProperties(IdentityStoreInvocationContext ctx, String name, Set<String> properties) throws IdentityException, OperationNotSupportedException {
        throw new OperationNotSupportedException("Named relationships are not supported by this implementation of LDAP IdentityStore");
    }

    @Override
    public Map<String, String> getRelationshipProperties(IdentityStoreInvocationContext ctx, IdentityObjectRelationship relationship) throws IdentityException, OperationNotSupportedException {
        throw new OperationNotSupportedException("Relationship properties are not supported by this implementation of LDAP IdentityStore");
    }

    @Override
    public void setRelationshipProperties(IdentityStoreInvocationContext ctx, IdentityObjectRelationship relationship, Map<String, String> properties) throws IdentityException, OperationNotSupportedException {
        throw new OperationNotSupportedException("Relationship properties are not supported by this implementation of LDAP IdentityStore");
    }

    @Override
    public void removeRelationshipProperties(IdentityStoreInvocationContext ctx, IdentityObjectRelationship relationship, Set<String> properties) throws IdentityException, OperationNotSupportedException {
        throw new OperationNotSupportedException("Relationship properties are not supported by this implementation of LDAP IdentityStore");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean validateCredential(IdentityStoreInvocationContext ctx, IdentityObject identityObject, IdentityObjectCredential credential) throws IdentityException {
        if (credential == null) {
            throw new IllegalArgumentException();
        }
        LDAPIdentityObjectImpl ldapIO = this.getSafeLDAPIO(ctx, identityObject);
        if (this.supportedFeatures.isCredentialSupported(ldapIO.getIdentityType(), credential.getType())) {
            String passwordString = null;
            if (credential.getValue() == null) {
                throw new IdentityException("Null password value");
            }
            passwordString = credential.getValue().toString();
            LdapContext ldapContext = this.getLDAPContext(ctx);
            try {
                Hashtable<?, ?> env = ldapContext.getEnvironment();
                env.put("java.naming.security.principal", ldapIO.getDn());
                env.put("java.naming.security.credentials", passwordString);
                InitialLdapContext initialCtx = new InitialLdapContext(env, null);
                if (initialCtx != null) {
                    initialCtx.close();
                    boolean bl = true;
                    return bl;
                }
            }
            catch (NamingException e) {
                try {
                    ldapContext.close();
                }
                catch (NamingException e2) {
                    throw new IdentityException("Failed to close LDAP connection", e2);
                }
            }
            finally {
                try {
                    ldapContext.close();
                }
                catch (NamingException e) {
                    throw new IdentityException("Failed to close LDAP connection", e);
                }
            }
            return false;
        }
        throw new IdentityException("CredentialType not supported for a given IdentityObjectType");
    }

    @Override
    public void updateCredential(IdentityStoreInvocationContext ctx, IdentityObject identityObject, IdentityObjectCredential credential) throws IdentityException {
        if (credential == null) {
            throw new IllegalArgumentException();
        }
        LDAPIdentityObjectImpl ldapIO = this.getSafeLDAPIO(ctx, identityObject);
        if (this.supportedFeatures.isCredentialSupported(ldapIO.getIdentityType(), credential.getType())) {
            String passwordString = null;
            if (credential.getValue() == null) {
                throw new IdentityException("Null password value");
            }
            passwordString = credential.getValue().toString();
            String attributeName = this.getTypeConfiguration(ctx, ldapIO.getIdentityType()).getPasswordAttributeName();
            if (attributeName == null) {
                throw new IdentityException("IdentityType doesn't have passwordAttributeName option set: " + ldapIO.getIdentityType().getName());
            }
            LdapContext ldapContext = this.getLDAPContext(ctx);
            try {
                BasicAttributes attrs = new BasicAttributes(true);
                BasicAttribute attr = new BasicAttribute(attributeName);
                attr.add(passwordString);
                attrs.put(attr);
                ldapContext.modifyAttributes(ldapIO.getDn(), 2, (Attributes)attrs);
            }
            catch (NamingException e) {
                throw new IdentityException("Cannot set identity password value.", e);
            }
            finally {
                try {
                    ldapContext.close();
                }
                catch (NamingException e) {
                    throw new IdentityException("Failed to close LDAP connection", e);
                }
            }
        }
        throw new IdentityException("CredentialType not supported for a given IdentityObjectType");
    }

    @Override
    public Set<String> getSupportedAttributeNames(IdentityStoreInvocationContext invocationContext, IdentityObjectType identityType) throws IdentityException {
        if (log.isLoggable(Level.FINER)) {
            log.finer(this.toString() + ".getSupportedAttributeNames with " + "identityType: " + identityType);
        }
        this.checkIOType(identityType);
        return this.getTypeConfiguration(invocationContext, identityType).getMappedAttributesNames();
    }

    @Override
    public Map<String, IdentityObjectAttributeMetaData> getAttributesMetaData(IdentityStoreInvocationContext invocationContext, IdentityObjectType identityObjectType) {
        return this.attributesMetaData.get(identityObjectType.getName());
    }

    @Override
    public IdentityObjectAttribute getAttribute(IdentityStoreInvocationContext invocationContext, IdentityObject identity, String name) throws IdentityException {
        return this.getAttributes(invocationContext, identity).get(name);
    }

    @Override
    public Map<String, IdentityObjectAttribute> getAttributes(IdentityStoreInvocationContext ctx, IdentityObject identity) throws IdentityException {
        if (log.isLoggable(Level.FINER)) {
            log.finer(this.toString() + ".getAttributes with " + "identity: " + identity);
        }
        HashMap<String, IdentityObjectAttribute> attrsMap = new HashMap<String, IdentityObjectAttribute>();
        LDAPIdentityObjectImpl ldapIdentity = this.getSafeLDAPIO(ctx, identity);
        LdapContext ldapContext = this.getLDAPContext(ctx);
        try {
            Set<String> mappedNames = this.getTypeConfiguration(ctx, identity.getIdentityType()).getMappedAttributesNames();
            String dn = ldapIdentity.getDn();
            Attributes attrs = ldapContext.getAttributes(dn);
            for (String name : mappedNames) {
                String attrName = this.getTypeConfiguration(ctx, identity.getIdentityType()).getAttributeMapping(name);
                Attribute attr = attrs.get(attrName);
                if (attr != null) {
                    SimpleAttribute identityObjectAttribute = new SimpleAttribute(name);
                    NamingEnumeration<?> values = attr.getAll();
                    while (values.hasMoreElements()) {
                        identityObjectAttribute.addValue(values.nextElement().toString());
                    }
                    attrsMap.put(name, identityObjectAttribute);
                    continue;
                }
                log.fine("No such attribute ('" + attrName + "') in entry: " + dn);
            }
        }
        catch (NamingException e) {
            throw new IdentityException("Cannot get attributes value.", e);
        }
        finally {
            try {
                ldapContext.close();
            }
            catch (NamingException e) {
                throw new IdentityException("Failed to close LDAP connection", e);
            }
        }
        return attrsMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateAttributes(IdentityStoreInvocationContext ctx, IdentityObject identity, IdentityObjectAttribute[] attributes) throws IdentityException {
        if (log.isLoggable(Level.FINER)) {
            log.finer(this.toString() + ".updateAttributes with " + "identity: " + identity + "attributes: " + attributes);
        }
        if (attributes == null) {
            throw new IllegalArgumentException("attributes is null");
        }
        LDAPIdentityObjectImpl ldapIdentity = this.getSafeLDAPIO(ctx, identity);
        String dn = ldapIdentity.getDn();
        LdapContext ldapContext = this.getLDAPContext(ctx);
        try {
            for (IdentityObjectAttribute attribute : attributes) {
                String name = attribute.getName();
                String attributeName = this.getTypeConfiguration(ctx, identity.getIdentityType()).getAttributeMapping(name);
                if (attributeName == null) {
                    log.fine("Proper LDAP attribute mapping not found for such property name: " + name);
                    continue;
                }
                BasicAttributes attrs = new BasicAttributes(true);
                BasicAttribute attr = new BasicAttribute(attributeName);
                Collection values = attribute.getValues();
                Map<String, IdentityObjectAttributeMetaData> mdMap = this.attributesMetaData.get(identity.getIdentityType().getName());
                if (mdMap != null) {
                    IdentityObject checkIdentity;
                    IdentityObjectAttributeMetaData amd = mdMap.get(attributeName);
                    if (amd != null && !amd.isMultivalued() && values.size() > 1) {
                        throw new IdentityException("Cannot assigned multiply values to single valued attribute: " + attributeName);
                    }
                    if (amd != null && amd.isReadonly()) {
                        throw new IdentityException("Cannot update readonly attribute: " + attributeName);
                    }
                    if (amd != null && amd.isUnique() && (checkIdentity = this.findIdentityObjectByUniqueAttribute(ctx, identity.getIdentityType(), attribute)) != null && !checkIdentity.getName().equals(identity.getName())) {
                        throw new IdentityException("Unique attribute '" + attribute.getName() + " value already set for identityObject: " + checkIdentity);
                    }
                }
                if (values == null) continue;
                for (Object value : values) {
                    attr.add(value);
                }
                attrs.put(attr);
                try {
                    ldapContext.modifyAttributes(dn, 2, (Attributes)attrs);
                }
                catch (NamingException e) {
                    throw new IdentityException("Cannot add attribute", e);
                }
            }
        }
        finally {
            try {
                ldapContext.close();
            }
            catch (NamingException e) {
                throw new IdentityException("Failed to close LDAP connection", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAttributes(IdentityStoreInvocationContext ctx, IdentityObject identity, IdentityObjectAttribute[] attributes) throws IdentityException {
        if (log.isLoggable(Level.FINER)) {
            log.finer(this.toString() + ".addAttributes with " + "identity: " + identity + "attributes: " + attributes);
        }
        if (attributes == null) {
            throw new IllegalArgumentException("attributes is null");
        }
        LDAPIdentityObjectImpl ldapIdentity = this.getSafeLDAPIO(ctx, identity);
        String dn = ldapIdentity.getDn();
        LdapContext ldapContext = this.getLDAPContext(ctx);
        try {
            for (IdentityObjectAttribute attribute : attributes) {
                String name = attribute.getName();
                String attributeName = this.getTypeConfiguration(ctx, identity.getIdentityType()).getAttributeMapping(name);
                if (attributeName == null) {
                    log.fine("Proper LDAP attribute mapping not found for such property name: " + name);
                    continue;
                }
                BasicAttributes attrs = new BasicAttributes(true);
                BasicAttribute attr = new BasicAttribute(attributeName);
                Collection values = attribute.getValues();
                Map<String, IdentityObjectAttributeMetaData> mdMap = this.attributesMetaData.get(identity.getIdentityType().getName());
                if (mdMap != null) {
                    IdentityObject checkIdentity;
                    IdentityObjectAttributeMetaData amd = mdMap.get(attribute.getName());
                    if (amd != null && !amd.isMultivalued() && values.size() > 1) {
                        throw new IdentityException("Cannot assigned multiply values to single valued attribute: " + attributeName);
                    }
                    if (amd != null && amd.isReadonly()) {
                        throw new IdentityException("Cannot update readonly attribute: " + attributeName);
                    }
                    if (amd != null && amd.isUnique() && (checkIdentity = this.findIdentityObjectByUniqueAttribute(ctx, identity.getIdentityType(), attribute)) != null && !checkIdentity.getName().equals(identity.getName())) {
                        throw new IdentityException("Unique attribute '" + attribute.getName() + " value already set for identityObject: " + checkIdentity);
                    }
                }
                if (values == null) continue;
                for (Object value : values) {
                    attr.add(value);
                }
                attrs.put(attr);
                try {
                    ldapContext.modifyAttributes(dn, 1, (Attributes)attrs);
                }
                catch (NamingException e) {
                    throw new IdentityException("Cannot add attribute", e);
                }
            }
        }
        finally {
            try {
                ldapContext.close();
            }
            catch (NamingException e) {
                throw new IdentityException("Failed to close LDAP connection", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAttributes(IdentityStoreInvocationContext ctx, IdentityObject identity, String[] attributeNames) throws IdentityException {
        if (log.isLoggable(Level.FINER)) {
            log.finer(this.toString() + ".removeAttributes with " + "identity: " + identity + "attributeNames: " + attributeNames);
        }
        if (attributeNames == null) {
            throw new IllegalArgumentException("attributes is null");
        }
        LDAPIdentityObjectImpl ldapIdentity = this.getSafeLDAPIO(ctx, identity);
        String dn = ldapIdentity.getDn();
        LdapContext ldapContext = this.getLDAPContext(ctx);
        try {
            for (String name : attributeNames) {
                IdentityObjectAttributeMetaData amd;
                String attributeName = this.getTypeConfiguration(ctx, identity.getIdentityType()).getAttributeMapping(name);
                if (attributeName == null) {
                    log.fine("Proper LDAP attribute mapping not found for such property name: " + name);
                    continue;
                }
                Map<String, IdentityObjectAttributeMetaData> mdMap = this.attributesMetaData.get(identity.getIdentityType().getName());
                if (mdMap != null && (amd = mdMap.get(name)) != null && amd.isRequired()) {
                    throw new IdentityException("Cannot remove required attribute: " + name);
                }
                BasicAttributes attrs = new BasicAttributes(true);
                BasicAttribute attr = new BasicAttribute(attributeName);
                attrs.put(attr);
                try {
                    ldapContext.modifyAttributes(dn, 3, (Attributes)attrs);
                }
                catch (NamingException e) {
                    throw new IdentityException("Cannot remove attribute", e);
                }
            }
        }
        finally {
            try {
                ldapContext.close();
            }
            catch (NamingException e) {
                throw new IdentityException("Failed to close LDAP connection", e);
            }
        }
    }

    @Override
    public IdentityObject findIdentityObjectByUniqueAttribute(IdentityStoreInvocationContext invocationCtx, IdentityObjectType type, IdentityObjectAttribute attribute) throws IdentityException {
        String nameFilter = "*";
        LdapContext ctx = this.getLDAPContext(invocationCtx);
        this.checkIOType(type);
        LinkedList<LDAPIdentityObjectImpl> objects = new LinkedList<LDAPIdentityObjectImpl>();
        LDAPIdentityObjectTypeConfiguration typeConfiguration = this.getTypeConfiguration(invocationCtx, type);
        String attributeName = this.getTypeConfiguration(invocationCtx, type).getAttributeMapping(attribute.getName());
        try {
            Control[] requestControls = null;
            StringBuilder af = new StringBuilder();
            af.append("(").append(attributeName).append("=").append(attribute.getValue()).append(")");
            String filter = this.getTypeConfiguration(invocationCtx, type).getEntrySearchFilter();
            List<SearchResult> sr = null;
            String[] entryCtxs = this.getTypeConfiguration(invocationCtx, type).getCtxDNs();
            if (filter != null && filter.length() > 0) {
                Object[] filterArgs = new Object[]{nameFilter};
                sr = this.searchIdentityObjects(invocationCtx, entryCtxs, "(&(" + filter + ")" + af.toString() + ")", filterArgs, new String[]{typeConfiguration.getIdAttributeName()}, requestControls);
            } else {
                filter = "(".concat(typeConfiguration.getIdAttributeName()).concat("=").concat(nameFilter).concat(")");
                sr = this.searchIdentityObjects(invocationCtx, entryCtxs, "(&(" + filter + ")" + af.toString() + ")", null, new String[]{typeConfiguration.getIdAttributeName()}, requestControls);
            }
            for (SearchResult res : sr) {
                ctx = (LdapContext)res.getObject();
                String dn = ctx.getNameInNamespace();
                objects.add(this.createIdentityObjectInstance(invocationCtx, type, res.getAttributes(), dn));
            }
            ctx.close();
        }
        catch (NoSuchElementException e) {
            try {
                if (ctx != null) {
                    ctx.close();
                }
            }
            catch (NamingException e2) {
                throw new IdentityException("Failed to close LDAP connection", e2);
            }
        }
        catch (Exception e) {
            throw new IdentityException("IdentityObject search failed.", e);
        }
        finally {
            try {
                if (ctx != null) {
                    ctx.close();
                }
            }
            catch (NamingException e) {
                throw new IdentityException("Failed to close LDAP connection", e);
            }
        }
        if (objects.size() == 0) {
            return null;
        }
        if (objects.size() > 1) {
            throw new IdentityException("Illegal state - more than one IdentityObject of same type share same unique attribute value");
        }
        return (IdentityObject)objects.get(0);
    }

    public LDAPIdentityObjectImpl createIdentityObjectInstance(IdentityStoreInvocationContext ctx, IdentityObjectType type, Attributes attrs, String dn) throws IdentityException {
        LDAPIdentityObjectImpl ldapio = null;
        try {
            String idAttrName = this.getTypeConfiguration(ctx, type).getIdAttributeName();
            Attribute ida = attrs.get(idAttrName);
            if (ida == null) {
                throw new IdentityException("LDAP entry doesn't contain proper attribute:" + idAttrName);
            }
            ldapio = new LDAPIdentityObjectImpl(dn, ida.get().toString(), type);
        }
        catch (Exception e) {
            throw new IdentityException("Couldn't create LDAPIdentityObjectImpl object from ldap entry (SearchResult)", e);
        }
        return ldapio;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SearchResult> searchIdentityObjects(IdentityStoreInvocationContext ctx, String[] entryCtxs, String filter, Object[] filterArgs, String[] returningAttributes, Control[] requestControls) throws NamingException, IdentityException {
        LdapContext ldapContext = this.getLDAPContext(ctx);
        if (ldapContext != null) {
            ldapContext.setRequestControls(requestControls);
        }
        NamingEnumeration<SearchResult> results = null;
        try {
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(1);
            searchControls.setReturningObjFlag(true);
            searchControls.setTimeLimit(this.getConfiguration(ctx).getSearchTimeLimit());
            if (returningAttributes != null) {
                searchControls.setReturningAttributes(returningAttributes);
            }
            if (entryCtxs.length == 1) {
                results = filterArgs == null ? ldapContext.search(entryCtxs[0], filter, searchControls) : ldapContext.search(entryCtxs[0], filter, filterArgs, searchControls);
                List<SearchResult> list = Tools.toList(results);
                return list;
            }
            LinkedList<SearchResult> merged = new LinkedList<SearchResult>();
            for (String entryCtx : entryCtxs) {
                results = filterArgs == null ? ldapContext.search(entryCtx, filter, searchControls) : ldapContext.search(entryCtx, filter, filterArgs, searchControls);
                merged.addAll(Tools.toList(results));
                results.close();
            }
            LinkedList<SearchResult> linkedList = merged;
            return linkedList;
        }
        finally {
            if (results != null) {
                results.close();
            }
            ldapContext.close();
        }
    }

    private LDAPIdentityObjectImpl getSafeLDAPIO(IdentityStoreInvocationContext ctx, IdentityObject io) throws IdentityException {
        if (io == null) {
            throw new IllegalArgumentException("IdentityObject is null");
        }
        if (io instanceof LDAPIdentityObjectImpl) {
            return (LDAPIdentityObjectImpl)io;
        }
        try {
            return (LDAPIdentityObjectImpl)this.findIdentityObject(ctx, io.getName(), io.getIdentityType());
        }
        catch (IdentityException e) {
            throw new IdentityException("Provided IdentityObject is not present in the store. Cannot operate on not stored objects.", e);
        }
    }

    private void checkIOType(IdentityObjectType iot) throws IdentityException {
        if (iot == null) {
            throw new IllegalArgumentException("IdentityObjectType is null");
        }
        if (!this.getSupportedFeatures().isIdentityObjectTypeSupported(iot)) {
            throw new IdentityException("IdentityType not supported by this IdentityStore implementation: " + iot);
        }
    }

    private LdapContext getLDAPContext(IdentityStoreInvocationContext ctx) throws IdentityException {
        LdapContext ldapContext = null;
        try {
            ldapContext = (LdapContext)ctx.getIdentityStoreSession().getSessionContext();
        }
        catch (Exception e) {
            throw new IdentityException("Could not obtain LDAP connection: ", e);
        }
        if (ldapContext == null) {
            throw new IdentityException("IllegalState: - Could not obtain LDAP connection");
        }
        return ldapContext;
    }

    private LDAPIdentityStoreConfiguration getConfiguration(IdentityStoreInvocationContext ctx) throws IdentityException {
        return this.configuration;
    }

    private LDAPIdentityObjectTypeConfiguration getTypeConfiguration(IdentityStoreInvocationContext ctx, IdentityObjectType type) throws IdentityException {
        return this.getConfiguration(ctx).getTypeConfiguration(type.getName());
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.getId() + "]";
    }

    private void sortByName(List<IdentityObject> objects, final boolean ascending) {
        Collections.sort(objects, new Comparator<IdentityObject>(){

            @Override
            public int compare(IdentityObject o1, IdentityObject o2) {
                if (ascending) {
                    return o1.getName().compareTo(o2.getName());
                }
                return o2.getName().compareTo(o1.getName());
            }
        });
    }

    private List<IdentityObject> cutPageFromResults(List<IdentityObject> objects, IdentityObjectSearchCriteria criteria) {
        LinkedList<IdentityObject> results = new LinkedList<IdentityObject>();
        for (int i = criteria.getFirstResult(); i < criteria.getFirstResult() + criteria.getMaxResults(); ++i) {
            if (i >= objects.size()) continue;
            results.add(objects.get(i));
        }
        return results;
    }

    static {
        supportedSearchCriteriaTypes.add(IdentityObjectSearchCriteriaType.SORT);
        supportedSearchCriteriaTypes.add(IdentityObjectSearchCriteriaType.PAGE);
        supportedSearchCriteriaTypes.add(IdentityObjectSearchCriteriaType.NAME_FILTER);
    }
}

