/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.idm.integration.jboss5;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.jboss.identity.idm.common.exception.IdentityConfigurationException;
import org.jboss.identity.idm.impl.helper.SecurityActions;
import org.jboss.identity.idm.integration.jboss5.jaxb2.JbossIDMDeployerType;

public class JAXB2IdentityDeployerConfiguration {
    private static final Logger logger = Logger.getLogger(JAXB2IdentityDeployerConfiguration.class.getName());

    public static JbossIDMDeployerType createDeployerConfiguration(InputStream inputStream) throws Exception {
        if (inputStream == null) {
            throw new NullPointerException("deployer configuration is null");
        }
        JAXBElement deployerType = null;
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((String)"org.jboss.identity.idm.integration.jboss5.jaxb2");
            Unmarshaller unMarshaller = jaxbContext.createUnmarshaller();
            deployerType = (JAXBElement)unMarshaller.unmarshal(inputStream);
        }
        catch (JAXBException e) {
            logger.severe(e.getMessage());
            throw new IdentityConfigurationException("Cannot unmarshal idm deployer configuration: ", e);
        }
        if (deployerType != null) {
            return (JbossIDMDeployerType)deployerType.getValue();
        }
        return null;
    }

    public static JbossIDMDeployerType createDeployerConfiguration(File file) throws Exception {
        FileInputStream inputStream;
        if (file == null) {
            throw new NullPointerException("Identity deployer file is null");
        }
        try {
            inputStream = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("Identity deployer file " + file.getAbsolutePath() + " does not exist");
        }
        return JAXB2IdentityDeployerConfiguration.createDeployerConfiguration(inputStream);
    }

    public static JbossIDMDeployerType createDeployerConfiguration(String file) throws Exception {
        ClassLoader classLoader = SecurityActions.getContextClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream(file);
        if (inputStream == null) {
            throw new NullPointerException("Resource " + file + " does not exist");
        }
        return JAXB2IdentityDeployerConfiguration.createDeployerConfiguration(inputStream);
    }
}

