/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors. 
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.identity.federation.bindings.jboss;

import java.lang.reflect.Method;
import java.security.acl.Group;

import javax.security.auth.Subject;

import org.apache.catalina.realm.GenericPrincipal; 
import org.apache.log4j.Logger;
import org.jboss.identity.federation.bindings.jboss.subject.JBossIdentityGroup;
import org.jboss.identity.federation.bindings.jboss.subject.JBossIdentityPrincipal;

/**
 * @author Anil.Saldhana@redhat.com
 * @since Jan 16, 2009
 */
public class DefaultJBossSubjectRegistration implements JBossSubjectRegistration
{
   protected Logger log = Logger.getLogger(DefaultJBossSubjectRegistration.class);
   
   public void register(GenericPrincipal principal)
   { 
      String sa = "org.jboss.security.SecurityAssociation";
      try
      {
         Class<?> securityAssociationClass = SecurityActions.getContextClassLoader().loadClass(sa);
         Method m = securityAssociationClass.getDeclaredMethod("setSubject", new Class[] {Subject.class});
         Subject subject = this.getJBossSubjectFromTomcatPrincipal(principal);
         m.invoke(null, subject);
      }
      catch(Exception e)
      {
         log.trace("Not a JBoss environment. So not registering in SecurityAssociation");
      }
   }
   
   private Subject getJBossSubjectFromTomcatPrincipal(GenericPrincipal principal)
   {
      Subject subject = new Subject();
      String[] roles = principal.getRoles();
      
      subject.getPrincipals().add(new JBossIdentityPrincipal(principal.getName()));
      
      Group roleGroup = new JBossIdentityGroup("Roles");
      for(String role: roles)
      {
         roleGroup.addMember(new JBossIdentityPrincipal(role));
      }
      
      return subject;
   }
}