/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.federation.api.saml.v2.response;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.datatype.XMLGregorianCalendar;
import org.jboss.identity.federation.core.saml.v2.factories.JBossSAMLAuthnResponseFactory;
import org.jboss.identity.federation.core.saml.v2.factories.JBossSAMLBaseFactory;
import org.jboss.identity.federation.core.saml.v2.factories.SAMLProtocolFactory;
import org.jboss.identity.federation.core.saml.v2.holders.IDPInfoHolder;
import org.jboss.identity.federation.core.saml.v2.holders.IssuerInfoHolder;
import org.jboss.identity.federation.core.saml.v2.holders.SPInfoHolder;
import org.jboss.identity.federation.core.saml.v2.util.XMLTimeUtil;
import org.jboss.identity.federation.saml.v2.assertion.AssertionType;
import org.jboss.identity.federation.saml.v2.assertion.AttributeStatementType;
import org.jboss.identity.federation.saml.v2.assertion.AttributeType;
import org.jboss.identity.federation.saml.v2.assertion.ConditionsType;
import org.jboss.identity.federation.saml.v2.protocol.ResponseType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SAML2Response {
    public AttributeStatementType createAttributeStatement(List<String> roles) {
        AttributeStatementType attrStatement = JBossSAMLBaseFactory.createAttributeStatement();
        for (String role : roles) {
            AttributeType attr = JBossSAMLBaseFactory.createAttributeForRole(role);
            attrStatement.getAttributeOrEncryptedAttribute().add(attr);
        }
        return attrStatement;
    }

    public ResponseType createResponseType(String ID, SPInfoHolder sp, IDPInfoHolder idp, IssuerInfoHolder issuerInfo) throws Exception {
        return JBossSAMLAuthnResponseFactory.createResponseType(ID, sp, idp, issuerInfo);
    }

    public ResponseType createResponseType(String ID, IssuerInfoHolder issuerInfo, AssertionType assertion) throws Exception {
        return JBossSAMLAuthnResponseFactory.createResponseType(ID, issuerInfo, assertion);
    }

    public void createTimedConditions(AssertionType assertion, long durationInMilis) throws Exception {
        XMLGregorianCalendar issueInstant = assertion.getIssueInstant();
        XMLGregorianCalendar assertionValidityLength = XMLTimeUtil.add(issueInstant, durationInMilis);
        ConditionsType conditionsType = JBossSAMLBaseFactory.getObjectFactory().createConditionsType();
        conditionsType.setNotBefore(issueInstant);
        conditionsType.setNotOnOrAfter(assertionValidityLength);
        assertion.setConditions(conditionsType);
    }

    public ResponseType getResponseType(InputStream is) throws Exception {
        if (is == null) {
            throw new IllegalArgumentException("inputstream is null");
        }
        Unmarshaller un = JBossSAMLAuthnResponseFactory.getValidatingUnmarshaller();
        JAXBElement jaxbAuthnRequestType = (JAXBElement)un.unmarshal(is);
        return (ResponseType)jaxbAuthnRequestType.getValue();
    }

    public void marshall(ResponseType responseType, OutputStream os) throws Exception {
        Marshaller marshaller = JBossSAMLAuthnResponseFactory.getValidatingMarshaller();
        JAXBElement<ResponseType> jaxb = SAMLProtocolFactory.getObjectFactory().createResponse(responseType);
        marshaller.marshal(jaxb, os);
    }

    public void marshall(ResponseType responseType, Writer writer) throws Exception {
        Marshaller marshaller = JBossSAMLAuthnResponseFactory.getValidatingMarshaller();
        JAXBElement<ResponseType> jaxb = SAMLProtocolFactory.getObjectFactory().createResponse(responseType);
        marshaller.marshal(jaxb, writer);
    }
}

