/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.federation.api.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.util.Collections;
import javax.security.cert.X509Certificate;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Marshaller;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.KeyValue;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jboss.identity.federation.api.saml.v2.request.SAML2Request;
import org.jboss.identity.federation.core.saml.v2.factories.JBossSAMLBaseFactory;
import org.jboss.identity.federation.saml.v2.protocol.AuthnRequestType;
import org.jboss.identity.federation.saml.v2.protocol.RequestAbstractType;
import org.jboss.identity.xmlsec.w3.xmldsig.ObjectFactory;
import org.jboss.identity.xmlsec.w3.xmldsig.SignatureType;
import org.jcp.xml.dsig.internal.dom.XMLDSigRI;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLSignatureUtil {
    private static String pkgName = "org.jboss.identity.federation.w3.xmldsig";
    private static String schemaLocation = "schema/saml/v2/xmldsig-core-schema.xsd";
    private static ObjectFactory objectFactory = new ObjectFactory();
    private static XMLSignatureFactory fac = XMLSignatureUtil.getXMLSignatureFactory();

    private static XMLSignatureFactory getXMLSignatureFactory() {
        XMLSignatureFactory xsf = null;
        try {
            xsf = XMLSignatureFactory.getInstance("DOM");
        }
        catch (Exception err) {
            xsf = XMLSignatureFactory.getInstance("DOM", new XMLDSigRI());
        }
        return xsf;
    }

    public static Document sign(AuthnRequestType request, PrivateKey signingKey, X509Certificate certificate, String digestMethod, String signatureMethod) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        SAML2Request saml2Request = new SAML2Request();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        saml2Request.marshall((RequestAbstractType)request, baos);
        DocumentBuilder builder = dbf.newDocumentBuilder();
        Document doc = builder.parse(new ByteArrayInputStream(baos.toByteArray()));
        DOMSignContext dsc = new DOMSignContext(signingKey, (Node)doc.getDocumentElement());
        String referenceURI = "#" + request.getID();
        Reference ref = fac.newReference(referenceURI, fac.newDigestMethod(digestMethod, null), Collections.singletonList(fac.newTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature", (TransformParameterSpec)null)), null, null);
        SignedInfo si = fac.newSignedInfo(fac.newCanonicalizationMethod("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments", (C14NMethodParameterSpec)null), fac.newSignatureMethod(signatureMethod, null), Collections.singletonList(ref));
        KeyInfo ki = null;
        if (certificate != null) {
            KeyInfoFactory kif = fac.getKeyInfoFactory();
            KeyValue kv = kif.newKeyValue(certificate.getPublicKey());
            ki = kif.newKeyInfo(Collections.singletonList(kv));
        }
        XMLSignature signature = fac.newXMLSignature(si, ki);
        signature.sign(dsc);
        return doc;
    }

    public static Document sign(RequestAbstractType request, KeyPair keypair, String digestMethod, String signatureMethod) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        SAML2Request saml2Request = new SAML2Request();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        saml2Request.marshall(request, baos);
        DocumentBuilder builder = dbf.newDocumentBuilder();
        Document doc = builder.parse(new ByteArrayInputStream(baos.toByteArray()));
        DOMSignContext dsc = new DOMSignContext(keypair.getPrivate(), (Node)doc.getDocumentElement());
        String referenceURI = "#" + request.getID();
        Reference ref = fac.newReference(referenceURI, fac.newDigestMethod(digestMethod, null), Collections.singletonList(fac.newTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature", (TransformParameterSpec)null)), null, null);
        SignedInfo si = fac.newSignedInfo(fac.newCanonicalizationMethod("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments", (C14NMethodParameterSpec)null), fac.newSignatureMethod(signatureMethod, null), Collections.singletonList(ref));
        KeyInfoFactory kif = fac.getKeyInfoFactory();
        KeyValue kv = kif.newKeyValue(keypair.getPublic());
        KeyInfo ki = kif.newKeyInfo(Collections.singletonList(kv));
        XMLSignature signature = fac.newXMLSignature(si, ki);
        signature.sign(dsc);
        return doc;
    }

    public static boolean validate(Document signedDoc, Key publicKey) throws Exception {
        NodeList nl = signedDoc.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        if (nl.getLength() == 0) {
            throw new Exception("Cannot find Signature element");
        }
        DOMValidateContext valContext = new DOMValidateContext(publicKey, nl.item(0));
        XMLSignature signature = fac.unmarshalXMLSignature(valContext);
        boolean coreValidity = signature.validate(valContext);
        return coreValidity;
    }

    public static void marshall(SignatureType signature, OutputStream os) throws Exception {
        JAXBElement<SignatureType> jsig = objectFactory.createSignature(signature);
        Marshaller marshaller = JBossSAMLBaseFactory.getValidatingMarshaller(pkgName, schemaLocation);
        marshaller.marshal(jsig, os);
    }

    public static void marshall(Document signedDocument, OutputStream os) throws Exception {
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer trans = tf.newTransformer();
        trans.transform(new DOMSource(signedDocument), new StreamResult(os));
    }
}

