/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.federation.bindings.jboss;

import java.lang.reflect.Method;
import javax.security.auth.Subject;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.log4j.Logger;
import org.jboss.identity.federation.bindings.jboss.JBossSubjectRegistration;
import org.jboss.identity.federation.bindings.jboss.SecurityActions;
import org.jboss.identity.federation.bindings.jboss.subject.JBossIdentityGroup;
import org.jboss.identity.federation.bindings.jboss.subject.JBossIdentityPrincipal;

public class DefaultJBossSubjectRegistration
implements JBossSubjectRegistration {
    protected Logger log = Logger.getLogger(DefaultJBossSubjectRegistration.class);

    public void register(GenericPrincipal principal) {
        String sa = "org.jboss.security.SecurityAssociation";
        try {
            Class<?> securityAssociationClass = SecurityActions.getContextClassLoader().loadClass(sa);
            Method m = securityAssociationClass.getDeclaredMethod("setSubject", Subject.class);
            Subject subject = this.getJBossSubjectFromTomcatPrincipal(principal);
            m.invoke(null, subject);
        }
        catch (Exception e) {
            this.log.trace((Object)"Not a JBoss environment. So not registering in SecurityAssociation");
        }
    }

    private Subject getJBossSubjectFromTomcatPrincipal(GenericPrincipal principal) {
        Subject subject = new Subject();
        String[] roles = principal.getRoles();
        subject.getPrincipals().add(new JBossIdentityPrincipal(principal.getName()));
        JBossIdentityGroup roleGroup = new JBossIdentityGroup("Roles");
        for (String role : roles) {
            roleGroup.addMember(new JBossIdentityPrincipal(role));
        }
        return subject;
    }
}

