/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.federation.bindings.jboss.subject;

import java.security.Principal;
import java.security.acl.Group;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.jboss.identity.federation.bindings.jboss.subject.JBossIdentityPrincipal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossIdentityGroup
extends JBossIdentityPrincipal
implements Group {
    private static final long serialVersionUID = 1L;
    private Set<Principal> roles = new HashSet<Principal>();

    public JBossIdentityGroup(String name) {
        super(name);
    }

    public boolean addMember(Principal user) {
        return this.roles.add(user);
    }

    public boolean isMember(Principal member) {
        return this.roles.contains(member);
    }

    public Enumeration<? extends Principal> members() {
        Set<Principal> readOnly = Collections.unmodifiableSet(this.roles);
        return Collections.enumeration(readOnly);
    }

    public boolean removeMember(Principal user) {
        return this.roles.remove(user);
    }
}

