/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.federation.bindings.servlets;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.log4j.Logger;
import org.jboss.identity.federation.api.saml.v2.common.IDGenerator;
import org.jboss.identity.federation.api.saml.v2.response.SAML2Response;
import org.jboss.identity.federation.core.saml.v2.factories.SAMLAssertionFactory;
import org.jboss.identity.federation.core.saml.v2.factories.SOAPFactory;
import org.jboss.identity.federation.core.saml.v2.holders.IssuerInfoHolder;
import org.jboss.identity.federation.core.saml.v2.util.JAXBElementMappingUtil;
import org.jboss.identity.federation.core.saml.v2.util.SOAPSAMLXACMLUtil;
import org.jboss.identity.federation.org.xmlsoap.schemas.soap.envelope.Body;
import org.jboss.identity.federation.org.xmlsoap.schemas.soap.envelope.Envelope;
import org.jboss.identity.federation.org.xmlsoap.schemas.soap.envelope.Fault;
import org.jboss.identity.federation.saml.v2.assertion.AssertionType;
import org.jboss.identity.federation.saml.v2.profiles.xacml.assertion.XACMLAuthzDecisionStatementType;
import org.jboss.identity.federation.saml.v2.profiles.xacml.protocol.XACMLAuthzDecisionQueryType;
import org.jboss.security.xacml.core.JBossPDP;
import org.jboss.security.xacml.core.JBossRequestContext;
import org.jboss.security.xacml.core.model.context.RequestType;
import org.jboss.security.xacml.core.model.context.ResponseType;
import org.jboss.security.xacml.core.model.context.ResultType;
import org.jboss.security.xacml.interfaces.PolicyDecisionPoint;
import org.jboss.security.xacml.interfaces.RequestContext;
import org.jboss.security.xacml.interfaces.ResponseContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SOAPSAMLXACMLServlet
extends HttpServlet {
    private static Logger log = Logger.getLogger(SOAPSAMLXACMLServlet.class);
    private static final long serialVersionUID = 1L;
    String policyConfigFileName = null;
    String issuerId = null;
    String issuer = null;

    public void init() throws ServletException {
        this.issuerId = this.getServletContext().getInitParameter("issuerID");
        if (this.issuerId == null) {
            this.issuerId = "issue-id:1";
        }
        this.issuer = this.getServletContext().getInitParameter("issuer");
        if (this.issuer == null) {
            this.issuer = "urn:jboss-identity";
        }
        this.policyConfigFileName = this.getServletContext().getInitParameter("policyConfigFileName");
        if (this.policyConfigFileName == null) {
            this.policyConfigFileName = "policyConfig.xml";
        }
        super.init();
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        block22: {
            JAXBElement jaxbRequestType = null;
            Envelope envelope = null;
            XACMLAuthzDecisionQueryType xacmlRequest = null;
            Unmarshaller un = SOAPSAMLXACMLUtil.getUnmarshaller();
            Object unmarshalledObject = un.unmarshal((InputStream)req.getInputStream());
            if (unmarshalledObject instanceof JAXBElement) {
                JAXBElement jaxbElement = (JAXBElement)unmarshalledObject;
                Object element = jaxbElement.getValue();
                if (element instanceof Envelope) {
                    envelope = (Envelope)element;
                    Body soapBody = envelope.getBody();
                    jaxbRequestType = (JAXBElement)soapBody.getAny().get(0);
                    xacmlRequest = (XACMLAuthzDecisionQueryType)jaxbRequestType.getValue();
                } else if (element instanceof XACMLAuthzDecisionQueryType) {
                    xacmlRequest = (XACMLAuthzDecisionQueryType)element;
                }
            }
            if (xacmlRequest == null) {
                throw new IOException("XACML Request not parsed");
            }
            RequestType requestType = xacmlRequest.getRequest();
            JBossRequestContext requestContext = new JBossRequestContext();
            requestContext.setRequest(requestType);
            ResponseContext responseContext = this.getPDP().evaluate((RequestContext)requestContext);
            ResponseType responseType = new ResponseType();
            ResultType resultType = responseContext.getResult();
            responseType.getResult().add(resultType);
            XACMLAuthzDecisionStatementType xacmlStatement = SOAPSAMLXACMLUtil.createXACMLAuthzDecisionStatementType();
            xacmlStatement.setRequest(requestType);
            xacmlStatement.setResponse(responseType);
            SAML2Response saml2Response = new SAML2Response();
            IssuerInfoHolder issuerInfo = new IssuerInfoHolder(this.issuer);
            AssertionType assertion = SAMLAssertionFactory.getObjectFactory().createAssertionType();
            assertion.getStatementOrAuthnStatementOrAuthzDecisionStatement().add(xacmlStatement);
            JAXBElement<?> jaxbResponse = JAXBElementMappingUtil.get(saml2Response.createResponseType(IDGenerator.create("ID_"), issuerInfo, assertion));
            envelope = this.createEnvelope(jaxbResponse);
            Object var19_21 = null;
            resp.setContentType("text/xml;charset=utf-8");
            ServletOutputStream os = resp.getOutputStream();
            try {
                if (envelope == null) {
                    throw new IllegalStateException("SOAPEnvelope is null");
                }
                JAXBElement<?> jaxbEnvelope = JAXBElementMappingUtil.get(envelope);
                Marshaller marshaller = SOAPSAMLXACMLUtil.getMarshaller();
                marshaller.marshal(jaxbEnvelope, (OutputStream)os);
            }
            catch (JAXBException e2) {
                this.log("marshalling exception", e2);
            }
            break block22;
            {
                catch (JAXBException e) {
                    log.error((Object)"Exception parsing SOAP:", (Throwable)e);
                    envelope = this.createEnvelope(this.createFault("Parsing Error:" + e.getMessage()));
                    Object var19_22 = null;
                    resp.setContentType("text/xml;charset=utf-8");
                    os = resp.getOutputStream();
                    try {
                        if (envelope == null) {
                            throw new IllegalStateException("SOAPEnvelope is null");
                        }
                        JAXBElement<?> jaxbEnvelope = JAXBElementMappingUtil.get(envelope);
                        Marshaller marshaller = SOAPSAMLXACMLUtil.getMarshaller();
                        marshaller.marshal(jaxbEnvelope, (OutputStream)os);
                    }
                    catch (JAXBException e2) {
                        this.log("marshalling exception", e2);
                    }
                    break block22;
                }
                catch (PrivilegedActionException e) {
                    log.error((Object)"Exception getting PDP:", (Throwable)e);
                    envelope = this.createEnvelope(this.createFault("PDP Setup Error:" + e.getMessage()));
                    Object var19_23 = null;
                    resp.setContentType("text/xml;charset=utf-8");
                    os = resp.getOutputStream();
                    try {
                        if (envelope == null) {
                            throw new IllegalStateException("SOAPEnvelope is null");
                        }
                        JAXBElement<?> jaxbEnvelope = JAXBElementMappingUtil.get(envelope);
                        Marshaller marshaller = SOAPSAMLXACMLUtil.getMarshaller();
                        marshaller.marshal(jaxbEnvelope, (OutputStream)os);
                    }
                    catch (JAXBException e2) {
                        this.log("marshalling exception", e2);
                    }
                    break block22;
                }
                catch (Exception e) {
                    log.error((Object)"Exception:", (Throwable)e);
                    envelope = this.createEnvelope(this.createFault("Server Error:" + e.getMessage()));
                    Object var19_24 = null;
                    resp.setContentType("text/xml;charset=utf-8");
                    os = resp.getOutputStream();
                    try {
                        if (envelope == null) {
                            throw new IllegalStateException("SOAPEnvelope is null");
                        }
                        JAXBElement<?> jaxbEnvelope = JAXBElementMappingUtil.get(envelope);
                        Marshaller marshaller = SOAPSAMLXACMLUtil.getMarshaller();
                        marshaller.marshal(jaxbEnvelope, (OutputStream)os);
                    }
                    catch (JAXBException e2) {
                        this.log("marshalling exception", e2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var19_25 = null;
                resp.setContentType("text/xml;charset=utf-8");
                os = resp.getOutputStream();
                try {
                    if (envelope == null) {
                        throw new IllegalStateException("SOAPEnvelope is null");
                    }
                    JAXBElement<?> jaxbEnvelope = JAXBElementMappingUtil.get(envelope);
                    Marshaller marshaller = SOAPSAMLXACMLUtil.getMarshaller();
                    marshaller.marshal(jaxbEnvelope, (OutputStream)os);
                }
                catch (JAXBException e2) {
                    this.log("marshalling exception", e2);
                }
                throw throwable;
            }
        }
    }

    private PolicyDecisionPoint getPDP() throws PrivilegedActionException {
        ClassLoader tcl = AccessController.doPrivileged(new PrivilegedExceptionAction<ClassLoader>(){

            @Override
            public ClassLoader run() throws Exception {
                return Thread.currentThread().getContextClassLoader();
            }
        });
        InputStream is = tcl.getResourceAsStream(this.policyConfigFileName);
        if (is == null) {
            throw new IllegalStateException(this.policyConfigFileName + " could not be located");
        }
        return new JBossPDP(is);
    }

    private Envelope createEnvelope(Object obj) {
        Envelope envelope = SOAPFactory.getObjectFactory().createEnvelope();
        Body body = SOAPFactory.getObjectFactory().createBody();
        body.getAny().add(obj);
        envelope.setBody(body);
        return envelope;
    }

    private JAXBElement<Fault> createFault(String msg) {
        Fault fault = SOAPFactory.getObjectFactory().createFault();
        fault.setFaultstring(msg);
        return SOAPFactory.getObjectFactory().createFault(fault);
    }
}

