/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.federation.bindings.tomcat;

import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.util.HashMap;
import java.util.List;
import org.jboss.identity.federation.bindings.config.AuthProperty;
import org.jboss.identity.federation.bindings.config.KeyValue;
import org.jboss.identity.federation.bindings.interfaces.TrustKeyManager;
import org.jboss.identity.federation.bindings.tomcat.SecurityActions;
import org.jboss.identity.federation.bindings.util.ValveUtil;
import org.jboss.identity.federation.bindings.util.cert.KeyStoreUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyStoreKeyManager
implements TrustKeyManager {
    private HashMap<String, String> domainAliasMap = new HashMap();
    private HashMap<String, String> authPropsMap = new HashMap();
    private KeyStore ks = null;
    private String keyStoreURL;
    private char[] signingKeyPass;
    private String signingAlias;
    private String keyStorePass;
    public static final String KEYSTORE_URL = "KeyStoreURL";
    public static final String KEYSTORE_PASS = "KeyStorePass";
    public static final String SIGNING_KEY_PASS = "SigningKeyPass";
    public static final String SIGNING_KEY_ALIAS = "SigningKeyAlias";

    @Override
    public PrivateKey getSigningKey() throws Exception {
        if (this.ks == null) {
            this.setUpKeyStore();
        }
        if (this.ks == null) {
            throw new IllegalStateException("KeyStore is null");
        }
        return (PrivateKey)this.ks.getKey(this.signingAlias, this.signingKeyPass);
    }

    @Override
    public PublicKey getValidatingKey(String domain) throws Exception {
        if (this.ks == null) {
            this.setUpKeyStore();
        }
        if (this.ks == null) {
            throw new IllegalStateException("KeyStore is null");
        }
        String domainAlias = this.domainAliasMap.get(domain);
        if (domainAlias == null) {
            throw new IllegalStateException("Domain Alias missing for " + domain);
        }
        PublicKey publicKey = null;
        try {
            publicKey = KeyStoreUtil.getPublicKey(this.ks, domainAlias, this.keyStorePass.toCharArray());
        }
        catch (UnrecoverableKeyException urke) {
            publicKey = KeyStoreUtil.getPublicKey(this.ks, domainAlias, this.signingKeyPass);
        }
        return publicKey;
    }

    @Override
    public void setAuthProperties(List<AuthProperty> authList) throws Exception {
        for (AuthProperty auth : authList) {
            this.authPropsMap.put(auth.getKey(), auth.getValue());
        }
        this.keyStoreURL = this.authPropsMap.get(KEYSTORE_URL);
        this.keyStorePass = this.authPropsMap.get(KEYSTORE_PASS);
        this.signingAlias = this.authPropsMap.get(SIGNING_KEY_ALIAS);
        String keypass = this.authPropsMap.get(SIGNING_KEY_PASS);
        if (keypass == null || keypass.length() == 0) {
            throw new RuntimeException("Signing Key Pass is null");
        }
        this.signingKeyPass = keypass.toCharArray();
    }

    @Override
    public void setValidatingAlias(List<KeyValue> aliases) {
        for (KeyValue alias : aliases) {
            this.domainAliasMap.put(alias.getKey(), alias.getValue());
        }
    }

    private void setUpKeyStore() throws GeneralSecurityException, IOException {
        if (this.keyStoreURL == null) {
            this.keyStoreURL = SecurityActions.getProperty("javax.net.ssl.keyStore", null);
        }
        if (this.keyStorePass == null) {
            this.keyStorePass = SecurityActions.getProperty("javax.net.ssl.keyStorePassword", null);
        }
        InputStream is = ValveUtil.getKeyStoreInputStream(this.keyStoreURL);
        this.ks = KeyStoreUtil.getKeyStore(is, this.keyStorePass.toCharArray());
    }
}

