/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.federation.bindings.tomcat.idp;

import java.security.PrivateKey;
import java.security.PublicKey;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.connector.Request;
import org.apache.log4j.Logger;
import org.jboss.identity.federation.bindings.config.KeyProvider;
import org.jboss.identity.federation.bindings.interfaces.TrustKeyManager;
import org.jboss.identity.federation.bindings.tomcat.idp.IDPRedirectValve;
import org.jboss.identity.federation.bindings.tomcat.idp.SecurityActions;
import org.jboss.identity.federation.bindings.util.RedirectBindingSignatureUtil;
import org.jboss.identity.federation.core.saml.v2.util.SignatureUtil;

public class IDPRedirectWithSignatureValve
extends IDPRedirectValve {
    private static Logger log = Logger.getLogger(IDPRedirectWithSignatureValve.class);
    private boolean ignoreSignature = false;
    private TrustKeyManager keyManager;

    public void setIgnoreSignature(String val) {
        if (val != null && val.length() > 0) {
            this.ignoreSignature = Boolean.valueOf(val);
        }
    }

    public void start() throws LifecycleException {
        super.start();
        KeyProvider keyProvider = this.idpConfiguration.getKeyProvider();
        try {
            ClassLoader tcl = SecurityActions.getContextClassLoader();
            String keyManagerClassName = keyProvider.getClassName();
            if (keyManagerClassName == null) {
                throw new RuntimeException("KeyManager class name is null");
            }
            Class<?> clazz = tcl.loadClass(keyManagerClassName);
            this.keyManager = (TrustKeyManager)clazz.newInstance();
            this.keyManager.setAuthProperties(keyProvider.getAuth());
            this.keyManager.setValidatingAlias(keyProvider.getValidatingAlias());
        }
        catch (Exception e) {
            log.error((Object)"Exception reading configuration:", (Throwable)e);
            throw new LifecycleException(e.getLocalizedMessage());
        }
        log.trace((Object)("Key Provider=" + keyProvider.getClassName()));
    }

    protected boolean validate(Request request) throws Exception {
        boolean result = super.validate(request);
        if (!result) {
            return result;
        }
        if (this.ignoreSignature) {
            log.trace((Object)"Since signature is to be ignored, validation returns");
            return true;
        }
        String queryString = request.getQueryString();
        byte[] sigValue = RedirectBindingSignatureUtil.getSignatureValueFromSignedURL(queryString);
        if (sigValue == null) {
            return false;
        }
        String reqFromURL = RedirectBindingSignatureUtil.getTokenValue(queryString, "SAMLRequest");
        String relayStateFromURL = RedirectBindingSignatureUtil.getTokenValue(queryString, "RelayState");
        String sigAlgFromURL = RedirectBindingSignatureUtil.getTokenValue(queryString, "SigAlg");
        StringBuilder sb = new StringBuilder();
        sb.append("SAMLRequest=").append(reqFromURL);
        if (relayStateFromURL != null && relayStateFromURL.length() > 0) {
            sb.append("&RelayState=").append(relayStateFromURL);
        }
        sb.append("&SigAlg=").append(sigAlgFromURL);
        PublicKey validatingKey = this.keyManager.getValidatingKey(request.getRemoteAddr());
        boolean isValid = SignatureUtil.validate(sb.toString().getBytes("UTF-8"), sigValue, validatingKey);
        return isValid;
    }

    protected String getDestination(String urlEncodedResponse, String urlEncodedRelayState) {
        try {
            PrivateKey signingKey = this.keyManager.getSigningKey();
            StringBuffer sb = new StringBuffer();
            String url = RedirectBindingSignatureUtil.getSAMLResponseURLWithSignature(urlEncodedResponse, urlEncodedRelayState, signingKey);
            sb.append("?").append(url);
            return sb.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

