/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.federation.bindings.tomcat.sp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.Principal;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Session;
import org.apache.catalina.authenticator.FormAuthenticator;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.log4j.Logger;
import org.jboss.identity.federation.api.saml.v2.request.SAML2Request;
import org.jboss.identity.federation.api.saml.v2.response.SAML2Response;
import org.jboss.identity.federation.api.util.Base64;
import org.jboss.identity.federation.api.util.DeflateUtil;
import org.jboss.identity.federation.bindings.config.SP;
import org.jboss.identity.federation.bindings.config.Trust;
import org.jboss.identity.federation.bindings.jboss.DefaultJBossSubjectRegistration;
import org.jboss.identity.federation.bindings.jboss.JBossSubjectRegistration;
import org.jboss.identity.federation.bindings.tomcat.sp.SPUtil;
import org.jboss.identity.federation.bindings.tomcat.sp.SecurityActions;
import org.jboss.identity.federation.bindings.util.HTTPRedirectUtil;
import org.jboss.identity.federation.bindings.util.RedirectBindingUtil;
import org.jboss.identity.federation.bindings.util.ValveUtil;
import org.jboss.identity.federation.core.saml.v2.exceptions.AssertionExpiredException;
import org.jboss.identity.federation.core.saml.v2.exceptions.IssuerNotTrustedException;
import org.jboss.identity.federation.saml.v2.protocol.AuthnRequestType;
import org.jboss.identity.federation.saml.v2.protocol.RequestAbstractType;
import org.jboss.identity.federation.saml.v2.protocol.ResponseType;

public class SPRedirectFormAuthenticator
extends FormAuthenticator {
    private static Logger log = Logger.getLogger(SPRedirectFormAuthenticator.class);
    protected SP spConfiguration = null;
    private String serviceURL = null;
    private String identityURL = null;
    private JBossSubjectRegistration jbossRegistration = new DefaultJBossSubjectRegistration();

    public void setJBossSubjectRegistration(String fqn) throws Exception {
        ClassLoader tcl = SecurityActions.getContextClassLoader();
        Class<?> clazz = tcl.loadClass(fqn);
        this.jbossRegistration = (JBossSubjectRegistration)clazz.newInstance();
    }

    public void start() throws LifecycleException {
        String configFile = "WEB-INF/jboss-idfed.xml";
        super.start();
        InputStream is = this.context.getServletContext().getResourceAsStream(configFile);
        if (is == null) {
            throw new RuntimeException(configFile + " missing");
        }
        try {
            this.spConfiguration = ValveUtil.getSPConfiguration(is);
            this.identityURL = this.spConfiguration.getIdentityURL();
            this.serviceURL = this.spConfiguration.getServiceURL();
            log.trace((Object)("Identity Provider URL=" + this.identityURL));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean authenticate(Request request, Response response, LoginConfig loginConfig) throws IOException {
        Principal principal = request.getUserPrincipal();
        if (principal != null) {
            log.debug((Object)("Already authenticated '" + principal.getName() + "'"));
            return true;
        }
        Session session = request.getSessionInternal(true);
        String relayState = request.getParameter("RelayState");
        try {
            Principal p = this.process(request, response);
            if (p == null) {
                String destination = this.createSAMLRequestMessage(relayState, response);
                HTTPRedirectUtil.sendRedirectForRequestor(destination, (HttpServletResponse)response);
                return false;
            }
            String username = p.getName();
            String password = "FED_IDENTITY";
            session.setNote("org.apache.catalina.session.USERNAME", (Object)username);
            session.setNote("org.apache.catalina.session.PASSWORD", (Object)password);
            request.setUserPrincipal(p);
            this.register(request, response, p, "FORM", username, password);
            this.jbossRegistration.register((GenericPrincipal)principal);
            return true;
        }
        catch (AssertionExpiredException aie) {
            log.debug((Object)"Assertion has expired. Issuing a new saml2 request to the IDP");
            try {
                String destination = this.createSAMLRequestMessage(relayState, response);
                HTTPRedirectUtil.sendRedirectForRequestor(destination, (HttpServletResponse)response);
            }
            catch (Exception e) {
                log.trace((Object)"Exception:", (Throwable)e);
            }
            return false;
        }
        catch (Exception e) {
            log.debug((Object)"Exception :", (Throwable)e);
            return super.authenticate(request, response, loginConfig);
        }
    }

    protected String createSAMLRequestMessage(String relayState, Response response) throws Exception {
        if (this.serviceURL == null) {
            throw new ServletException("serviceURL is not configured");
        }
        SAML2Request saml2Request = new SAML2Request();
        SPUtil spUtil = new SPUtil();
        AuthnRequestType authnRequest = spUtil.createSAMLRequest(this.serviceURL, this.identityURL);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        saml2Request.marshall((RequestAbstractType)authnRequest, baos);
        String base64Request = RedirectBindingUtil.deflateBase64URLEncode(baos.toByteArray());
        String destination = authnRequest.getDestination() + this.getDestination(base64Request, relayState);
        log.debug((Object)("Sending to destination=" + destination));
        return destination;
    }

    protected String getDestination(String urlEncodedRequest, String urlEncodedRelayState) {
        StringBuilder sb = new StringBuilder();
        sb.append("?SAMLRequest=").append(urlEncodedRequest);
        if (urlEncodedRelayState != null && urlEncodedRelayState.length() > 0) {
            sb.append("&RelayState=").append(urlEncodedRelayState);
        }
        return sb.toString();
    }

    protected void isTrusted(String issuer) throws IssuerNotTrustedException {
        try {
            String domainsTrusted;
            String issuerDomain = ValveUtil.getDomain(issuer);
            Trust idpTrust = this.spConfiguration.getTrust();
            if (idpTrust != null && (domainsTrusted = idpTrust.getDomains()).indexOf(issuerDomain) < 0) {
                throw new IssuerNotTrustedException(issuer);
            }
        }
        catch (Exception e) {
            throw new IssuerNotTrustedException(e.getLocalizedMessage(), e);
        }
    }

    protected boolean validate(Request request) throws Exception {
        return request.getParameter("SAMLResponse") != null;
    }

    private Principal process(Request request, Response response) throws Exception {
        Principal userPrincipal = null;
        String samlResponse = request.getParameter("SAMLResponse");
        if (samlResponse != null && samlResponse.length() > 0) {
            this.validate(request);
            byte[] base64DecodedResponse = Base64.decode(samlResponse);
            InputStream is = DeflateUtil.decode(base64DecodedResponse);
            SAML2Response saml2Response = new SAML2Response();
            ResponseType responseType = saml2Response.getResponseType(is);
            this.isTrusted(responseType.getIssuer().getValue());
            SPUtil spUtil = new SPUtil();
            return spUtil.handleSAMLResponse(request, responseType);
        }
        return userPrincipal;
    }
}

