/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.federation.bindings.tomcat.sp;

import java.security.PrivateKey;
import java.security.PublicKey;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.connector.Request;
import org.apache.log4j.Logger;
import org.jboss.identity.federation.bindings.config.KeyProvider;
import org.jboss.identity.federation.bindings.interfaces.TrustKeyManager;
import org.jboss.identity.federation.bindings.tomcat.sp.SPRedirectFormAuthenticator;
import org.jboss.identity.federation.bindings.tomcat.sp.SecurityActions;
import org.jboss.identity.federation.bindings.util.RedirectBindingSignatureUtil;
import org.jboss.identity.federation.core.saml.v2.util.SignatureUtil;

public class SPRedirectSignatureFormAuthenticator
extends SPRedirectFormAuthenticator {
    private static Logger log = Logger.getLogger(SPRedirectSignatureFormAuthenticator.class);
    private TrustKeyManager keyManager;

    public void start() throws LifecycleException {
        super.start();
        KeyProvider keyProvider = this.spConfiguration.getKeyProvider();
        try {
            ClassLoader tcl = SecurityActions.getContextClassLoader();
            String keyManagerClassName = keyProvider.getClassName();
            if (keyManagerClassName == null) {
                throw new RuntimeException("KeyManager class name is null");
            }
            Class<?> clazz = tcl.loadClass(keyManagerClassName);
            this.keyManager = (TrustKeyManager)clazz.newInstance();
            this.keyManager.setAuthProperties(keyProvider.getAuth());
            this.keyManager.setValidatingAlias(keyProvider.getValidatingAlias());
        }
        catch (Exception e) {
            log.error((Object)"Exception reading configuration:", (Throwable)e);
            throw new LifecycleException(e.getLocalizedMessage());
        }
        log.trace((Object)("Key Provider=" + keyProvider.getClassName()));
    }

    protected boolean validate(Request request) throws Exception {
        boolean result = super.validate(request);
        if (!result) {
            return result;
        }
        String queryString = request.getQueryString();
        byte[] sigValue = RedirectBindingSignatureUtil.getSignatureValueFromSignedURL(queryString);
        if (sigValue == null) {
            return false;
        }
        String reqFromURL = RedirectBindingSignatureUtil.getTokenValue(queryString, "SAMLResponse");
        String relayStateFromURL = RedirectBindingSignatureUtil.getTokenValue(queryString, "RelayState");
        String sigAlgFromURL = RedirectBindingSignatureUtil.getTokenValue(queryString, "SigAlg");
        StringBuilder sb = new StringBuilder();
        sb.append("SAMLResponse=").append(reqFromURL);
        if (relayStateFromURL != null && relayStateFromURL.length() > 0) {
            sb.append("&RelayState=").append(relayStateFromURL);
        }
        sb.append("&SigAlg=").append(sigAlgFromURL);
        PublicKey validatingKey = this.keyManager.getValidatingKey(request.getRemoteAddr());
        boolean isValid = SignatureUtil.validate(sb.toString().getBytes("UTF-8"), sigValue, validatingKey);
        return isValid;
    }

    protected String getDestination(String urlEncodedRequest, String urlEncodedRelayState) {
        try {
            PrivateKey signingKey = this.keyManager.getSigningKey();
            StringBuffer sb = new StringBuffer();
            String url = RedirectBindingSignatureUtil.getSAMLRequestURLWithSignature(urlEncodedRequest, urlEncodedRelayState, signingKey);
            sb.append("?").append(url);
            return sb.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

