/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.federation.bindings.tomcat.sp;

import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBElement;
import org.apache.catalina.Context;
import org.apache.catalina.connector.Request;
import org.apache.catalina.realm.GenericPrincipal;
import org.jboss.identity.federation.api.saml.v2.common.IDGenerator;
import org.jboss.identity.federation.api.saml.v2.request.SAML2Request;
import org.jboss.identity.federation.core.saml.v2.constants.JBossSAMLURIConstants;
import org.jboss.identity.federation.core.saml.v2.exceptions.AssertionExpiredException;
import org.jboss.identity.federation.core.saml.v2.util.XMLTimeUtil;
import org.jboss.identity.federation.saml.v2.assertion.AssertionType;
import org.jboss.identity.federation.saml.v2.assertion.AttributeStatementType;
import org.jboss.identity.federation.saml.v2.assertion.AttributeType;
import org.jboss.identity.federation.saml.v2.assertion.ConditionsType;
import org.jboss.identity.federation.saml.v2.assertion.NameIDType;
import org.jboss.identity.federation.saml.v2.assertion.SubjectType;
import org.jboss.identity.federation.saml.v2.protocol.AuthnRequestType;
import org.jboss.identity.federation.saml.v2.protocol.ResponseType;
import org.jboss.identity.federation.saml.v2.protocol.StatusType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SPUtil {
    public AuthnRequestType createSAMLRequest(String serviceURL, String identityURL) throws Exception {
        if (serviceURL == null) {
            throw new IllegalArgumentException("serviceURL is null");
        }
        if (identityURL == null) {
            throw new IllegalArgumentException("identityURL is null");
        }
        SAML2Request saml2Request = new SAML2Request();
        String id = IDGenerator.create("ID_");
        return saml2Request.createAuthnRequestType(id, serviceURL, identityURL, serviceURL);
    }

    public Principal handleSAMLResponse(Request request, ResponseType responseType) throws Exception {
        boolean isValidAssertion;
        if (request == null) {
            throw new IllegalArgumentException("request is null");
        }
        if (responseType == null) {
            throw new IllegalArgumentException("response type is null");
        }
        StatusType statusType = responseType.getStatus();
        if (statusType == null) {
            throw new Exception("Status Type from the IDP is null");
        }
        String statusValue = statusType.getStatusCode().getValue();
        if (!JBossSAMLURIConstants.STATUS_SUCCESS.get().equals(statusValue)) {
            throw new SecurityException("IDP forbid the user");
        }
        AssertionType assertion = (AssertionType)responseType.getAssertionOrEncryptedAssertion().get(0);
        ConditionsType conditionsType = assertion.getConditions();
        if (conditionsType != null && !(isValidAssertion = XMLTimeUtil.isValid(XMLTimeUtil.getIssueInstant(), conditionsType.getNotBefore(), conditionsType.getNotOnOrAfter()))) {
            throw new AssertionExpiredException();
        }
        SubjectType subject = assertion.getSubject();
        JAXBElement<?> jnameID = subject.getContent().get(0);
        NameIDType nameID = (NameIDType)jnameID.getValue();
        String userName = nameID.getValue();
        ArrayList<String> roles = new ArrayList<String>();
        AttributeStatementType attributeStatement = (AttributeStatementType)assertion.getStatementOrAuthnStatementOrAuthzDecisionStatement().get(0);
        List<Object> attList = attributeStatement.getAttributeOrEncryptedAttribute();
        for (Object obj : attList) {
            AttributeType attr = (AttributeType)obj;
            String roleName = (String)attr.getAttributeValue().get(0);
            roles.add(roleName);
        }
        return this.createGenericPrincipal(request, userName, roles);
    }

    private Principal createGenericPrincipal(Request request, String username, List<String> roles) {
        Context ctx = request.getContext();
        return new GenericPrincipal(ctx.getRealm(), username, null, roles);
    }
}

