/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.federation.bindings.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import org.jboss.identity.federation.bindings.config.IDP;
import org.jboss.identity.federation.bindings.config.SP;
import org.jboss.identity.federation.bindings.util.SecurityActions;
import org.jboss.identity.federation.core.saml.v2.factories.JBossSAMLBaseFactory;

public class ValveUtil {
    public static InputStream getKeyStoreInputStream(String keyStore) {
        InputStream is = null;
        try {
            File file = new File(keyStore);
            is = new FileInputStream(file);
        }
        catch (Exception e) {
            try {
                URL url = new URL(keyStore);
                is = url.openStream();
            }
            catch (Exception ex) {
                is = SecurityActions.getContextClassLoader().getResourceAsStream(keyStore);
            }
        }
        if (is == null) {
            throw new RuntimeException("Keystore not located");
        }
        return is;
    }

    public static IDP getIDPConfiguration(InputStream is) throws Exception {
        if (is == null) {
            throw new IllegalArgumentException("inputstream is null");
        }
        String schema = "schema/config/jboss-identity-fed.xsd";
        Unmarshaller un = JBossSAMLBaseFactory.getValidatingUnmarshaller("org.jboss.identity.federation.bindings.config", schema);
        JAXBElement jaxbSp = (JAXBElement)un.unmarshal(is);
        return (IDP)jaxbSp.getValue();
    }

    public static SP getSPConfiguration(InputStream is) throws Exception {
        if (is == null) {
            throw new IllegalArgumentException("inputstream is null");
        }
        String schema = "schema/config/jboss-identity-fed.xsd";
        Unmarshaller un = JBossSAMLBaseFactory.getValidatingUnmarshaller("org.jboss.identity.federation.bindings.config", schema);
        JAXBElement jaxbSp = (JAXBElement)un.unmarshal(is);
        return (SP)jaxbSp.getValue();
    }

    public static String getDomain(String domainURL) throws Exception {
        URL url = new URL(domainURL);
        return url.getHost();
    }
}

