/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.federation.core.saml.v2.factories;

import javax.xml.bind.JAXBElement;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.datatype.XMLGregorianCalendar;
import org.jboss.identity.federation.core.saml.v2.constants.JBossSAMLConstants;
import org.jboss.identity.federation.core.saml.v2.factories.JBossSAMLBaseFactory;
import org.jboss.identity.federation.core.saml.v2.factories.SAMLProtocolFactory;
import org.jboss.identity.federation.core.saml.v2.util.XMLTimeUtil;
import org.jboss.identity.federation.saml.v2.assertion.NameIDType;
import org.jboss.identity.federation.saml.v2.protocol.AuthnRequestType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossSAMLAuthnRequestFactory {
    private static String pkgName = "org.jboss.identity.federation.saml.v2.protocol:org.jboss.identity.xmlsec.w3.xmldsig";
    private static String schemaLocation = "schema/saml/v2/saml-schema-protocol-2.0.xsd";

    public static AuthnRequestType createAuthnRequestType() {
        AuthnRequestType authnRequestType = SAMLProtocolFactory.getObjectFactory().createAuthnRequestType();
        return authnRequestType;
    }

    public static AuthnRequestType createAuthnRequestType(String id, String assertionConsumerURL, String destination, String issuerValue) throws Exception {
        XMLGregorianCalendar issueInstant = XMLTimeUtil.getIssueInstant();
        AuthnRequestType authnRequest = SAMLProtocolFactory.getObjectFactory().createAuthnRequestType();
        authnRequest.setID(id);
        authnRequest.setVersion(JBossSAMLConstants.VERSION_2_0.get());
        authnRequest.setAssertionConsumerServiceURL(assertionConsumerURL);
        authnRequest.setDestination(destination);
        authnRequest.setIssueInstant(issueInstant);
        NameIDType issuer = JBossSAMLBaseFactory.createNameID();
        issuer.setValue(issuerValue);
        authnRequest.setIssuer(issuer);
        return authnRequest;
    }

    public static JAXBElement<AuthnRequestType> createAuthnRequestType(AuthnRequestType authnRequestType) {
        return SAMLProtocolFactory.getObjectFactory().createAuthnRequest(authnRequestType);
    }

    public static Marshaller getValidatingMarshaller() throws Exception {
        return JBossSAMLBaseFactory.getValidatingMarshaller(pkgName, schemaLocation);
    }

    public static Unmarshaller getValidatingUnmarshaller() throws Exception {
        return JBossSAMLBaseFactory.getValidatingUnmarshaller(pkgName, schemaLocation);
    }
}

