/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2009, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors. 
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.identity.federation.api.wstrust;

/**
 * <p>
 * This class defines the constants used throughout the WS-Trust implementation code.
 * </p>
 * 
 * @author <a href="mailto:sguilhen@redhat.com">Stefan Guilhen</a>
 */
public class WSTrustConstants
{
   public final static String BASE_NAMESPACE = "http://docs.oasis-open.org/ws-sx/ws-trust/200512";
   
   public final static String ISSUE_REQUEST = BASE_NAMESPACE + "/Issue";
   
   public final static String RENEW_REQUEST = BASE_NAMESPACE + "/Renew";
   
   public final static String CANCEL_REQUEST = BASE_NAMESPACE + "/Cancel";
   
   public final static String VALIDATE_REQUEST = BASE_NAMESPACE + "/Validate";
}
