/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2009, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors. 
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.identity.federation.api.wstrust;

import org.jboss.identity.federation.api.wstrust.protocol.RequestSecurityToken;

/**
 * <p>
 * The {@code WSTrustRequestContext} contains all the information that is relevant for the security token request
 * processing.
 * </p>
 * 
 * @author <a href="mailto:sguilhen@redhat.com">Stefan Guilhen</a>
 */
public class WSTrustRequestContext
{

   private final RequestSecurityToken request;

   private SecurityToken securityToken;
   
   /**
    * <p>
    * Creates an instance of {@code WSTrustRequestContext} using the specified request.
    * </p>
    * 
    * @param request a {@code RequestSecurityToken} object that contains the information about the security token
    *            request.
    */
   public WSTrustRequestContext(RequestSecurityToken request)
   {
      this.request = request;
   }

   /**
    * <p>
    * Obtains the object the contains the information about the security token request.
    * </p>
    * 
    * @return a reference to the {@code RequestSecurityToken} instance.
    */
   public RequestSecurityToken getRequestSecurityToken()
   {
      return this.request;
   }
   
   /**
    * <p>
    * Obtains the security token contained in this context.
    * </p>
    * 
    * @return a reference to the {@code SecurityToken} instance.
    */
   public SecurityToken getSecurityToken()
   {
      return this.securityToken;
   }
   
   /**
    * <p>
    * Sets the security token in the context.
    * </p>
    * 
    * @param token the {@code SecurityToken} instance to be set.
    */
   public void setSecurityToken(SecurityToken token)
   {
      this.securityToken = token;
   }
}
