/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.federation.api.wstrust;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import javax.xml.bind.JAXBElement;
import org.jboss.identity.federation.ws.addressing.EndpointReferenceType;
import org.jboss.identity.federation.ws.policy.AppliesTo;
import org.jboss.identity.federation.ws.trust.LifetimeType;
import org.jboss.identity.federation.ws.wss.utility.AttributedDateTime;

public class WSTrustUtil {
    public static String parseAppliesTo(AppliesTo appliesTo) {
        EndpointReferenceType reference = null;
        for (Object obj : appliesTo.getAny()) {
            JAXBElement element;
            if (obj instanceof EndpointReferenceType) {
                reference = (EndpointReferenceType)obj;
            } else if (obj instanceof JAXBElement && (element = (JAXBElement)obj).getName().getLocalPart().equalsIgnoreCase("EndpointReference")) {
                reference = (EndpointReferenceType)element.getValue();
            }
            if (reference == null || reference.getAddress() == null) continue;
            return reference.getAddress().toString();
        }
        return null;
    }

    public static LifetimeType createDefaultLifetime(long tokenTimeout) {
        long createdTime = WSTrustUtil.getCurrentGMTTime();
        SimpleDateFormat calendarFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'.'SSS'Z'", Locale.getDefault());
        GregorianCalendar calendar = new GregorianCalendar();
        calendarFormatter.setTimeZone(((Calendar)calendar).getTimeZone());
        calendar.setTimeInMillis(createdTime);
        AttributedDateTime created = new AttributedDateTime();
        created.setValue(calendarFormatter.format(calendar.getTime()));
        calendar.setTimeInMillis(createdTime + tokenTimeout);
        AttributedDateTime expires = new AttributedDateTime();
        expires.setValue(calendarFormatter.format(calendar.getTime()));
        LifetimeType type = new LifetimeType();
        type.setCreated(created);
        type.setExpires(expires);
        return type;
    }

    public static long getCurrentGMTTime() {
        GregorianCalendar cal = new GregorianCalendar();
        int offset = cal.get(15);
        if (((Calendar)cal).getTimeZone().inDaylightTime(cal.getTime())) {
            offset += ((Calendar)cal).getTimeZone().getDSTSavings();
        }
        return cal.getTimeInMillis() - (long)offset;
    }
}

