/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.federation.core.saml.v2.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class DocumentUtil {
    public static Document createDocument() throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.newDocument();
    }

    public static Document getDocument(String docString) throws Exception {
        return DocumentUtil.getDocument(new StringReader(docString));
    }

    public static Document getDocument(Reader reader) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(new InputSource(reader));
    }

    public static String getDocumentAsString(Document signedDoc) throws Exception {
        DOMSource source = new DOMSource(signedDoc);
        StringWriter sw = new StringWriter();
        StreamResult streamResult = new StreamResult(sw);
        Transformer xformer = TransformerFactory.newInstance().newTransformer();
        xformer.transform(source, streamResult);
        return sw.toString();
    }

    public static String getDOMElementAsString(Element element) throws Exception {
        DOMSource source = new DOMSource(element);
        StringWriter sw = new StringWriter();
        StreamResult streamResult = new StreamResult(sw);
        Transformer xformer = TransformerFactory.newInstance().newTransformer();
        xformer.transform(source, streamResult);
        return sw.toString();
    }

    public static InputStream getNodeAsStream(Node node) throws Exception {
        DOMSource source = new DOMSource(node);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        StreamResult streamResult = new StreamResult(baos);
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.transform(source, streamResult);
        ByteArrayInputStream bis = new ByteArrayInputStream(baos.toByteArray());
        return bis;
    }
}

