/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.federation.api.saml.v2.request;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import javax.xml.bind.Binder;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.ParserConfigurationException;
import org.jboss.identity.federation.api.saml.v2.request.SecurityActions;
import org.jboss.identity.federation.core.exceptions.ConfigurationException;
import org.jboss.identity.federation.core.saml.v2.factories.JBossSAMLAuthnRequestFactory;
import org.jboss.identity.federation.core.saml.v2.factories.JBossSAMLBaseFactory;
import org.jboss.identity.federation.core.saml.v2.util.DocumentUtil;
import org.jboss.identity.federation.core.saml.v2.util.JAXBElementMappingUtil;
import org.jboss.identity.federation.core.saml.v2.util.XMLTimeUtil;
import org.jboss.identity.federation.saml.v2.assertion.NameIDType;
import org.jboss.identity.federation.saml.v2.profiles.xacml.protocol.XACMLAuthzDecisionQueryType;
import org.jboss.identity.federation.saml.v2.protocol.AuthnRequestType;
import org.jboss.identity.federation.saml.v2.protocol.LogoutRequestType;
import org.jboss.identity.federation.saml.v2.protocol.ObjectFactory;
import org.jboss.identity.federation.saml.v2.protocol.RequestAbstractType;
import org.jboss.identity.federation.saml.v2.protocol.ResponseType;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class SAML2Request {
    public AuthnRequestType createAuthnRequestType(String id, String assertionConsumerURL, String destination, String issuerValue) throws ConfigurationException {
        return JBossSAMLAuthnRequestFactory.createAuthnRequestType(id, assertionConsumerURL, destination, issuerValue);
    }

    public AuthnRequestType getAuthnRequestType(String fileName) throws JAXBException, SAXException {
        if (fileName == null) {
            throw new IllegalArgumentException("fileName is null");
        }
        ClassLoader tcl = SecurityActions.getContextClassLoader();
        InputStream is = tcl.getResourceAsStream(fileName);
        return this.getAuthnRequestType(is);
    }

    public RequestAbstractType getRequestType(InputStream is) throws JAXBException, SAXException {
        if (is == null) {
            throw new IllegalStateException("InputStream is null");
        }
        String key = "org.jboss.identity.jaxb.schema.validation";
        boolean validate = Boolean.parseBoolean(SecurityActions.getSystemProperty(key, "false"));
        Unmarshaller un = JBossSAMLAuthnRequestFactory.getValidatingUnmarshaller(validate);
        JAXBElement jaxbAuthnRequestType = (JAXBElement)un.unmarshal(is);
        return (RequestAbstractType)jaxbAuthnRequestType.getValue();
    }

    public AuthnRequestType getAuthnRequestType(InputStream is) throws JAXBException, SAXException {
        if (is == null) {
            throw new IllegalStateException("InputStream is null");
        }
        String key = "org.jboss.identity.jaxb.schema.validation";
        boolean validate = Boolean.parseBoolean(SecurityActions.getSystemProperty(key, "false"));
        Unmarshaller un = JBossSAMLAuthnRequestFactory.getValidatingUnmarshaller(validate);
        JAXBElement jaxbAuthnRequestType = (JAXBElement)un.unmarshal(is);
        return (AuthnRequestType)jaxbAuthnRequestType.getValue();
    }

    public LogoutRequestType createLogoutRequest(String issuer) throws ConfigurationException {
        ObjectFactory of = new ObjectFactory();
        LogoutRequestType lrt = of.createLogoutRequestType();
        lrt.setIssueInstant(XMLTimeUtil.getIssueInstant());
        NameIDType issuerNameID = JBossSAMLBaseFactory.createNameID();
        issuerNameID.setValue(issuer);
        lrt.setIssuer(issuerNameID);
        return lrt;
    }

    public XACMLAuthzDecisionQueryType parseXACMLDecisionQuery(String resourceName) throws JAXBException {
        ClassLoader tcl = SecurityActions.getContextClassLoader();
        InputStream is = tcl.getResourceAsStream(resourceName);
        return this.parseXACMLDecisionQuery(is);
    }

    public XACMLAuthzDecisionQueryType parseXACMLDecisionQuery(InputStream is) throws JAXBException {
        if (is == null) {
            throw new IllegalArgumentException("Inputstream is null");
        }
        String samlPath = "org.jboss.identity.federation.saml.v2.protocol";
        String xacmlPath = "org.jboss.security.xacml.core.model.context";
        String xsAssert = "org.jboss.identity.federation.saml.v2.profiles.xacml.assertion";
        String xsProto = "org.jboss.identity.federation.saml.v2.profiles.xacml.protocol";
        String path = samlPath + ":" + xacmlPath + ":" + xsAssert + ":" + xsProto;
        JAXBContext jaxb = JAXBContext.newInstance((String)path);
        Unmarshaller un = jaxb.createUnmarshaller();
        JAXBElement jaxbRequestType = (JAXBElement)un.unmarshal(is);
        RequestAbstractType req = (RequestAbstractType)jaxbRequestType.getValue();
        if (!(req instanceof XACMLAuthzDecisionQueryType)) {
            throw new IllegalStateException("Not of type XACMLAuthzDecisionQueryType");
        }
        return (XACMLAuthzDecisionQueryType)req;
    }

    public Document convert(RequestAbstractType rat) throws SAXException, IOException, JAXBException, ParserConfigurationException {
        JAXBContext jaxb = JAXBContext.newInstance((Class[])new Class[]{RequestAbstractType.class});
        Binder binder = jaxb.createBinder();
        Document doc = DocumentUtil.createDocument();
        binder.marshal(JAXBElementMappingUtil.get(rat), (Object)doc);
        return doc;
    }

    public Document convert(ResponseType responseType) throws JAXBException, ParserConfigurationException {
        JAXBContext jaxb = JAXBContext.newInstance((Class[])new Class[]{ResponseType.class});
        Binder binder = jaxb.createBinder();
        Document doc = DocumentUtil.createDocument();
        binder.marshal(JAXBElementMappingUtil.get(responseType), (Object)doc);
        return doc;
    }

    public void marshall(RequestAbstractType requestType, OutputStream os) throws SAXException, JAXBException {
        String key = "org.jboss.identity.jaxb.schema.validation";
        boolean validate = Boolean.parseBoolean(SecurityActions.getSystemProperty(key, "false"));
        Marshaller marshaller = JBossSAMLAuthnRequestFactory.getValidatingMarshaller(validate);
        JAXBElement<?> j = JAXBElementMappingUtil.get(requestType);
        marshaller.marshal(j, os);
    }

    public void marshall(RequestAbstractType requestType, Writer writer) throws SAXException, JAXBException {
        String key = "org.jboss.identity.jaxb.schema.validation";
        boolean validate = Boolean.parseBoolean(SecurityActions.getSystemProperty(key, "false"));
        Marshaller marshaller = JBossSAMLAuthnRequestFactory.getValidatingMarshaller(validate);
        JAXBElement<?> j = JAXBElementMappingUtil.get(requestType);
        marshaller.marshal(j, writer);
    }
}

