/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.federation.core.saml.v2.metadata.store;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.log4j.Logger;
import org.jboss.identity.federation.core.saml.v2.metadata.store.IMetadataConfigurationStore;
import org.jboss.identity.federation.core.saml.v2.metadata.store.SecurityActions;
import org.jboss.identity.federation.core.util.JAXBUtil;
import org.jboss.identity.federation.saml.v2.metadata.EntityDescriptorType;
import org.jboss.identity.federation.saml.v2.metadata.ObjectFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileBasedMetadataConfigurationStore
implements IMetadataConfigurationStore {
    private static Logger log = Logger.getLogger(FileBasedMetadataConfigurationStore.class);
    private static String EXTENSION = ".xml";
    private String userHome = SecurityActions.getSystemProperty("user.home");
    private String pkgName = "org.jboss.identity.federation.saml.v2.metadata";

    public FileBasedMetadataConfigurationStore() {
        if (this.userHome == null) {
            throw new RuntimeException("user.home system property not set");
        }
        File jbid = new File(this.userHome + "/jbid-store");
        if (!jbid.exists()) {
            log.debug((Object)(jbid.getPath() + " does not exist. Hence creating."));
            jbid.mkdir();
        }
    }

    @Override
    public EntityDescriptorType load(String id) throws IOException {
        File persistedFile = this.validateIdAndReturnMDFile(id);
        try {
            Unmarshaller un = JAXBUtil.getUnmarshaller(this.pkgName);
            JAXBElement je = (JAXBElement)un.unmarshal(persistedFile);
            return (EntityDescriptorType)je.getValue();
        }
        catch (JAXBException e) {
            IOException ioe = new IOException(e.getLocalizedMessage());
            ioe.initCause(e);
            throw ioe;
        }
    }

    @Override
    public void persist(EntityDescriptorType entity, String id) throws IOException {
        File persistedFile = this.validateIdAndReturnMDFile(id);
        ObjectFactory of = new ObjectFactory();
        JAXBElement<EntityDescriptorType> jentity = of.createEntityDescriptor(entity);
        try {
            Marshaller m = JAXBUtil.getMarshaller(this.pkgName);
            m.marshal(jentity, persistedFile);
        }
        catch (JAXBException e) {
            IOException ioe = new IOException(e.getLocalizedMessage());
            ioe.initCause(e);
            throw ioe;
        }
        log.trace((Object)("Persisted into " + persistedFile.getPath()));
    }

    @Override
    public void delete(String id) {
        File persistedFile = this.validateIdAndReturnMDFile(id);
        if (persistedFile.exists()) {
            persistedFile.delete();
        }
    }

    @Override
    public Map<String, String> loadTrustedProviders(String id) throws IOException, ClassNotFoundException {
        File trustedFile = this.validateIdAndReturnTrustedProvidersFile(id);
        ObjectInputStream ois = new ObjectInputStream(new FileInputStream(trustedFile));
        Map trustedMap = (Map)ois.readObject();
        return trustedMap;
    }

    @Override
    public void persistTrustedProviders(String id, Map<String, String> trusted) throws IOException {
        File trustedFile = this.validateIdAndReturnTrustedProvidersFile(id);
        ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(trustedFile));
        oos.writeObject(trusted);
        oos.close();
        log.trace((Object)("Persisted trusted map into " + trustedFile.getPath()));
    }

    @Override
    public void deleteTrustedProviders(String id) {
        File persistedFile = this.validateIdAndReturnTrustedProvidersFile(id);
        if (persistedFile.exists()) {
            persistedFile.delete();
        }
    }

    private File validateIdAndReturnMDFile(String id) {
        if (id == null) {
            throw new IllegalArgumentException("id is null");
        }
        if (!id.endsWith(EXTENSION)) {
            id = id + EXTENSION;
        }
        return new File(this.userHome + "/jbid-store/" + id);
    }

    private File validateIdAndReturnTrustedProvidersFile(String id) {
        if (id == null) {
            throw new IllegalArgumentException("id is null");
        }
        id = id + "-trusted" + EXTENSION;
        return new File(this.userHome + "/jbid-store/" + id);
    }
}

