/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.federation.core.saml.v2.util;

import javax.xml.bind.JAXBElement;
import org.jboss.identity.federation.core.saml.v2.factories.SAMLAssertionFactory;
import org.jboss.identity.federation.core.saml.v2.factories.SAMLProtocolFactory;
import org.jboss.identity.federation.core.saml.v2.factories.SOAPFactory;
import org.jboss.identity.federation.core.saml.v2.factories.XACMLStatementFactory;
import org.jboss.identity.federation.org.xmlsoap.schemas.soap.envelope.Envelope;
import org.jboss.identity.federation.saml.v2.assertion.EncryptedElementType;
import org.jboss.identity.federation.saml.v2.profiles.xacml.assertion.XACMLAuthzDecisionStatementType;
import org.jboss.identity.federation.saml.v2.protocol.ArtifactResolveType;
import org.jboss.identity.federation.saml.v2.protocol.AssertionIDRequestType;
import org.jboss.identity.federation.saml.v2.protocol.AuthnRequestType;
import org.jboss.identity.federation.saml.v2.protocol.LogoutRequestType;
import org.jboss.identity.federation.saml.v2.protocol.ManageNameIDRequestType;
import org.jboss.identity.federation.saml.v2.protocol.NameIDMappingRequestType;
import org.jboss.identity.federation.saml.v2.protocol.RequestAbstractType;
import org.jboss.identity.federation.saml.v2.protocol.ResponseType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXBElementMappingUtil {
    public static JAXBElement<?> get(RequestAbstractType requestAbstractType) {
        if (requestAbstractType instanceof AuthnRequestType) {
            AuthnRequestType art = (AuthnRequestType)requestAbstractType;
            return SAMLProtocolFactory.getObjectFactory().createAuthnRequest(art);
        }
        if (requestAbstractType instanceof LogoutRequestType) {
            LogoutRequestType lrt = (LogoutRequestType)requestAbstractType;
            return SAMLProtocolFactory.getObjectFactory().createLogoutRequest(lrt);
        }
        if (requestAbstractType instanceof AssertionIDRequestType) {
            AssertionIDRequestType airt = (AssertionIDRequestType)requestAbstractType;
            return SAMLProtocolFactory.getObjectFactory().createAssertionIDRequest(airt);
        }
        if (requestAbstractType instanceof NameIDMappingRequestType) {
            NameIDMappingRequestType airt = (NameIDMappingRequestType)requestAbstractType;
            return SAMLProtocolFactory.getObjectFactory().createNameIDMappingRequest(airt);
        }
        if (requestAbstractType instanceof ArtifactResolveType) {
            ArtifactResolveType airt = (ArtifactResolveType)requestAbstractType;
            return SAMLProtocolFactory.getObjectFactory().createArtifactResolve(airt);
        }
        if (requestAbstractType instanceof ManageNameIDRequestType) {
            ManageNameIDRequestType airt = (ManageNameIDRequestType)requestAbstractType;
            return SAMLProtocolFactory.getObjectFactory().createManageNameIDRequest(airt);
        }
        throw new IllegalArgumentException("Unknown Type:" + requestAbstractType);
    }

    public static JAXBElement<?> get(EncryptedElementType encryptedAssertion) {
        return SAMLAssertionFactory.getObjectFactory().createEncryptedAssertion(encryptedAssertion);
    }

    public static JAXBElement<?> get(ResponseType responseType) {
        return SAMLProtocolFactory.getObjectFactory().createResponse(responseType);
    }

    public static JAXBElement<?> get(Envelope envelope) {
        return SOAPFactory.getObjectFactory().createEnvelope(envelope);
    }

    public static JAXBElement<?> get(XACMLAuthzDecisionStatementType xacmlStatement) {
        return XACMLStatementFactory.getObjectFactory().createXACMLAuthzDecisionStatement(xacmlStatement);
    }
}

