/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.federation.core.saml.v2.util;

import java.io.Reader;
import java.io.StringReader;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.helpers.DefaultValidationEventHandler;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.jboss.identity.federation.core.saml.v2.util.DocumentUtil;
import org.jboss.identity.federation.saml.v2.profiles.xacml.assertion.ObjectFactory;
import org.jboss.identity.federation.saml.v2.profiles.xacml.assertion.XACMLAuthzDecisionStatementType;
import org.jboss.identity.federation.saml.v2.profiles.xacml.protocol.XACMLAuthzDecisionQueryType;
import org.w3c.dom.Element;

public class SOAPSAMLXACMLUtil {
    private static String SOAP_PKG = "org.jboss.identity.federation.org.xmlsoap.schemas.soap.envelope";
    private static String SAML_PROTO_PKG = "org.jboss.identity.federation.saml.v2.protocol";
    private static String XACML_CTX_PKG = "org.jboss.security.xacml.core.model.context";
    private static String XACML_SAMLPROTO_PKG = "org.jboss.identity.federation.saml.v2.profiles.xacml.protocol";
    private static String XACML_SAMLASSERT_PKG = "org.jboss.identity.federation.saml.v2.profiles.xacml.assertion";
    private static String COLON = ":";
    private static String collectivePackage = SOAPSAMLXACMLUtil.getPackage();

    public static Marshaller getMarshaller() throws JAXBException {
        JAXBContext jaxb = JAXBContext.newInstance((String)collectivePackage);
        return jaxb.createMarshaller();
    }

    public static Unmarshaller getUnmarshaller() throws JAXBException {
        JAXBContext jaxb = JAXBContext.newInstance((String)collectivePackage);
        Unmarshaller un = jaxb.createUnmarshaller();
        return un;
    }

    public static XACMLAuthzDecisionQueryType getXACMLQueryType(Element samlRequest) throws TransformerFactoryConfigurationError, TransformerException, JAXBException {
        String elementString = DocumentUtil.getDOMElementAsString(samlRequest);
        Unmarshaller um = SOAPSAMLXACMLUtil.getUnmarshaller();
        um.setEventHandler((ValidationEventHandler)new DefaultValidationEventHandler());
        JAXBElement obj = (JAXBElement)um.unmarshal((Reader)new StringReader(elementString));
        Object xacmlObject = obj.getValue();
        if (!(xacmlObject instanceof XACMLAuthzDecisionQueryType)) {
            throw new RuntimeException("Unsupported type:" + xacmlObject);
        }
        return (XACMLAuthzDecisionQueryType)xacmlObject;
    }

    public static XACMLAuthzDecisionStatementType createXACMLAuthzDecisionStatementType() {
        ObjectFactory of = new ObjectFactory();
        return of.createXACMLAuthzDecisionStatementType();
    }

    private static String getPackage() {
        StringBuffer buf = new StringBuffer();
        buf.append(SOAP_PKG).append(COLON).append(SAML_PROTO_PKG).append(COLON);
        buf.append(XACML_CTX_PKG).append(COLON).append(XACML_SAMLPROTO_PKG).append(COLON).append(XACML_SAMLASSERT_PKG);
        return buf.toString();
    }
}

