/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.federation.core.util;

import java.net.URL;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.jboss.identity.federation.core.util.SecurityActions;
import org.xml.sax.SAXException;

public class JAXBUtil {
    public static final String W3C_XML_SCHEMA_NS_URI = "http://www.w3.org/2001/XMLSchema";

    public static Marshaller getValidatingMarshaller(String pkgName, String schemaLocation) throws JAXBException, SAXException {
        Marshaller marshaller = JAXBUtil.getMarshaller(pkgName);
        marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        ClassLoader tcl = SecurityActions.getContextClassLoader();
        URL schemaURL = tcl.getResource(schemaLocation);
        if (schemaURL == null) {
            throw new IllegalStateException("Schema URL is null:" + schemaLocation);
        }
        SchemaFactory scFact = SchemaFactory.newInstance(W3C_XML_SCHEMA_NS_URI);
        Schema schema = scFact.newSchema(schemaURL);
        marshaller.setSchema(schema);
        return marshaller;
    }

    public static Marshaller getMarshaller(String pkgName) throws JAXBException {
        if (pkgName == null) {
            throw new IllegalArgumentException("pkgName is null");
        }
        JAXBContext jc = JAXBContext.newInstance((String)pkgName);
        Marshaller marshaller = jc.createMarshaller();
        marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        return marshaller;
    }

    public static Unmarshaller getUnmarshaller(String pkgName) throws JAXBException {
        if (pkgName == null) {
            throw new IllegalArgumentException("pkgName is null");
        }
        JAXBContext jc = JAXBContext.newInstance((String)pkgName);
        return jc.createUnmarshaller();
    }

    public static Unmarshaller getValidatingUnmarshaller(String pkgName, String schemaLocation) throws JAXBException, SAXException {
        Unmarshaller unmarshaller = JAXBUtil.getUnmarshaller(pkgName);
        ClassLoader tcl = SecurityActions.getContextClassLoader();
        URL schemaURL = tcl.getResource(schemaLocation);
        if (schemaURL == null) {
            throw new IllegalStateException("Schema URL is null:" + schemaLocation);
        }
        SchemaFactory scFact = SchemaFactory.newInstance(W3C_XML_SCHEMA_NS_URI);
        Schema schema = scFact.newSchema(schemaURL);
        unmarshaller.setSchema(schema);
        return unmarshaller;
    }
}

