/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.federation.api.wstrust;

import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.jboss.identity.federation.core.saml.v2.util.DocumentUtil;
import org.jboss.identity.federation.core.util.JAXBUtil;
import org.jboss.identity.federation.core.wstrust.BaseRequestSecurityToken;
import org.jboss.identity.federation.core.wstrust.BaseRequestSecurityTokenResponse;
import org.jboss.identity.federation.core.wstrust.RequestSecurityToken;
import org.jboss.identity.federation.core.wstrust.RequestSecurityTokenResponse;
import org.jboss.identity.federation.core.wstrust.RequestSecurityTokenResponseCollection;
import org.jboss.identity.federation.ws.trust.ObjectFactory;
import org.jboss.identity.federation.ws.trust.RequestSecurityTokenResponseCollectionType;
import org.jboss.identity.federation.ws.trust.RequestSecurityTokenType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WSTrustJAXBFactory {
    private static final WSTrustJAXBFactory instance = new WSTrustJAXBFactory();
    private Marshaller marshaller;
    private Unmarshaller unmarshaller;
    private final ObjectFactory objectFactory;

    private WSTrustJAXBFactory() {
        try {
            this.marshaller = JAXBUtil.getMarshaller(this.getPackages());
            this.unmarshaller = JAXBUtil.getUnmarshaller(this.getPackages());
            this.objectFactory = new ObjectFactory();
        }
        catch (JAXBException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static WSTrustJAXBFactory getInstance() {
        return instance;
    }

    private String getPackages() {
        StringBuilder packages = new StringBuilder();
        packages.append("org.jboss.identity.federation.ws.addressing");
        packages.append(":org.jboss.identity.federation.ws.policy");
        packages.append(":org.jboss.identity.federation.ws.trust");
        packages.append(":org.jboss.identity.federation.ws.wss.secext");
        packages.append(":org.jboss.identity.federation.ws.wss.utility");
        return packages.toString();
    }

    public BaseRequestSecurityToken parseRequestSecurityToken(Source request) {
        Document document = (Document)((DOMSource)request).getNode();
        Element targetElement = this.getValidateOrRenewOrCancelTarget(document);
        try {
            Object object = this.unmarshaller.unmarshal(request);
            if (object instanceof JAXBElement) {
                JAXBElement element = (JAXBElement)this.unmarshaller.unmarshal(request);
                if (element.getDeclaredType().equals(RequestSecurityTokenType.class)) {
                    RequestSecurityToken parsedRequest = new RequestSecurityToken((RequestSecurityTokenType)element.getValue());
                    if (targetElement != null) {
                        if (parsedRequest.getValidateTarget() != null) {
                            parsedRequest.getValidateTarget().setAny(targetElement);
                        } else if (parsedRequest.getRenewTarget() != null) {
                            parsedRequest.getRenewTarget().setAny(targetElement);
                        } else if (parsedRequest.getCancelTarget() != null) {
                            parsedRequest.getCancelTarget().setAny(targetElement);
                        }
                    }
                    return parsedRequest;
                }
                throw new RuntimeException("Invalid request type: " + element.getDeclaredType());
            }
            throw new RuntimeException("Invalid request type: " + object.getClass().getName());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to unmarshall security token request", e);
        }
    }

    public BaseRequestSecurityTokenResponse parseRequestSecurityTokenResponse(Source response) {
        Element tokenElement = null;
        Document document = (Document)((DOMSource)response).getNode();
        Node requestedTokenNode = this.findNodeByNameNS(document, "RequestedSecurityToken", "http://docs.oasis-open.org/ws-sx/ws-trust/200512/");
        if (requestedTokenNode != null) {
            tokenElement = (Element)requestedTokenNode.getFirstChild();
        }
        try {
            Object object = this.unmarshaller.unmarshal(response);
            if (object instanceof JAXBElement) {
                JAXBElement element = (JAXBElement)this.unmarshaller.unmarshal(response);
                if (element.getDeclaredType().equals(RequestSecurityTokenResponseCollectionType.class)) {
                    RequestSecurityTokenResponseCollection collection = new RequestSecurityTokenResponseCollection((RequestSecurityTokenResponseCollectionType)element.getValue());
                    if (tokenElement != null) {
                        RequestSecurityTokenResponse parsedResponse = collection.getRequestSecurityTokenResponses().get(0);
                        parsedResponse.getRequestedSecurityToken().setAny(tokenElement);
                    }
                    return collection;
                }
                throw new RuntimeException("Invalid response type: " + element.getDeclaredType());
            }
            throw new RuntimeException("Invalid response type: " + object.getClass().getName());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to unmarshall security token response", e);
        }
    }

    public Source marshallRequestSecurityToken(RequestSecurityToken request) {
        Element targetElement = null;
        String requestType = request.getRequestType().toString();
        if (requestType.equalsIgnoreCase("http://docs.oasis-open.org/ws-sx/ws-trust/200512/Validate")) {
            targetElement = (Element)request.getValidateTarget().getAny();
            request.getValidateTarget().setAny(null);
        } else if (requestType.equalsIgnoreCase("http://docs.oasis-open.org/ws-sx/ws-trust/200512/Renew")) {
            targetElement = (Element)request.getRenewTarget().getAny();
            request.getRenewTarget().setAny(null);
        } else if (requestType.equalsIgnoreCase("http://docs.oasis-open.org/ws-sx/ws-trust/200512/Cancel")) {
            targetElement = (Element)request.getCancelTarget().getAny();
            request.getCancelTarget().setAny(null);
        }
        Document result = null;
        try {
            result = DocumentUtil.createDocument();
            this.marshaller.marshal(this.objectFactory.createRequestSecurityToken(request.getDelegate()), (Node)result);
            if (targetElement != null) {
                Node node = null;
                if (requestType.equalsIgnoreCase("http://docs.oasis-open.org/ws-sx/ws-trust/200512/Validate")) {
                    node = this.findNodeByNameNS(result, "ValidateTarget", "http://docs.oasis-open.org/ws-sx/ws-trust/200512/");
                } else if (requestType.equalsIgnoreCase("http://docs.oasis-open.org/ws-sx/ws-trust/200512/Renew")) {
                    node = this.findNodeByNameNS(result, "RenewTarget", "http://docs.oasis-open.org/ws-sx/ws-trust/200512/");
                } else if (requestType.equalsIgnoreCase("http://docs.oasis-open.org/ws-sx/ws-trust/200512/Cancel")) {
                    node = this.findNodeByNameNS(result, "CancelTarget", "http://docs.oasis-open.org/ws-sx/ws-trust/200512/");
                }
                node.appendChild(result.importNode(targetElement, true));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to marshall security token request", e);
        }
        return new DOMSource(result);
    }

    public Source marshallRequestSecurityTokenResponse(RequestSecurityTokenResponseCollection collection) {
        if (collection.getRequestSecurityTokenResponses().size() == 0) {
            throw new IllegalArgumentException("The response collection must contain at least one response");
        }
        Element tokenElement = null;
        RequestSecurityTokenResponse response = collection.getRequestSecurityTokenResponses().get(0);
        if (response.getRequestedSecurityToken() != null) {
            tokenElement = (Element)response.getRequestedSecurityToken().getAny();
            response.getRequestedSecurityToken().setAny(null);
        }
        Document result = null;
        try {
            result = DocumentUtil.createDocument();
            this.marshaller.marshal(this.objectFactory.createRequestSecurityTokenResponseCollection(collection.getDelegate()), (Node)result);
            if (tokenElement != null) {
                Node node = this.findNodeByNameNS(result, "RequestedSecurityToken", "http://docs.oasis-open.org/ws-sx/ws-trust/200512/");
                node.appendChild(result.importNode(tokenElement, true));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to marshall security token response", e);
        }
        return new DOMSource(result);
    }

    private Node findNodeByNameNS(Document document, String localName, String namespace) {
        NodeList list = document.getElementsByTagNameNS(namespace, localName);
        if (list == null || list.getLength() == 0) {
            return null;
        }
        return list.item(0);
    }

    private Element getValidateOrRenewOrCancelTarget(Document document) {
        Node target = this.findNodeByNameNS(document, "ValidateTarget", "http://docs.oasis-open.org/ws-sx/ws-trust/200512/");
        if (target != null) {
            return (Element)target.getFirstChild();
        }
        target = this.findNodeByNameNS(document, "RenewTarget", "http://docs.oasis-open.org/ws-sx/ws-trust/200512/");
        if (target != null) {
            return (Element)target.getFirstChild();
        }
        target = this.findNodeByNameNS(document, "CancelTarget", "http://docs.oasis-open.org/ws-sx/ws-trust/200512/");
        if (target != null) {
            return (Element)target.getFirstChild();
        }
        return null;
    }
}

