/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.federation.api.wstrust;

import java.util.GregorianCalendar;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.jboss.identity.federation.core.wstrust.Lifetime;
import org.jboss.identity.federation.ws.addressing.AttributedURIType;
import org.jboss.identity.federation.ws.addressing.EndpointReferenceType;
import org.jboss.identity.federation.ws.policy.AppliesTo;
import org.jboss.identity.federation.ws.trust.RequestedReferenceType;
import org.jboss.identity.federation.ws.wss.secext.KeyIdentifierType;
import org.jboss.identity.federation.ws.wss.secext.ObjectFactory;
import org.jboss.identity.federation.ws.wss.secext.SecurityTokenReferenceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSTrustUtil {
    public static KeyIdentifierType createKeyIdentifier(String valueType, String value) {
        KeyIdentifierType keyIdentifier = new KeyIdentifierType();
        keyIdentifier.setValueType(valueType);
        keyIdentifier.setValue(value);
        return keyIdentifier;
    }

    public static RequestedReferenceType createRequestedReference(KeyIdentifierType keyIdentifier, Map<QName, String> attributes) {
        SecurityTokenReferenceType securityTokenReference = new SecurityTokenReferenceType();
        securityTokenReference.getAny().add(new ObjectFactory().createKeyIdentifier(keyIdentifier));
        securityTokenReference.getOtherAttributes().putAll(attributes);
        RequestedReferenceType reference = new RequestedReferenceType();
        reference.setSecurityTokenReference(securityTokenReference);
        return reference;
    }

    public static AppliesTo createAppliesTo(String endpointURI) {
        AttributedURIType attributedURI = new AttributedURIType();
        attributedURI.setValue(endpointURI);
        EndpointReferenceType reference = new EndpointReferenceType();
        reference.setAddress(attributedURI);
        AppliesTo appliesTo = new AppliesTo();
        appliesTo.getAny().add(new org.jboss.identity.federation.ws.addressing.ObjectFactory().createEndpointReference(reference));
        return appliesTo;
    }

    public static String parseAppliesTo(AppliesTo appliesTo) {
        EndpointReferenceType reference = null;
        for (Object obj : appliesTo.getAny()) {
            JAXBElement element;
            if (obj instanceof EndpointReferenceType) {
                reference = (EndpointReferenceType)obj;
            } else if (obj instanceof JAXBElement && (element = (JAXBElement)obj).getName().getLocalPart().equalsIgnoreCase("EndpointReference")) {
                reference = (EndpointReferenceType)element.getValue();
            }
            if (reference == null || reference.getAddress() == null) continue;
            return reference.getAddress().getValue();
        }
        return null;
    }

    public static Lifetime createDefaultLifetime(long tokenTimeout) {
        GregorianCalendar created = new GregorianCalendar();
        GregorianCalendar expires = new GregorianCalendar();
        expires.setTimeInMillis(created.getTimeInMillis() + tokenTimeout);
        return new Lifetime(created, expires);
    }
}

