/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.federation.api.saml.v2.response;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.List;
import javax.xml.bind.Binder;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.parsers.ParserConfigurationException;
import org.jboss.identity.federation.core.exceptions.ConfigurationException;
import org.jboss.identity.federation.core.saml.v2.constants.JBossSAMLURIConstants;
import org.jboss.identity.federation.core.saml.v2.exceptions.IssueInstantMissingException;
import org.jboss.identity.federation.core.saml.v2.factories.JBossSAMLAuthnResponseFactory;
import org.jboss.identity.federation.core.saml.v2.factories.JBossSAMLBaseFactory;
import org.jboss.identity.federation.core.saml.v2.factories.SAMLAssertionFactory;
import org.jboss.identity.federation.core.saml.v2.factories.SAMLProtocolFactory;
import org.jboss.identity.federation.core.saml.v2.holders.IDPInfoHolder;
import org.jboss.identity.federation.core.saml.v2.holders.IssuerInfoHolder;
import org.jboss.identity.federation.core.saml.v2.holders.SPInfoHolder;
import org.jboss.identity.federation.core.saml.v2.util.AssertionUtil;
import org.jboss.identity.federation.core.saml.v2.util.DocumentUtil;
import org.jboss.identity.federation.core.saml.v2.util.JAXBElementMappingUtil;
import org.jboss.identity.federation.saml.v2.assertion.AssertionType;
import org.jboss.identity.federation.saml.v2.assertion.AttributeStatementType;
import org.jboss.identity.federation.saml.v2.assertion.AttributeType;
import org.jboss.identity.federation.saml.v2.assertion.AuthnContextType;
import org.jboss.identity.federation.saml.v2.assertion.AuthnStatementType;
import org.jboss.identity.federation.saml.v2.assertion.EncryptedElementType;
import org.jboss.identity.federation.saml.v2.assertion.NameIDType;
import org.jboss.identity.federation.saml.v2.assertion.ObjectFactory;
import org.jboss.identity.federation.saml.v2.protocol.ResponseType;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SAML2Response {
    public AssertionType createAssertion(String id, NameIDType issuer) {
        return AssertionUtil.createAssertion(id, issuer);
    }

    public AuthnStatementType createAuthnStatement(String authnContextDeclRef, XMLGregorianCalendar issueInstant) {
        ObjectFactory objectFactory = SAMLAssertionFactory.getObjectFactory();
        AuthnStatementType authnStatement = objectFactory.createAuthnStatementType();
        authnStatement.setAuthnInstant(issueInstant);
        AuthnContextType act = objectFactory.createAuthnContextType();
        String authContextDeclRef = JBossSAMLURIConstants.AC_PASSWORD_PROTECTED_TRANSPORT.get();
        act.getContent().add(objectFactory.createAuthnContextDeclRef(authContextDeclRef));
        authnStatement.setAuthnContext(act);
        return authnStatement;
    }

    public AttributeStatementType createAttributeStatement(List<String> roles) {
        AttributeStatementType attrStatement = JBossSAMLBaseFactory.createAttributeStatement();
        for (String role : roles) {
            AttributeType attr = JBossSAMLBaseFactory.createAttributeForRole(role);
            attrStatement.getAttributeOrEncryptedAttribute().add(attr);
        }
        return attrStatement;
    }

    public ResponseType createResponseType(String ID, SPInfoHolder sp, IDPInfoHolder idp, IssuerInfoHolder issuerInfo) throws ConfigurationException {
        return JBossSAMLAuthnResponseFactory.createResponseType(ID, sp, idp, issuerInfo);
    }

    public ResponseType createResponseType() {
        return JBossSAMLAuthnResponseFactory.createResponseType();
    }

    public ResponseType createResponseType(String ID, IssuerInfoHolder issuerInfo, AssertionType assertion) throws ConfigurationException {
        return JBossSAMLAuthnResponseFactory.createResponseType(ID, issuerInfo, assertion);
    }

    public void createTimedConditions(AssertionType assertion, long durationInMilis) throws ConfigurationException, IssueInstantMissingException {
        AssertionUtil.createTimedConditions(assertion, durationInMilis);
    }

    public EncryptedElementType getEncryptedAssertion(InputStream is) throws JAXBException, SAXException {
        if (is == null) {
            throw new IllegalArgumentException("inputstream is null");
        }
        Unmarshaller un = JBossSAMLAuthnResponseFactory.getUnmarshaller();
        JAXBElement jaxb = (JAXBElement)un.unmarshal(is);
        return (EncryptedElementType)jaxb.getValue();
    }

    public AssertionType getAssertionType(InputStream is) throws JAXBException, SAXException {
        if (is == null) {
            throw new IllegalArgumentException("inputstream is null");
        }
        Unmarshaller un = JBossSAMLAuthnResponseFactory.getUnmarshaller();
        JAXBElement jaxb = (JAXBElement)un.unmarshal(is);
        return (AssertionType)jaxb.getValue();
    }

    public ResponseType getResponseType(InputStream is) throws JAXBException, SAXException {
        if (is == null) {
            throw new IllegalArgumentException("inputstream is null");
        }
        Unmarshaller un = JBossSAMLAuthnResponseFactory.getUnmarshaller();
        JAXBElement jaxbAuthnRequestType = (JAXBElement)un.unmarshal(is);
        return (ResponseType)jaxbAuthnRequestType.getValue();
    }

    public Document convert(EncryptedElementType encryptedElementType) throws JAXBException, ParserConfigurationException {
        JAXBContext jaxb = JAXBContext.newInstance((Class[])new Class[]{EncryptedElementType.class});
        Binder binder = jaxb.createBinder();
        Document doc = DocumentUtil.createDocument();
        binder.marshal(JAXBElementMappingUtil.get(encryptedElementType), (Object)doc);
        return doc;
    }

    public Binder<Node> getBinder() throws JAXBException {
        JAXBContext jaxb = JAXBContext.newInstance((Class[])new Class[]{ResponseType.class});
        return jaxb.createBinder();
    }

    public Document convert(ResponseType responseType) throws JAXBException, ParserConfigurationException {
        JAXBContext jaxb = JAXBContext.newInstance((Class[])new Class[]{ResponseType.class});
        Binder binder = jaxb.createBinder();
        Document doc = DocumentUtil.createDocument();
        binder.marshal(JAXBElementMappingUtil.get(responseType), (Object)doc);
        return doc;
    }

    public void marshall(ResponseType responseType, OutputStream os) throws JAXBException, SAXException {
        Marshaller marshaller = JBossSAMLAuthnResponseFactory.getValidatingMarshaller();
        JAXBElement<ResponseType> jaxb = SAMLProtocolFactory.getObjectFactory().createResponse(responseType);
        marshaller.marshal(jaxb, os);
    }

    public void marshall(ResponseType responseType, Writer writer) throws JAXBException, SAXException {
        Marshaller marshaller = JBossSAMLAuthnResponseFactory.getMarshaller();
        JAXBElement<ResponseType> jaxb = SAMLProtocolFactory.getObjectFactory().createResponse(responseType);
        marshaller.marshal(jaxb, writer);
    }
}

