/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.federation.core.util;

import java.net.URL;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.log4j.Logger;
import org.jboss.identity.federation.core.util.IDFedLSInputResolver;
import org.jboss.identity.federation.core.util.SecurityActions;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class JAXBUtil {
    private static Logger log = Logger.getLogger(JAXBUtil.class);
    public static final String W3C_XML_SCHEMA_NS_URI = "http://www.w3.org/2001/XMLSchema";

    public static Marshaller getValidatingMarshaller(String pkgName, String schemaLocation) throws JAXBException, SAXException {
        Marshaller marshaller = JAXBUtil.getMarshaller(pkgName);
        Schema schema = JAXBUtil.getJAXPSchemaInstance(schemaLocation);
        marshaller.setSchema(schema);
        return marshaller;
    }

    public static Marshaller getMarshaller(String pkgName) throws JAXBException {
        if (pkgName == null) {
            throw new IllegalArgumentException("pkgName is null");
        }
        JAXBContext jc = JAXBContext.newInstance((String)pkgName);
        Marshaller marshaller = jc.createMarshaller();
        marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.FALSE);
        return marshaller;
    }

    public static Unmarshaller getUnmarshaller(String pkgName) throws JAXBException {
        if (pkgName == null) {
            throw new IllegalArgumentException("pkgName is null");
        }
        JAXBContext jc = JAXBContext.newInstance((String)pkgName);
        return jc.createUnmarshaller();
    }

    public static Unmarshaller getValidatingUnmarshaller(String pkgName, String schemaLocation) throws JAXBException, SAXException {
        Unmarshaller unmarshaller = JAXBUtil.getUnmarshaller(pkgName);
        Schema schema = JAXBUtil.getJAXPSchemaInstance(schemaLocation);
        unmarshaller.setSchema(schema);
        return unmarshaller;
    }

    private static Schema getJAXPSchemaInstance(String schemaLocation) throws SAXException {
        ClassLoader tcl = SecurityActions.getContextClassLoader();
        URL schemaURL = tcl.getResource(schemaLocation);
        if (schemaURL == null) {
            throw new IllegalStateException("Schema URL is null:" + schemaLocation);
        }
        SchemaFactory scFact = SchemaFactory.newInstance(W3C_XML_SCHEMA_NS_URI);
        if (SecurityActions.getSystemProperty("org.jboss.identity.federation.jaxb.ls", null) == null) {
            scFact.setResourceResolver(new IDFedLSInputResolver());
        }
        scFact.setErrorHandler(new ErrorHandler(){

            public void error(SAXParseException exception) throws SAXException {
                StringBuilder builder = new StringBuilder();
                builder.append("Line Number=").append(exception.getLineNumber());
                builder.append(" Col Number=").append(exception.getColumnNumber());
                builder.append(" Public ID=").append(exception.getPublicId());
                builder.append(" System ID=").append(exception.getSystemId());
                builder.append(" exc=").append(exception.getLocalizedMessage());
                log.trace((Object)("SAX Error:" + builder.toString()));
            }

            public void fatalError(SAXParseException exception) throws SAXException {
                StringBuilder builder = new StringBuilder();
                builder.append("Line Number=").append(exception.getLineNumber());
                builder.append(" Col Number=").append(exception.getColumnNumber());
                builder.append(" Public ID=").append(exception.getPublicId());
                builder.append(" System ID=").append(exception.getSystemId());
                builder.append(" exc=").append(exception.getLocalizedMessage());
                log.error((Object)("SAX Fatal Error:" + builder.toString()));
            }

            public void warning(SAXParseException exception) throws SAXException {
                StringBuilder builder = new StringBuilder();
                builder.append("Line Number=").append(exception.getLineNumber());
                builder.append(" Col Number=").append(exception.getColumnNumber());
                builder.append(" Public ID=").append(exception.getPublicId());
                builder.append(" System ID=").append(exception.getSystemId());
                builder.append(" exc=").append(exception.getLocalizedMessage());
                log.trace((Object)("SAX Warn:" + builder.toString()));
            }
        });
        Schema schema = scFact.newSchema(schemaURL);
        return schema;
    }
}

