/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.federation.core.saml.v2.util;

import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.log4j.Logger;
import org.jboss.identity.federation.core.exceptions.ConfigurationException;
import org.jboss.identity.federation.core.saml.v2.constants.JBossSAMLConstants;
import org.jboss.identity.federation.core.saml.v2.exceptions.IssueInstantMissingException;
import org.jboss.identity.federation.core.saml.v2.factories.JBossSAMLBaseFactory;
import org.jboss.identity.federation.core.saml.v2.factories.SAMLAssertionFactory;
import org.jboss.identity.federation.core.saml.v2.util.XMLTimeUtil;
import org.jboss.identity.federation.saml.v2.assertion.AssertionType;
import org.jboss.identity.federation.saml.v2.assertion.ConditionsType;
import org.jboss.identity.federation.saml.v2.assertion.NameIDType;

public class AssertionUtil {
    private static Logger log = Logger.getLogger(AssertionUtil.class);
    private static boolean trace = log.isTraceEnabled();

    public static AssertionType createAssertion(String id, NameIDType issuer) {
        AssertionType assertion = SAMLAssertionFactory.getObjectFactory().createAssertionType();
        assertion.setID(id);
        assertion.setVersion(JBossSAMLConstants.VERSION_2_0.get());
        assertion.setIssuer(issuer);
        return assertion;
    }

    public static void createTimedConditions(AssertionType assertion, long durationInMilis) throws ConfigurationException, IssueInstantMissingException {
        XMLGregorianCalendar issueInstant = assertion.getIssueInstant();
        if (issueInstant == null) {
            throw new IssueInstantMissingException("assertion does not have issue instant");
        }
        XMLGregorianCalendar assertionValidityLength = XMLTimeUtil.add(issueInstant, durationInMilis);
        ConditionsType conditionsType = JBossSAMLBaseFactory.getObjectFactory().createConditionsType();
        conditionsType.setNotBefore(issueInstant);
        conditionsType.setNotOnOrAfter(assertionValidityLength);
        assertion.setConditions(conditionsType);
    }

    public static boolean hasExpired(AssertionType assertion) throws ConfigurationException {
        ConditionsType conditionsType = assertion.getConditions();
        if (conditionsType != null) {
            XMLGregorianCalendar now = XMLTimeUtil.getIssueInstant();
            XMLGregorianCalendar notBefore = conditionsType.getNotBefore();
            XMLGregorianCalendar notOnOrAfter = conditionsType.getNotOnOrAfter();
            if (trace) {
                log.trace((Object)("Now=" + now.toXMLFormat() + " ::notBefore=" + notBefore.toXMLFormat() + "::notOnOrAfter=" + notOnOrAfter));
            }
            return !XMLTimeUtil.isValid(now, notBefore, notOnOrAfter);
        }
        return false;
    }
}

