/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.federation.web.filters;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.Principal;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dsig.XMLSignatureException;
import org.apache.log4j.Logger;
import org.jboss.identity.federation.api.saml.v2.common.IDGenerator;
import org.jboss.identity.federation.api.saml.v2.common.SAMLDocumentHolder;
import org.jboss.identity.federation.api.saml.v2.request.SAML2Request;
import org.jboss.identity.federation.api.saml.v2.response.SAML2Response;
import org.jboss.identity.federation.api.util.XMLSignatureUtil;
import org.jboss.identity.federation.core.exceptions.ConfigurationException;
import org.jboss.identity.federation.core.exceptions.ParsingException;
import org.jboss.identity.federation.core.saml.v2.constants.JBossSAMLURIConstants;
import org.jboss.identity.federation.core.saml.v2.exceptions.AssertionExpiredException;
import org.jboss.identity.federation.core.saml.v2.exceptions.IssuerNotTrustedException;
import org.jboss.identity.federation.core.saml.v2.holders.DestinationInfoHolder;
import org.jboss.identity.federation.core.saml.v2.util.AssertionUtil;
import org.jboss.identity.federation.saml.v2.assertion.AssertionType;
import org.jboss.identity.federation.saml.v2.assertion.AttributeStatementType;
import org.jboss.identity.federation.saml.v2.assertion.AttributeType;
import org.jboss.identity.federation.saml.v2.assertion.EncryptedElementType;
import org.jboss.identity.federation.saml.v2.assertion.NameIDType;
import org.jboss.identity.federation.saml.v2.assertion.SubjectType;
import org.jboss.identity.federation.saml.v2.protocol.AuthnRequestType;
import org.jboss.identity.federation.saml.v2.protocol.RequestAbstractType;
import org.jboss.identity.federation.saml.v2.protocol.ResponseType;
import org.jboss.identity.federation.saml.v2.protocol.StatusType;
import org.jboss.identity.federation.web.config.KeyProviderType;
import org.jboss.identity.federation.web.config.SPType;
import org.jboss.identity.federation.web.config.TrustType;
import org.jboss.identity.federation.web.filters.SecurityActions;
import org.jboss.identity.federation.web.interfaces.IRoleValidator;
import org.jboss.identity.federation.web.interfaces.TrustKeyConfigurationException;
import org.jboss.identity.federation.web.interfaces.TrustKeyManager;
import org.jboss.identity.federation.web.interfaces.TrustKeyProcessingException;
import org.jboss.identity.federation.web.roles.DefaultRoleValidator;
import org.jboss.identity.federation.web.util.ConfigurationUtil;
import org.jboss.identity.federation.web.util.PostBindingUtil;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class SPFilter
implements Filter {
    private static Logger log = Logger.getLogger(SPFilter.class);
    private boolean trace = log.isTraceEnabled();
    public static final String PRINCIPAL_ID = "jboss_identity.principal";
    public static final String ROLES_ID = "jboss_identity.roles";
    protected SPType spConfiguration = null;
    protected String configFile = "/WEB-INF/jboss-idfed.xml";
    protected String serviceURL = null;
    protected String identityURL = null;
    private TrustKeyManager keyManager;
    private ServletContext context = null;
    private IRoleValidator roleValidator = new DefaultRoleValidator();

    public void destroy() {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        boolean postMethod = "POST".equalsIgnoreCase(request.getMethod());
        Principal userPrincipal = null;
        HttpSession session = request.getSession();
        if (!postMethod) {
            userPrincipal = (Principal)session.getAttribute(PRINCIPAL_ID);
            if (userPrincipal != null) {
                filterChain.doFilter(servletRequest, servletResponse);
                return;
            }
            if (userPrincipal == null) {
                String relayState = null;
                try {
                    AuthnRequestType authnRequest = this.createSAMLRequest(this.serviceURL, this.identityURL);
                    this.sendRequestToIDP(authnRequest, relayState, response);
                }
                catch (Exception e) {
                    throw new ServletException((Throwable)e);
                }
                return;
            }
        } else {
            String samlResponse = request.getParameter("SAMLResponse");
            if (samlResponse != null && samlResponse.length() > 0) {
                boolean isValid = false;
                try {
                    isValid = this.validate(request);
                }
                catch (Exception e) {
                    throw new ServletException((Throwable)e);
                }
                if (!isValid) {
                    throw new ServletException("Validity check failed");
                }
                byte[] base64DecodedResponse = PostBindingUtil.base64Decode(samlResponse);
                ByteArrayInputStream is = new ByteArrayInputStream(base64DecodedResponse);
                try {
                    SAML2Response saml2Response = new SAML2Response();
                    ResponseType responseType = saml2Response.getResponseType(is);
                    SAMLDocumentHolder samlDocumentHolder = saml2Response.getSamlDocumentHolder();
                    boolean validSignature = this.verifySignature(samlDocumentHolder);
                    if (!validSignature) {
                        throw new IssuerNotTrustedException("Signature in saml document is invalid");
                    }
                    this.isTrusted(responseType.getIssuer().getValue());
                    List<Object> assertions = responseType.getAssertionOrEncryptedAssertion();
                    if (assertions.size() == 0) {
                        throw new IllegalStateException("No assertions in reply from IDP");
                    }
                    Object assertion = assertions.get(0);
                    if (assertion instanceof EncryptedElementType) {
                        responseType = this.decryptAssertion(responseType);
                    }
                    if ((userPrincipal = this.handleSAMLResponse(request, responseType)) == null) {
                        response.sendError(403);
                    }
                    filterChain.doFilter((ServletRequest)request, servletResponse);
                }
                catch (ParsingException e) {
                    if (this.trace) {
                        log.trace((Object)"Parsing Exception:", (Throwable)e);
                    }
                    throw new ServletException("Parsing Exception");
                }
                catch (ConfigurationException e) {
                    if (this.trace) {
                        log.trace((Object)"ConfigurationException:", (Throwable)e);
                    }
                    throw new ServletException("Config Exception");
                }
                catch (IssuerNotTrustedException e) {
                    if (this.trace) {
                        log.trace((Object)"IssuerNotTrustedException:", (Throwable)e);
                    }
                    throw new ServletException("Issuer Not Trusted Exception");
                }
                catch (AssertionExpiredException e) {
                    if (this.trace) {
                        log.trace((Object)"AssertionExpiredException:", (Throwable)e);
                    }
                    throw new ServletException("Assertion expired Exception");
                }
            }
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.context = filterConfig.getServletContext();
        InputStream is = this.context.getResourceAsStream(this.configFile);
        if (is == null) {
            throw new RuntimeException(this.configFile + " missing");
        }
        try {
            this.spConfiguration = ConfigurationUtil.getSPConfiguration(is);
            this.identityURL = this.spConfiguration.getIdentityURL();
            this.serviceURL = this.spConfiguration.getServiceURL();
            log.trace((Object)("Identity Provider URL=" + this.identityURL));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        KeyProviderType keyProvider = this.spConfiguration.getKeyProvider();
        if (keyProvider == null) {
            throw new RuntimeException("KeyProvider is null");
        }
        try {
            ClassLoader tcl = SecurityActions.getContextClassLoader();
            String keyManagerClassName = keyProvider.getClassName();
            if (keyManagerClassName == null) {
                throw new RuntimeException("KeyManager class name is null");
            }
            Class<?> clazz = tcl.loadClass(keyManagerClassName);
            this.keyManager = (TrustKeyManager)clazz.newInstance();
            this.keyManager.setAuthProperties(keyProvider.getAuth());
            this.keyManager.setValidatingAlias(keyProvider.getValidatingAlias());
        }
        catch (Exception e) {
            log.error((Object)"Exception reading configuration:", (Throwable)e);
            throw new RuntimeException(e.getLocalizedMessage());
        }
        log.trace((Object)("Key Provider=" + keyProvider.getClassName()));
        String roleValidatorName = filterConfig.getInitParameter("ROLE_VALIDATOR");
        if (roleValidatorName != null && !"".equals(roleValidatorName)) {
            try {
                Class<?> clazz = SecurityActions.getContextClassLoader().loadClass(roleValidatorName);
                this.roleValidator = (IRoleValidator)clazz.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        HashMap<String, String> options = new HashMap<String, String>();
        String roles = filterConfig.getInitParameter("ROLES");
        if (this.trace) {
            log.trace((Object)("Found Roles in SPFilter config=" + roles));
        }
        if (roles != null) {
            options.put("ROLES", roles);
        }
        this.roleValidator.intialize(options);
    }

    private AuthnRequestType createSAMLRequest(String serviceURL, String identityURL) throws ConfigurationException {
        if (serviceURL == null) {
            throw new IllegalArgumentException("serviceURL is null");
        }
        if (identityURL == null) {
            throw new IllegalArgumentException("identityURL is null");
        }
        SAML2Request saml2Request = new SAML2Request();
        String id = IDGenerator.create("ID_");
        return saml2Request.createAuthnRequestType(id, serviceURL, identityURL, serviceURL);
    }

    protected void sendRequestToIDP(AuthnRequestType authnRequest, String relayState, HttpServletResponse response) throws IOException, SAXException, JAXBException, GeneralSecurityException {
        SAML2Request saml2Request = new SAML2Request();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        saml2Request.marshall((RequestAbstractType)authnRequest, baos);
        String samlMessage = PostBindingUtil.base64Encode(baos.toString());
        String destination = authnRequest.getDestination();
        PostBindingUtil.sendPost(new DestinationInfoHolder(destination, samlMessage, relayState), response, true);
    }

    protected boolean validate(HttpServletRequest request) throws IOException, GeneralSecurityException {
        return request.getParameter("SAMLResponse") != null;
    }

    protected boolean verifySignature(SAMLDocumentHolder samlDocumentHolder) throws IssuerNotTrustedException {
        URL issuerURL;
        Document samlResponse = samlDocumentHolder.getSamlDocument();
        ResponseType response = (ResponseType)samlDocumentHolder.getSamlObject();
        String issuerID = response.getIssuer().getValue();
        if (issuerID == null) {
            throw new IssuerNotTrustedException("Issue missing");
        }
        try {
            issuerURL = new URL(issuerID);
        }
        catch (MalformedURLException e1) {
            throw new IssuerNotTrustedException(e1);
        }
        try {
            PublicKey publicKey = this.keyManager.getValidatingKey(issuerURL.getHost());
            log.trace((Object)"Going to verify signature in the saml response from IDP");
            boolean sigResult = XMLSignatureUtil.validate(samlResponse, publicKey);
            log.trace((Object)("Signature verification=" + sigResult));
            return sigResult;
        }
        catch (TrustKeyConfigurationException e) {
            log.error((Object)"Unable to verify signature", (Throwable)e);
        }
        catch (TrustKeyProcessingException e) {
            log.error((Object)"Unable to verify signature", (Throwable)e);
        }
        catch (MarshalException e) {
            log.error((Object)"Unable to verify signature", (Throwable)e);
        }
        catch (XMLSignatureException e) {
            log.error((Object)"Unable to verify signature", (Throwable)e);
        }
        return false;
    }

    protected void isTrusted(String issuer) throws IssuerNotTrustedException {
        try {
            String domainsTrusted;
            URL url = new URL(issuer);
            String issuerDomain = url.getHost();
            TrustType idpTrust = this.spConfiguration.getTrust();
            if (idpTrust != null && (domainsTrusted = idpTrust.getDomains()).indexOf(issuerDomain) < 0) {
                throw new IssuerNotTrustedException(issuer);
            }
        }
        catch (Exception e) {
            throw new IssuerNotTrustedException(e.getLocalizedMessage(), e);
        }
    }

    protected ResponseType decryptAssertion(ResponseType responseType) {
        throw new RuntimeException("This authenticator does not handle encryption");
    }

    public Principal handleSAMLResponse(HttpServletRequest request, ResponseType responseType) throws ConfigurationException, AssertionExpiredException {
        if (request == null) {
            throw new IllegalArgumentException("request is null");
        }
        if (responseType == null) {
            throw new IllegalArgumentException("response type is null");
        }
        StatusType statusType = responseType.getStatus();
        if (statusType == null) {
            throw new IllegalArgumentException("Status Type from the IDP is null");
        }
        String statusValue = statusType.getStatusCode().getValue();
        if (!JBossSAMLURIConstants.STATUS_SUCCESS.get().equals(statusValue)) {
            throw new SecurityException("IDP forbid the user");
        }
        List<Object> assertions = responseType.getAssertionOrEncryptedAssertion();
        if (assertions.size() == 0) {
            throw new IllegalStateException("No assertions in reply from IDP");
        }
        AssertionType assertion = (AssertionType)assertions.get(0);
        boolean expiredAssertion = AssertionUtil.hasExpired(assertion);
        if (expiredAssertion) {
            throw new AssertionExpiredException();
        }
        SubjectType subject = assertion.getSubject();
        JAXBElement<?> jnameID = subject.getContent().get(0);
        NameIDType nameID = (NameIDType)jnameID.getValue();
        final String userName = nameID.getValue();
        ArrayList<String> roles = new ArrayList<String>();
        AttributeStatementType attributeStatement = (AttributeStatementType)assertion.getStatementOrAuthnStatementOrAuthzDecisionStatement().get(0);
        List<Object> attList = attributeStatement.getAttributeOrEncryptedAttribute();
        for (Object obj : attList) {
            AttributeType attr = (AttributeType)obj;
            String roleName = (String)attr.getAttributeValue().get(0);
            roles.add(roleName);
        }
        Principal principal = new Principal(){

            public String getName() {
                return userName;
            }
        };
        boolean validRole = this.roleValidator.userInRole(principal, roles);
        if (!validRole) {
            if (this.trace) {
                log.trace((Object)("Invalid role:" + roles));
            }
            principal = null;
        }
        return principal;
    }
}

