/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.federation.api.saml.v2.sig;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import javax.xml.bind.JAXBException;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.xpath.XPathException;
import org.jboss.identity.federation.api.saml.v2.request.SAML2Request;
import org.jboss.identity.federation.api.saml.v2.response.SAML2Response;
import org.jboss.identity.federation.core.saml.v2.constants.JBossSAMLURIConstants;
import org.jboss.identity.federation.core.saml.v2.util.DocumentUtil;
import org.jboss.identity.federation.core.util.XMLSignatureUtil;
import org.jboss.identity.federation.saml.v2.protocol.RequestAbstractType;
import org.jboss.identity.federation.saml.v2.protocol.ResponseType;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class SAML2Signature {
    private String signatureMethod = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
    private String digestMethod = "http://www.w3.org/2000/09/xmldsig#sha1";

    public String getSignatureMethod() {
        return this.signatureMethod;
    }

    public void setSignatureMethod(String signatureMethod) {
        this.signatureMethod = signatureMethod;
    }

    public String getDigestMethod() {
        return this.digestMethod;
    }

    public void setDigestMethod(String digestMethod) {
        this.digestMethod = digestMethod;
    }

    public Document sign(RequestAbstractType request, KeyPair keypair) throws SAXException, IOException, JAXBException, ParserConfigurationException, GeneralSecurityException, MarshalException, XMLSignatureException {
        SAML2Request saml2Request = new SAML2Request();
        Document doc = saml2Request.convert(request);
        doc.normalize();
        String referenceURI = "#" + request.getID();
        return XMLSignatureUtil.sign(doc, keypair, this.digestMethod, this.signatureMethod, referenceURI);
    }

    public Document sign(ResponseType response, KeyPair keypair) throws JAXBException, ParserConfigurationException, GeneralSecurityException, MarshalException, XMLSignatureException {
        SAML2Response saml2Request = new SAML2Response();
        Document doc = saml2Request.convert(response);
        doc.normalize();
        String referenceURI = "#" + response.getID();
        return XMLSignatureUtil.sign(doc, keypair, this.digestMethod, this.signatureMethod, referenceURI);
    }

    public Document sign(ResponseType response, String idValueOfAssertion, KeyPair keypair, String referenceURI) throws JAXBException, ParserConfigurationException, XPathException, TransformerFactoryConfigurationError, TransformerException, GeneralSecurityException, MarshalException, XMLSignatureException {
        SAML2Response saml2Response = new SAML2Response();
        Document doc = saml2Response.convert(response);
        Node assertionNode = DocumentUtil.getNodeWithAttribute(doc, JBossSAMLURIConstants.ASSERTION_NSURI.get(), "Assertion", "ID", idValueOfAssertion);
        return XMLSignatureUtil.sign(doc, assertionNode, keypair, this.digestMethod, this.signatureMethod, referenceURI);
    }
}

