/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.federation.api.wstrust;

import java.net.URI;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPPart;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.ws.Dispatch;
import javax.xml.ws.Service;
import org.jboss.identity.federation.core.exceptions.ParsingException;
import org.jboss.identity.federation.core.saml.v2.util.DocumentUtil;
import org.jboss.identity.federation.core.wstrust.WSTrustException;
import org.jboss.identity.federation.core.wstrust.WSTrustJAXBFactory;
import org.jboss.identity.federation.core.wstrust.wrappers.RequestSecurityToken;
import org.jboss.identity.federation.core.wstrust.wrappers.RequestSecurityTokenResponse;
import org.jboss.identity.federation.core.wstrust.wrappers.RequestSecurityTokenResponseCollection;
import org.jboss.identity.federation.ws.trust.RenewTargetType;
import org.jboss.identity.federation.ws.trust.StatusType;
import org.jboss.identity.federation.ws.trust.ValidateTargetType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSTrustClient {
    private ThreadLocal<Dispatch<Source>> dispatchLocal = new InheritableThreadLocal<Dispatch<Source>>();
    private String targetNS = "http://org.jboss.identity.trust/sts/";

    public WSTrustClient(String serviceName, String port, String endpointURI, SecurityInfo secInfo) throws ParsingException {
        QName service = new QName(this.targetNS, serviceName);
        QName portName = new QName(this.targetNS, port);
        Service jaxwsService = Service.create((QName)service);
        jaxwsService.addPort(portName, "http://schemas.xmlsoap.org/wsdl/soap/http", endpointURI);
        Dispatch dispatch = jaxwsService.createDispatch(portName, Source.class, Service.Mode.PAYLOAD);
        Map reqContext = dispatch.getRequestContext();
        if (secInfo != null) {
            reqContext.put("javax.xml.ws.security.auth.username", secInfo.username);
            reqContext.put("javax.xml.ws.security.auth.password", secInfo.passwd);
        }
        this.dispatchLocal.set((Dispatch<Source>)dispatch);
    }

    public Element issueToken(String tokenType) throws WSTrustException {
        NodeList nodes;
        RequestSecurityToken request = new RequestSecurityToken();
        request.setTokenType(URI.create(tokenType));
        request.setRequestType(URI.create("http://docs.oasis-open.org/ws-sx/ws-trust/200512/Issue"));
        request.setContext("context");
        WSTrustJAXBFactory jaxbFactory = WSTrustJAXBFactory.getInstance();
        DOMSource requestSource = (DOMSource)jaxbFactory.marshallRequestSecurityToken(request);
        Source response = (Source)this.dispatchLocal.get().invoke((Object)requestSource);
        Node documentNode = ((DOMSource)response).getNode();
        Document responseDoc = documentNode instanceof Document ? (Document)documentNode : documentNode.getOwnerDocument();
        try {
            Document myDocument = DocumentUtil.createDocument();
            Node importedNode = myDocument.importNode(responseDoc.getDocumentElement(), true);
            myDocument.appendChild(importedNode);
            nodes = null;
            if (responseDoc instanceof SOAPPart) {
                SOAPPart soapPart = (SOAPPart)responseDoc;
                SOAPEnvelope env = soapPart.getEnvelope();
                SOAPBody body = env.getBody();
                Node data = body.getFirstChild();
                nodes = ((Element)data).getElementsByTagName("RequestedSecurityToken");
            } else {
                nodes = responseDoc.getElementsByTagNameNS("http://docs.oasis-open.org/ws-sx/ws-trust/200512/", "RequestedSecurityToken");
            }
        }
        catch (Exception e) {
            throw new WSTrustException("Exception in issuing token:", e);
        }
        if (nodes == null) {
            throw new WSTrustException("NodeList is null");
        }
        Node rstr = nodes.item(0);
        return (Element)rstr.getFirstChild();
    }

    public Element renewToken(String tokenType, Element token) throws WSTrustException {
        NodeList nodes;
        RequestSecurityToken request = new RequestSecurityToken();
        request.setContext("context");
        request.setTokenType(URI.create("http://docs.oasis-open.org/ws-sx/ws-trust/200512/RSTR/Status"));
        request.setRequestType(URI.create("http://docs.oasis-open.org/ws-sx/ws-trust/200512/Renew"));
        RenewTargetType renewTarget = new RenewTargetType();
        renewTarget.setAny(token);
        request.setRenewTarget(renewTarget);
        WSTrustJAXBFactory jaxbFactory = WSTrustJAXBFactory.getInstance();
        DOMSource requestSource = (DOMSource)jaxbFactory.marshallRequestSecurityToken(request);
        Source response = (Source)this.dispatchLocal.get().invoke((Object)requestSource);
        Node documentNode = ((DOMSource)response).getNode();
        Document responseDoc = documentNode instanceof Document ? (Document)documentNode : documentNode.getOwnerDocument();
        try {
            Document myDocument = DocumentUtil.createDocument();
            Node importedNode = myDocument.importNode(responseDoc.getDocumentElement(), true);
            myDocument.appendChild(importedNode);
            nodes = null;
            if (responseDoc instanceof SOAPPart) {
                SOAPPart soapPart = (SOAPPart)responseDoc;
                SOAPEnvelope env = soapPart.getEnvelope();
                SOAPBody body = env.getBody();
                Node data = body.getFirstChild();
                nodes = ((Element)data).getElementsByTagName("RequestedSecurityToken");
            } else {
                nodes = responseDoc.getElementsByTagNameNS("http://docs.oasis-open.org/ws-sx/ws-trust/200512/", "RequestedSecurityToken");
            }
        }
        catch (Exception e) {
            throw new WSTrustException("Exception in renewing token:", e);
        }
        if (nodes == null) {
            throw new WSTrustException("NodeList is null");
        }
        Node rstr = nodes.item(0);
        return (Element)rstr.getFirstChild();
    }

    public boolean validateToken(Element token) throws WSTrustException {
        RequestSecurityToken request = new RequestSecurityToken();
        request.setContext("context");
        request.setTokenType(URI.create("http://docs.oasis-open.org/ws-sx/ws-trust/200512/RSTR/Status"));
        request.setRequestType(URI.create("http://docs.oasis-open.org/ws-sx/ws-trust/200512/Validate"));
        ValidateTargetType validateTarget = new ValidateTargetType();
        validateTarget.setAny(token);
        request.setValidateTarget(validateTarget);
        WSTrustJAXBFactory jaxbFactory = WSTrustJAXBFactory.getInstance();
        DOMSource requestSource = (DOMSource)jaxbFactory.marshallRequestSecurityToken(request);
        Source response = (Source)this.dispatchLocal.get().invoke((Object)requestSource);
        RequestSecurityTokenResponseCollection responseCollection = (RequestSecurityTokenResponseCollection)jaxbFactory.parseRequestSecurityTokenResponse(response);
        RequestSecurityTokenResponse tokenResponse = responseCollection.getRequestSecurityTokenResponses().get(0);
        StatusType status = tokenResponse.getStatus();
        if (status != null) {
            String code = status.getCode();
            return "http://docs.oasis-open.org/ws-sx/ws-trust/200512/status/valid".equals(code);
        }
        return false;
    }

    public Dispatch<Source> getDispatch() {
        return this.dispatchLocal.get();
    }

    public static class SecurityInfo {
        private String username;
        private String passwd;

        public SecurityInfo(String name, char[] pass) {
            this.username = name;
            this.passwd = new String(pass);
        }

        public SecurityInfo(String name, String pass) {
            this.username = name;
            this.passwd = pass;
        }
    }
}

