/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.federation.core.wstrust;

import java.security.PrivilegedActionException;
import org.jboss.identity.federation.core.wstrust.STSConfiguration;
import org.jboss.identity.federation.core.wstrust.SecurityActions;
import org.jboss.identity.federation.core.wstrust.SecurityTokenProvider;
import org.jboss.identity.federation.core.wstrust.WSTrustRequestHandler;

public class WSTrustServiceFactory {
    private static final WSTrustServiceFactory factory = new WSTrustServiceFactory();

    private WSTrustServiceFactory() {
    }

    public static WSTrustServiceFactory getInstance() {
        return factory;
    }

    public WSTrustRequestHandler createRequestHandler(String handlerClassName, STSConfiguration configuration) {
        try {
            WSTrustRequestHandler handler = (WSTrustRequestHandler)SecurityActions.instantiateClass(handlerClassName);
            handler.initialize(configuration);
            return handler;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public SecurityTokenProvider createTokenProvider(String providerClass) {
        try {
            SecurityTokenProvider tokenProvider = (SecurityTokenProvider)SecurityActions.instantiateClass(providerClass);
            return tokenProvider;
        }
        catch (PrivilegedActionException pae) {
            throw new RuntimeException("Unable to instantiate token provider " + providerClass, pae);
        }
    }
}

