/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.federation.core.saml.v2.factories;

import java.util.Arrays;
import java.util.List;
import javax.xml.datatype.XMLGregorianCalendar;
import org.jboss.identity.federation.core.saml.v2.constants.JBossSAMLConstants;
import org.jboss.identity.federation.saml.v2.assertion.AssertionType;
import org.jboss.identity.federation.saml.v2.assertion.AudienceRestrictionType;
import org.jboss.identity.federation.saml.v2.assertion.ConditionAbstractType;
import org.jboss.identity.federation.saml.v2.assertion.ConditionsType;
import org.jboss.identity.federation.saml.v2.assertion.KeyInfoConfirmationDataType;
import org.jboss.identity.federation.saml.v2.assertion.NameIDType;
import org.jboss.identity.federation.saml.v2.assertion.StatementAbstractType;
import org.jboss.identity.federation.saml.v2.assertion.SubjectConfirmationType;
import org.jboss.identity.federation.saml.v2.assertion.SubjectType;
import org.jboss.identity.xmlsec.w3.xmldsig.KeyInfoType;
import org.jboss.identity.xmlsec.w3.xmldsig.ObjectFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SAMLAssertionFactory {
    private static org.jboss.identity.federation.saml.v2.assertion.ObjectFactory factory = new org.jboss.identity.federation.saml.v2.assertion.ObjectFactory();

    public static org.jboss.identity.federation.saml.v2.assertion.ObjectFactory getObjectFactory() {
        return factory;
    }

    public static AudienceRestrictionType createAudienceRestriction(String ... values) {
        AudienceRestrictionType audienceRestriction = new AudienceRestrictionType();
        if (values != null) {
            audienceRestriction.getAudience().addAll(Arrays.asList(values));
        }
        return audienceRestriction;
    }

    public static NameIDType createNameID(String format, String qualifier, String value) {
        NameIDType nameID = new NameIDType();
        nameID.setFormat(format);
        nameID.setNameQualifier(qualifier);
        nameID.setValue(value);
        return nameID;
    }

    public static ConditionsType createConditions(XMLGregorianCalendar notBefore, XMLGregorianCalendar notOnOrAfter, ConditionAbstractType ... restrictions) {
        ConditionsType conditions = new ConditionsType();
        conditions.setNotBefore(notBefore);
        conditions.setNotOnOrAfter(notOnOrAfter);
        if (restrictions != null) {
            conditions.getConditionOrAudienceRestrictionOrOneTimeUse().addAll(Arrays.asList(restrictions));
        }
        return conditions;
    }

    public static KeyInfoConfirmationDataType createKeyInfoConfirmation(KeyInfoType keyInfo) {
        KeyInfoConfirmationDataType type = SAMLAssertionFactory.getObjectFactory().createKeyInfoConfirmationDataType();
        type.getContent().add(new ObjectFactory().createKeyInfo(keyInfo));
        return type;
    }

    public static SubjectConfirmationType createSubjectConfirmation(NameIDType nameID, String confirmationMethod, KeyInfoConfirmationDataType keyInfoData) {
        SubjectConfirmationType subjectConfirmation = new SubjectConfirmationType();
        subjectConfirmation.setNameID(nameID);
        subjectConfirmation.setMethod(confirmationMethod);
        subjectConfirmation.setSubjectConfirmationData(keyInfoData);
        return subjectConfirmation;
    }

    public static SubjectType createSubject(NameIDType nameID, SubjectConfirmationType confirmation) {
        SubjectType subject = new SubjectType();
        org.jboss.identity.federation.saml.v2.assertion.ObjectFactory factory = SAMLAssertionFactory.getObjectFactory();
        if (nameID != null) {
            subject.getContent().add(factory.createNameID(nameID));
        }
        if (confirmation != null) {
            subject.getContent().add(factory.createSubjectConfirmation(confirmation));
        }
        return subject;
    }

    public static AssertionType createAssertion(String id, NameIDType issuerID, XMLGregorianCalendar issueInstant, ConditionsType conditions, SubjectType subject, List<StatementAbstractType> statements) {
        AssertionType assertion = new AssertionType();
        assertion.setID(id);
        assertion.setIssuer(issuerID);
        assertion.setIssueInstant(issueInstant);
        if (conditions != null) {
            assertion.setConditions(conditions);
        }
        if (subject != null) {
            assertion.setSubject(subject);
        }
        assertion.setVersion(JBossSAMLConstants.VERSION_2_0.get());
        if (statements != null) {
            assertion.getStatementOrAuthnStatementOrAuthzDecisionStatement().addAll(statements);
        }
        return assertion;
    }
}

