/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.federation.core.saml.v2.holders;

import org.jboss.identity.federation.core.saml.v2.constants.JBossSAMLConstants;
import org.jboss.identity.federation.core.saml.v2.constants.JBossSAMLURIConstants;
import org.jboss.identity.federation.saml.v2.assertion.NameIDType;
import org.jboss.identity.federation.saml.v2.assertion.ObjectFactory;

public class IssuerInfoHolder {
    private NameIDType issuer;
    private String statusCodeURI = JBossSAMLURIConstants.STATUS_SUCCESS.get();
    private String samlVersion = JBossSAMLConstants.VERSION_2_0.get();

    public IssuerInfoHolder(NameIDType issuer) {
        if (issuer == null) {
            throw new IllegalArgumentException("issuer in ctr in null");
        }
        this.issuer = issuer;
    }

    public IssuerInfoHolder(String issuerAsString) {
        if (issuerAsString == null) {
            throw new IllegalArgumentException("issuerAsString is null");
        }
        ObjectFactory assertionObjectFactory = new ObjectFactory();
        this.issuer = assertionObjectFactory.createNameIDType();
        this.issuer.setValue(issuerAsString);
    }

    public NameIDType getIssuer() {
        return this.issuer;
    }

    public void setIssuer(NameIDType issuer) {
        this.issuer = issuer;
    }

    public String getStatusCode() {
        return this.statusCodeURI;
    }

    public void setStatusCode(String statusCode) {
        this.statusCodeURI = statusCode;
    }

    public String getSamlVersion() {
        return this.samlVersion;
    }

    public void setSamlVersion(String samlVersion) {
        this.samlVersion = samlVersion;
    }
}

