/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.federation.core.saml.v2.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.identity.federation.core.config.KeyValueType;
import org.jboss.identity.federation.core.exceptions.ConfigurationException;
import org.jboss.identity.federation.core.handler.config.Handler;
import org.jboss.identity.federation.core.handler.config.Handlers;
import org.jboss.identity.federation.core.saml.v2.interfaces.SAML2Handler;
import org.jboss.identity.federation.core.saml.v2.util.SecurityActions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandlerUtil {
    public static Set<SAML2Handler> getHandlers(Handlers handlers) throws ConfigurationException {
        if (handlers == null) {
            throw new IllegalArgumentException("handlers is null");
        }
        List<Handler> handlerList = handlers.getHandler();
        HashSet<SAML2Handler> handlerSet = new HashSet<SAML2Handler>();
        for (Handler handler : handlerList) {
            String clazzName = handler.getClazz();
            ClassLoader tcl = SecurityActions.getContextClassLoader();
            try {
                Class<?> clazz = tcl.loadClass(clazzName);
                SAML2Handler samlhandler = (SAML2Handler)clazz.newInstance();
                List<KeyValueType> options = handler.getOption();
                HashMap<String, Object> mapOptions = new HashMap<String, Object>();
                for (KeyValueType kvtype : options) {
                    mapOptions.put(kvtype.getKey(), kvtype.getValue());
                }
                samlhandler.init(mapOptions);
                handlerSet.add(samlhandler);
            }
            catch (ClassNotFoundException e) {
                throw new ConfigurationException(e);
            }
            catch (InstantiationException e) {
                throw new ConfigurationException(e);
            }
            catch (IllegalAccessException e) {
                throw new ConfigurationException(e);
            }
        }
        return handlerSet;
    }
}

