/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.federation.core.saml.v2.util;

import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.X509Certificate;
import org.jboss.identity.federation.core.saml.v2.constants.JBossSAMLConstants;

public class SignatureUtil {
    public static String getXMLSignatureAlgorithmURI(String algo) {
        String xmlSignatureAlgo = null;
        if ("DSA".equalsIgnoreCase(algo)) {
            xmlSignatureAlgo = JBossSAMLConstants.SIGNATURE_SHA1_WITH_DSA.get();
        } else if ("RSA".equalsIgnoreCase(algo)) {
            xmlSignatureAlgo = JBossSAMLConstants.SIGNATURE_SHA1_WITH_RSA.get();
        }
        return xmlSignatureAlgo;
    }

    public static byte[] sign(String stringToBeSigned, PrivateKey signingKey) throws GeneralSecurityException {
        if (stringToBeSigned == null) {
            throw new IllegalArgumentException("stringToBeSigned is null");
        }
        if (signingKey == null) {
            throw new IllegalArgumentException("signingKey is null");
        }
        String algo = signingKey.getAlgorithm();
        Signature sig = SignatureUtil.getSignature(algo);
        sig.initSign(signingKey);
        sig.update(stringToBeSigned.getBytes());
        return sig.sign();
    }

    public static boolean validate(byte[] signedContent, byte[] signatureValue, PublicKey validatingKey) throws GeneralSecurityException {
        if (signedContent == null) {
            throw new IllegalArgumentException("signedContent is null");
        }
        if (signatureValue == null) {
            throw new IllegalArgumentException("signatureValue is null");
        }
        if (validatingKey == null) {
            throw new IllegalArgumentException("validatingKey is null");
        }
        String algo = validatingKey.getAlgorithm();
        Signature sig = SignatureUtil.getSignature(algo);
        sig.initVerify(validatingKey);
        sig.update(signedContent);
        return sig.verify(signatureValue);
    }

    public static boolean validate(byte[] signedContent, byte[] signatureValue, String signatureAlgorithm, X509Certificate validatingCert) throws GeneralSecurityException {
        if (signedContent == null) {
            throw new IllegalArgumentException("signedContent is null");
        }
        if (signatureValue == null) {
            throw new IllegalArgumentException("signatureValue is null");
        }
        if (signatureAlgorithm == null) {
            throw new IllegalArgumentException("signatureAlgorithm is null");
        }
        if (validatingCert == null) {
            throw new IllegalArgumentException("validatingCert is null");
        }
        Signature sig = SignatureUtil.getSignature(signatureAlgorithm);
        sig.initVerify(validatingCert);
        sig.update(signedContent);
        return sig.verify(signatureValue);
    }

    private static Signature getSignature(String algo) throws GeneralSecurityException {
        Signature sig = null;
        String xmlSignatureAlgo = SignatureUtil.getXMLSignatureAlgorithmURI(algo);
        if (xmlSignatureAlgo == null) {
            throw new GeneralSecurityException("Signing Algorithm invalid:" + algo);
        }
        if ("DSA".equalsIgnoreCase(algo)) {
            sig = Signature.getInstance(xmlSignatureAlgo);
        } else if ("RSA".equalsIgnoreCase(algo)) {
            sig = Signature.getInstance(xmlSignatureAlgo);
        }
        return sig;
    }
}

