/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.federation.core.util;

import java.io.OutputStream;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PrivilegedAction;
import java.security.PublicKey;
import java.util.Collections;
import java.util.List;
import javax.security.cert.X509Certificate;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dsig.CanonicalizationMethod;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.KeyValue;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.jboss.identity.federation.core.saml.v2.constants.JBossSAMLURIConstants;
import org.jboss.identity.federation.core.saml.v2.util.DocumentUtil;
import org.jboss.identity.federation.core.util.JAXBUtil;
import org.jboss.identity.xmlsec.w3.xmldsig.ObjectFactory;
import org.jboss.identity.xmlsec.w3.xmldsig.SignatureType;
import org.jcp.xml.dsig.internal.dom.XMLDSigRI;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLSignatureUtil {
    private static Logger log = Logger.getLogger(XMLSignatureUtil.class);
    private static boolean trace = log.isTraceEnabled();
    private static String pkgName = "org.jboss.identity.federation.w3.xmldsig";
    private static String schemaLocation = "schema/saml/v2/xmldsig-core-schema.xsd";
    private static ObjectFactory objectFactory = new ObjectFactory();
    private static XMLSignatureFactory fac = XMLSignatureUtil.getXMLSignatureFactory();

    private static XMLSignatureFactory getXMLSignatureFactory() {
        XMLSignatureFactory xsf = null;
        try {
            xsf = XMLSignatureFactory.getInstance("DOM");
        }
        catch (Exception err) {
            xsf = XMLSignatureFactory.getInstance("DOM", new XMLDSigRI());
        }
        return xsf;
    }

    public static boolean preCheckSignedInfo(Document doc) {
        NodeList nl = doc.getElementsByTagNameNS(JBossSAMLURIConstants.XMLDSIG_NSURI.get(), "SignedInfo");
        return nl != null ? nl.getLength() > 0 : false;
    }

    public static Document sign(Document doc, Node parentOfNodeToBeSigned, PrivateKey signingKey, X509Certificate certificate, String digestMethod, String signatureMethod, String referenceURI) throws ParserConfigurationException, GeneralSecurityException, MarshalException, XMLSignatureException {
        KeyPair keyPair = new KeyPair(certificate.getPublicKey(), signingKey);
        return XMLSignatureUtil.sign(doc, parentOfNodeToBeSigned, keyPair, digestMethod, signatureMethod, referenceURI);
    }

    public static Document sign(Document doc, Node nodeToBeSigned, KeyPair keyPair, String digestMethod, String signatureMethod, String referenceURI) throws ParserConfigurationException, GeneralSecurityException, MarshalException, XMLSignatureException {
        if (nodeToBeSigned == null) {
            throw new IllegalArgumentException("Node to be signed is null");
        }
        if (trace) {
            try {
                log.trace((Object)("Document to be signed=" + DocumentUtil.getDocumentAsString(doc)));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        Node parentNode = nodeToBeSigned.getParentNode();
        Document newDoc = DocumentUtil.createDocument();
        Node signingNode = newDoc.importNode(nodeToBeSigned, true);
        newDoc.appendChild(signingNode);
        newDoc = XMLSignatureUtil.sign(newDoc, keyPair, digestMethod, signatureMethod, referenceURI);
        Node signedNode = doc.importNode(newDoc.getFirstChild(), true);
        parentNode.replaceChild(signedNode, nodeToBeSigned);
        return doc;
    }

    public static Document sign(Document doc, KeyPair keyPair, String digestMethod, String signatureMethod, String referenceURI) throws GeneralSecurityException, MarshalException, XMLSignatureException {
        if (trace) {
            try {
                log.trace((Object)("Document to be signed=" + DocumentUtil.getDocumentAsString(doc)));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        PrivateKey signingKey = keyPair.getPrivate();
        PublicKey publicKey = keyPair.getPublic();
        DOMSignContext dsc = new DOMSignContext(signingKey, (Node)doc.getDocumentElement());
        dsc.setDefaultNamespacePrefix("dsig");
        DigestMethod digestMethodObj = fac.newDigestMethod(digestMethod, null);
        Transform transform = fac.newTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature", (TransformParameterSpec)null);
        List<Transform> transformList = Collections.singletonList(transform);
        Reference ref = fac.newReference(referenceURI, digestMethodObj, transformList, null, null);
        String canonicalizationMethodType = "http://www.w3.org/2001/10/xml-exc-c14n#WithComments";
        CanonicalizationMethod canonicalizationMethod = fac.newCanonicalizationMethod(canonicalizationMethodType, (C14NMethodParameterSpec)null);
        List<Reference> referenceList = Collections.singletonList(ref);
        SignatureMethod signatureMethodObj = fac.newSignatureMethod(signatureMethod, null);
        SignedInfo si = fac.newSignedInfo(canonicalizationMethod, signatureMethodObj, referenceList);
        KeyInfoFactory kif = fac.getKeyInfoFactory();
        KeyValue kv = kif.newKeyValue(publicKey);
        KeyInfo ki = kif.newKeyInfo(Collections.singletonList(kv));
        XMLSignature signature = fac.newXMLSignature(si, ki);
        signature.sign(dsc);
        return doc;
    }

    public static boolean validate(Document signedDoc, Key publicKey) throws MarshalException, XMLSignatureException {
        NodeList nl = signedDoc.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        if (nl == null || nl.getLength() == 0) {
            throw new IllegalArgumentException("Cannot find Signature element");
        }
        if (publicKey == null) {
            throw new IllegalArgumentException("Public Key is null");
        }
        DOMValidateContext valContext = new DOMValidateContext(publicKey, nl.item(0));
        XMLSignature signature = fac.unmarshalXMLSignature(valContext);
        boolean coreValidity = signature.validate(valContext);
        if (trace && !coreValidity) {
            boolean sv = signature.getSignatureValue().validate(valContext);
            log.trace((Object)("Signature validation status: " + sv));
            List<Reference> references = signature.getSignedInfo().getReferences();
            for (Reference ref : references) {
                log.trace((Object)("[Ref id=" + ref.getId() + ":uri=" + ref.getURI() + "]validity status:" + ref.validate(valContext)));
            }
        }
        return coreValidity;
    }

    public static void marshall(SignatureType signature, OutputStream os) throws JAXBException, SAXException {
        JAXBElement<SignatureType> jsig = objectFactory.createSignature(signature);
        Marshaller marshaller = JAXBUtil.getValidatingMarshaller(pkgName, schemaLocation);
        marshaller.marshal(jsig, os);
    }

    public static void marshall(Document signedDocument, OutputStream os) throws TransformerException {
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer trans = tf.newTransformer();
        trans.transform(DocumentUtil.getXMLSource(signedDocument), new StreamResult(os));
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                System.setProperty("org.apache.xml.security.ignoreLineBreaks", "true");
                return null;
            }
        });
    }
}

