/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.federation.core.wstrust.handlers;

import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.jboss.identity.federation.core.exceptions.ParsingException;
import org.jboss.identity.federation.core.wstrust.STSClient;
import org.jboss.identity.federation.core.wstrust.STSClientConfig;
import org.jboss.identity.federation.core.wstrust.STSClientFactory;
import org.jboss.identity.federation.core.wstrust.WSTrustException;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class STSSecurityHandler
implements SOAPHandler<SOAPMessageContext> {
    private String configFile = "sts-client.properties";
    private STSClient wsTrustClient;

    public abstract QName getSecurityElementQName();

    public abstract QName getTokenElementQName();

    @PostConstruct
    public void createWSTrustClient() {
        if (this.wsTrustClient == null) {
            try {
                STSClientConfig config = new STSClientConfig.Builder().build(this.configFile);
                this.wsTrustClient = STSClientFactory.getInstance().create(config);
            }
            catch (ParsingException e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        }
    }

    public boolean handleMessage(SOAPMessageContext messageContext) {
        if (this.isOutBound(messageContext)) {
            return true;
        }
        try {
            Element securityToken = this.extractSecurityToken(messageContext, this.getSecurityElementQName(), this.getTokenElementQName());
            if (this.wsTrustClient.validateToken(securityToken)) {
                return true;
            }
            throw new WebServiceException("Could not validate security token " + securityToken);
        }
        catch (SOAPException e) {
            throw new WebServiceException(e.getMessage(), (Throwable)e);
        }
        catch (WSTrustException e) {
            throw new WebServiceException(e.getMessage(), (Throwable)e);
        }
    }

    public void setWSTrustClient(STSClient client) {
        this.wsTrustClient = client;
    }

    public Set<QName> getHeaders() {
        return Collections.singleton(this.getSecurityElementQName());
    }

    public boolean handleFault(SOAPMessageContext messageContext) {
        return true;
    }

    public void close(MessageContext messageContext) {
    }

    @Resource(name="STSClientConfig")
    public void setConfigFile(String configFile) {
        if (configFile != null) {
            this.configFile = configFile;
        }
    }

    private boolean isOutBound(SOAPMessageContext messageContext) {
        return (Boolean)messageContext.get((Object)"javax.xml.ws.handler.message.outbound");
    }

    private Element extractSecurityToken(SOAPMessageContext messageContext, QName securityQName, QName tokenQName) throws SOAPException {
        if (securityQName == null) {
            throw new IllegalStateException("securityQName from subclass cannot be null!");
        }
        if (tokenQName == null) {
            throw new IllegalStateException("tokenQName from subclass cannot be null!");
        }
        SOAPHeader soapHeader = messageContext.getMessage().getSOAPHeader();
        Iterator securityHeaders = soapHeader.getChildElements(securityQName);
        while (securityHeaders.hasNext()) {
            Iterator childElements;
            SOAPHeaderElement elem = (SOAPHeaderElement)securityHeaders.next();
            if (!elem.getElementQName().equals(securityQName) || !(childElements = elem.getChildElements(tokenQName)).hasNext()) continue;
            return (Element)childElements.next();
        }
        return null;
    }
}

