/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.federation.web.handlers.saml2;

import java.io.StringWriter;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpSession;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import org.apache.log4j.Logger;
import org.jboss.identity.federation.api.saml.v2.request.SAML2Request;
import org.jboss.identity.federation.api.saml.v2.response.SAML2Response;
import org.jboss.identity.federation.core.exceptions.ConfigurationException;
import org.jboss.identity.federation.core.exceptions.ProcessingException;
import org.jboss.identity.federation.core.saml.v2.common.IDGenerator;
import org.jboss.identity.federation.core.saml.v2.constants.JBossSAMLURIConstants;
import org.jboss.identity.federation.core.saml.v2.exceptions.IssueInstantMissingException;
import org.jboss.identity.federation.core.saml.v2.holders.IDPInfoHolder;
import org.jboss.identity.federation.core.saml.v2.holders.IssuerInfoHolder;
import org.jboss.identity.federation.core.saml.v2.holders.SPInfoHolder;
import org.jboss.identity.federation.core.saml.v2.interfaces.SAML2HandlerRequest;
import org.jboss.identity.federation.core.saml.v2.interfaces.SAML2HandlerResponse;
import org.jboss.identity.federation.core.saml.v2.util.AssertionUtil;
import org.jboss.identity.federation.core.saml.v2.util.StatementUtil;
import org.jboss.identity.federation.saml.v2.assertion.AssertionType;
import org.jboss.identity.federation.saml.v2.assertion.AttributeStatementType;
import org.jboss.identity.federation.saml.v2.assertion.AttributeType;
import org.jboss.identity.federation.saml.v2.assertion.EncryptedElementType;
import org.jboss.identity.federation.saml.v2.assertion.NameIDType;
import org.jboss.identity.federation.saml.v2.assertion.SubjectType;
import org.jboss.identity.federation.saml.v2.protocol.AuthnRequestType;
import org.jboss.identity.federation.saml.v2.protocol.ResponseType;
import org.jboss.identity.federation.saml.v2.protocol.StatusType;
import org.jboss.identity.federation.web.core.HTTPContext;
import org.jboss.identity.federation.web.handlers.saml2.BaseSAML2Handler;
import org.jboss.identity.federation.web.interfaces.IRoleValidator;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class SAML2AuthenticationHandler
extends BaseSAML2Handler {
    private static Logger log = Logger.getLogger(SAML2AuthenticationHandler.class);
    private boolean trace = log.isTraceEnabled();
    private IDPAuthenticationHandler idp = new IDPAuthenticationHandler();
    private SPAuthenticationHandler sp = new SPAuthenticationHandler();

    public void handleRequestType(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
        if (!(request.getSAML2Object() instanceof AuthnRequestType)) {
            return;
        }
        if (request.getType() == SAML2HandlerRequest.HANDLER_TYPE.IDP) {
            this.idp.handleRequestType(request, response);
        } else {
            this.sp.handleRequestType(request, response);
        }
    }

    public void handleStatusResponseType(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
        if (!(request.getSAML2Object() instanceof ResponseType)) {
            return;
        }
        if (request.getType() == SAML2HandlerRequest.HANDLER_TYPE.IDP) {
            this.idp.handleStatusResponseType(request, response);
        } else {
            this.sp.handleStatusResponseType(request, response);
        }
    }

    public void generateSAMLRequest(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
        if (SAML2HandlerRequest.GENERATE_REQUEST_TYPE.AUTH != request.getTypeOfRequestToBeGenerated()) {
            return;
        }
        if (request.getType() == SAML2HandlerRequest.HANDLER_TYPE.IDP) {
            this.idp.generateSAMLRequest(request, response);
        } else {
            this.sp.generateSAMLRequest(request, response);
        }
    }

    public void reset() throws ProcessingException {
    }

    private class SPAuthenticationHandler {
        private SPAuthenticationHandler() {
        }

        public void generateSAMLRequest(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
            String issuerValue = request.getIssuer().getValue();
            SAML2Request samlRequest = new SAML2Request();
            String id = IDGenerator.create("ID_");
            try {
                AuthnRequestType authn = samlRequest.createAuthnRequestType(id, issuerValue, response.getDestination(), issuerValue);
                response.setResultingDocument(samlRequest.convert(authn));
            }
            catch (Exception e) {
                throw new ProcessingException(e);
            }
        }

        public void handleStatusResponseType(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
            Principal userPrincipal;
            HTTPContext httpContext = (HTTPContext)request.getContext();
            ResponseType responseType = (ResponseType)request.getSAML2Object();
            List<Object> assertions = responseType.getAssertionOrEncryptedAssertion();
            if (assertions.size() == 0) {
                throw new IllegalStateException("No assertions in reply from IDP");
            }
            Object assertion = assertions.get(0);
            if (assertion instanceof EncryptedElementType) {
                responseType = this.decryptAssertion(responseType);
            }
            if ((userPrincipal = this.handleSAMLResponse(responseType)) == null) {
                response.setError(403, "User Principal not determined: Forbidden");
            } else {
                HttpSession session = httpContext.getRequest().getSession(false);
                session.setAttribute("jboss_identity.principal", (Object)userPrincipal);
            }
        }

        public void handleRequestType(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
        }

        private ResponseType decryptAssertion(ResponseType responseType) {
            throw new RuntimeException("This authenticator does not handle encryption");
        }

        private Principal handleSAMLResponse(ResponseType responseType) throws ProcessingException {
            boolean expiredAssertion;
            if (responseType == null) {
                throw new IllegalArgumentException("response type is null");
            }
            StatusType statusType = responseType.getStatus();
            if (statusType == null) {
                throw new IllegalArgumentException("Status Type from the IDP is null");
            }
            String statusValue = statusType.getStatusCode().getValue();
            if (!JBossSAMLURIConstants.STATUS_SUCCESS.get().equals(statusValue)) {
                throw new SecurityException("IDP forbid the user");
            }
            List<Object> assertions = responseType.getAssertionOrEncryptedAssertion();
            if (assertions.size() == 0) {
                throw new IllegalStateException("No assertions in reply from IDP");
            }
            AssertionType assertion = (AssertionType)assertions.get(0);
            try {
                expiredAssertion = AssertionUtil.hasExpired(assertion);
            }
            catch (ConfigurationException e) {
                throw new ProcessingException(e);
            }
            if (expiredAssertion) {
                throw new ProcessingException("Assertion has expired");
            }
            SubjectType subject = assertion.getSubject();
            JAXBElement<?> jnameID = subject.getContent().get(0);
            NameIDType nameID = (NameIDType)jnameID.getValue();
            final String userName = nameID.getValue();
            ArrayList<String> roles = new ArrayList<String>();
            AttributeStatementType attributeStatement = (AttributeStatementType)assertion.getStatementOrAuthnStatementOrAuthzDecisionStatement().get(0);
            List<Object> attList = attributeStatement.getAttributeOrEncryptedAttribute();
            for (Object obj : attList) {
                AttributeType attr = (AttributeType)obj;
                String roleName = (String)attr.getAttributeValue().get(0);
                roles.add(roleName);
            }
            Principal principal = new Principal(){

                public String getName() {
                    return userName;
                }
            };
            IRoleValidator roleValidator = (IRoleValidator)SAML2AuthenticationHandler.this.options.get("ROLE_VALIDATOR");
            boolean validRole = roleValidator.userInRole(principal, roles);
            if (!validRole) {
                if (SAML2AuthenticationHandler.this.trace) {
                    log.trace((Object)("Invalid role:" + roles));
                }
                principal = null;
            }
            return principal;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IDPAuthenticationHandler {
        private IDPAuthenticationHandler() {
        }

        public void generateSAMLRequest(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
        }

        public void handleStatusResponseType(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
        }

        public void handleRequestType(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
            AuthnRequestType art = (AuthnRequestType)request.getSAML2Object();
            HttpSession session = BaseSAML2Handler.getHttpSession(request);
            Principal userPrincipal = (Principal)session.getAttribute("jboss_identity.principal");
            List roles = (List)session.getAttribute("jboss_identity.roles");
            try {
                Map attribs = (Map)request.getOptions().get("ATTRIBUTES");
                long assertionValidity = (Long)request.getOptions().get("ASSERTIONS_VALIDITY");
                String destination = art.getAssertionConsumerServiceURL();
                Document samlResponse = this.getResponse(destination, userPrincipal, roles, request.getIssuer().getValue(), attribs, assertionValidity);
                response.setDestination(destination);
                response.setResultingDocument(samlResponse);
            }
            catch (Exception e) {
                throw new ProcessingException(e);
            }
        }

        public Document getResponse(String assertionConsumerURL, Principal userPrincipal, List<String> roles, String identityURL, Map<String, Object> attribs, long assertionValidity) throws ConfigurationException, IssueInstantMissingException {
            Document samlResponseDocument;
            block8: {
                samlResponseDocument = null;
                if (SAML2AuthenticationHandler.this.trace) {
                    log.trace((Object)("AssertionConsumerURL=" + assertionConsumerURL + "::assertion validity=" + assertionValidity));
                }
                ResponseType responseType = null;
                SAML2Response saml2Response = new SAML2Response();
                String id = IDGenerator.create("ID_");
                IssuerInfoHolder issuerHolder = new IssuerInfoHolder(identityURL);
                issuerHolder.setStatusCode(JBossSAMLURIConstants.STATUS_SUCCESS.get());
                IDPInfoHolder idp = new IDPInfoHolder();
                idp.setNameIDFormatValue(userPrincipal.getName());
                idp.setNameIDFormat(JBossSAMLURIConstants.NAMEID_FORMAT_PERSISTENT.get());
                SPInfoHolder sp = new SPInfoHolder();
                sp.setResponseDestinationURI(assertionConsumerURL);
                responseType = saml2Response.createResponseType(id, sp, idp, issuerHolder);
                AssertionType assertion = (AssertionType)responseType.getAssertionOrEncryptedAssertion().get(0);
                AttributeStatementType attrStatement = saml2Response.createAttributeStatement(roles);
                assertion.getStatementOrAuthnStatementOrAuthzDecisionStatement().add(attrStatement);
                saml2Response.createTimedConditions(assertion, assertionValidity);
                if (attribs != null) {
                    AttributeStatementType attStatement = StatementUtil.createAttributeStatement(attribs);
                    assertion.getStatementOrAuthnStatementOrAuthzDecisionStatement().add(attStatement);
                }
                if (log.isTraceEnabled()) {
                    StringWriter sw = new StringWriter();
                    try {
                        saml2Response.marshall(responseType, sw);
                    }
                    catch (JAXBException e) {
                        log.trace((Object)e);
                    }
                    catch (SAXException e) {
                        log.trace((Object)e);
                    }
                    log.trace((Object)("Response=" + sw.toString()));
                }
                try {
                    samlResponseDocument = saml2Response.convert(responseType);
                }
                catch (Exception e) {
                    if (!SAML2AuthenticationHandler.this.trace) break block8;
                    log.trace((Object)e);
                }
            }
            return samlResponseDocument;
        }
    }
}

