/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.federation.web.servlets;

import java.io.IOException;
import java.security.Principal;
import javax.security.auth.login.LoginException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.jboss.identity.federation.web.handlers.DefaultLoginHandler;
import org.jboss.identity.federation.web.interfaces.ILoginHandler;
import org.jboss.identity.federation.web.servlets.SecurityActions;

public class IDPLoginServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private transient ServletContext context;
    private transient ILoginHandler loginHandler = null;

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HttpSession session = request.getSession();
        Principal principal = (Principal)session.getAttribute("jboss_identity.principal");
        if (principal != null) {
            this.saveRequest(request, session);
            this.redirectToIDP(request, response);
            return;
        }
        final String username = request.getParameter("JBID_USERNAME");
        String passwd = request.getParameter("JBID_PASSWORD");
        if (username == null || passwd == null) {
            String samlMessage = request.getParameter("SAMLRequest");
            if (samlMessage == null || "".equals(samlMessage)) {
                response.sendError(400);
            }
            this.log("No username or password found. Redirecting to login page");
            this.saveRequest(request, session);
            if (response.isCommitted()) {
                throw new RuntimeException("Response is committed. Cannot forward to login page.");
            }
            this.redirectToLoginPage(request, response);
        } else {
            try {
                boolean isValid = this.loginHandler.authenticate(username, passwd);
                if (!isValid) {
                    response.sendError(403);
                    return;
                }
                session.setAttribute("jboss_identity.principal", (Object)new Principal(){

                    public String getName() {
                        return username;
                    }
                });
                this.redirectToIDP(request, response);
                return;
            }
            catch (LoginException e) {
                this.log("Exception logging in :", e);
                response.sendError(403);
            }
        }
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.context = config.getServletContext();
        String loginClass = config.getInitParameter("loginClass");
        if (loginClass == null || loginClass.length() == 0) {
            loginClass = DefaultLoginHandler.class.getName();
        }
        try {
            Class<?> clazz = SecurityActions.getContextClassLoader().loadClass(loginClass);
            this.loginHandler = (ILoginHandler)clazz.newInstance();
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void testPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    private void saveRequest(HttpServletRequest request, HttpSession session) {
        session.setAttribute("SAMLRequest", (Object)request.getParameter("SAMLRequest"));
        String relayState = request.getParameter("RelayState");
        if (relayState != null && !"".equals(relayState)) {
            session.setAttribute("RelayState", (Object)relayState);
        }
        session.setAttribute("Referer", (Object)request.getHeader("Referer"));
    }

    private void redirectToIDP(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        RequestDispatcher dispatch = this.context.getRequestDispatcher("/IDPServlet");
        if (dispatch == null) {
            this.log("Cannot dispatch to the IDP Servlet");
        } else {
            dispatch.forward((ServletRequest)request, (ServletResponse)response);
        }
    }

    private void redirectToLoginPage(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        RequestDispatcher dispatch = this.context.getRequestDispatcher("/jsp/login.jsp");
        if (dispatch == null) {
            this.log("Cannot find the login page");
        } else {
            dispatch.forward((ServletRequest)request, (ServletResponse)response);
        }
    }
}

