/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.federation.web.util;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.jboss.identity.federation.core.config.IDPType;
import org.jboss.identity.federation.core.config.SPType;
import org.jboss.identity.federation.core.handler.config.Handlers;
import org.jboss.identity.federation.core.util.JAXBUtil;
import org.jboss.identity.federation.web.util.SecurityActions;
import org.xml.sax.SAXException;

public class ConfigurationUtil {
    public static IDPType getIDPConfiguration(InputStream is) throws JAXBException, SAXException, IOException {
        if (is == null) {
            throw new IllegalArgumentException("inputstream is null");
        }
        String schema = "schema/config/jboss-identity-fed.xsd";
        Unmarshaller un = ConfigurationUtil.getUnmarshaller(schema);
        JAXBElement jaxbSp = (JAXBElement)un.unmarshal(is);
        return (IDPType)jaxbSp.getValue();
    }

    public static SPType getSPConfiguration(InputStream is) throws JAXBException, SAXException, IOException {
        if (is == null) {
            throw new IllegalArgumentException("inputstream is null");
        }
        String schema = "schema/config/jboss-identity-fed.xsd";
        Unmarshaller un = ConfigurationUtil.getUnmarshaller(schema);
        JAXBElement jaxbSp = (JAXBElement)un.unmarshal(is);
        return (SPType)jaxbSp.getValue();
    }

    public static Handlers getHandlers(InputStream is) throws JAXBException, SAXException, IOException {
        if (is == null) {
            throw new IllegalArgumentException("inputstream is null");
        }
        String[] schemas = new String[]{"schema/config/jboss-identity-fed.xsd", "schema/config/jboss-identity-fed-handler.xsd"};
        Unmarshaller un = ConfigurationUtil.getUnmarshaller(schemas);
        JAXBElement handlers = (JAXBElement)un.unmarshal(is);
        return (Handlers)handlers.getValue();
    }

    private static Unmarshaller getUnmarshaller(String ... schema) throws JAXBException, SAXException, IOException {
        String key = "org.jboss.identity.jaxb.schema.validation";
        boolean validate = Boolean.parseBoolean(SecurityActions.getSystemProperty(key, "false"));
        String[] pkgName = new String[]{IDPType.class.getPackage().getName(), Handlers.class.getPackage().getName()};
        Unmarshaller un = null;
        un = validate ? JAXBUtil.getValidatingUnmarshaller(pkgName, schema) : JAXBUtil.getUnmarshaller(pkgName);
        return un;
    }
}

