/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors. 
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.identity.federation.web.util;

import java.io.InputStream;

import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
 
import org.jboss.identity.federation.core.constants.JBossIdentityFederationConstants;
import org.jboss.identity.federation.core.util.JAXBUtil;
import org.jboss.identity.federation.web.config.IDPType;
import org.jboss.identity.federation.web.config.SPType;
import org.xml.sax.SAXException;

/**
 * @author Anil.Saldhana@redhat.com
 * @since Aug 21, 2009
 */
public class ConfigurationUtil
{
   @SuppressWarnings("unchecked")
   public static IDPType getIDPConfiguration(InputStream is) throws JAXBException, SAXException  
   {
      if(is == null)
         throw new IllegalArgumentException("inputstream is null");
      String schema = "schema/config/jboss-identity-fed.xsd";
      
      String key = JBossIdentityFederationConstants.JAXB_SCHEMA_VALIDATION;
      boolean validate = Boolean.parseBoolean(SecurityActions.getSystemProperty(key, "false"));
      
      String pkgName = "org.jboss.identity.federation.web.config";
      Unmarshaller un = null;
      if(validate)
         un = JAXBUtil.getValidatingUnmarshaller(pkgName, schema);
      else
         un = JAXBUtil.getUnmarshaller(pkgName);
      
      JAXBElement<IDPType> jaxbSp =  (JAXBElement<IDPType>) un.unmarshal(is);
      return jaxbSp.getValue(); 
   }
   
   @SuppressWarnings("unchecked")
   public static SPType getSPConfiguration(InputStream is) throws JAXBException, SAXException  
   {
      if(is == null)
         throw new IllegalArgumentException("inputstream is null");
      String schema = "schema/config/jboss-identity-fed.xsd";
      
      String key = JBossIdentityFederationConstants.JAXB_SCHEMA_VALIDATION;
      boolean validate = Boolean.parseBoolean(SecurityActions.getSystemProperty(key, "false"));
      
      String pkgName = "org.jboss.identity.federation.web.config";
      Unmarshaller un = null;
      if(validate)
         un = JAXBUtil.getValidatingUnmarshaller(pkgName, schema);
      else
         un = JAXBUtil.getUnmarshaller(pkgName);
      
      JAXBElement<SPType> jaxbSp =  (JAXBElement<SPType>) un.unmarshal(is);
      return jaxbSp.getValue(); 
   }
}