/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.federation.web.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.Principal;
import java.security.PrivateKey;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.JAXBException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.apache.log4j.Logger;
import org.jboss.identity.federation.api.saml.v2.request.SAML2Request;
import org.jboss.identity.federation.api.saml.v2.response.SAML2Response;
import org.jboss.identity.federation.api.saml.v2.sig.SAML2Signature;
import org.jboss.identity.federation.core.config.IDPType;
import org.jboss.identity.federation.core.config.TrustType;
import org.jboss.identity.federation.core.exceptions.ConfigurationException;
import org.jboss.identity.federation.core.exceptions.ParsingException;
import org.jboss.identity.federation.core.interfaces.AttributeManager;
import org.jboss.identity.federation.core.saml.v2.common.IDGenerator;
import org.jboss.identity.federation.core.saml.v2.constants.JBossSAMLURIConstants;
import org.jboss.identity.federation.core.saml.v2.exceptions.IssueInstantMissingException;
import org.jboss.identity.federation.core.saml.v2.exceptions.IssuerNotTrustedException;
import org.jboss.identity.federation.core.saml.v2.holders.DestinationInfoHolder;
import org.jboss.identity.federation.core.saml.v2.holders.IDPInfoHolder;
import org.jboss.identity.federation.core.saml.v2.holders.IssuerInfoHolder;
import org.jboss.identity.federation.core.saml.v2.holders.SPInfoHolder;
import org.jboss.identity.federation.core.saml.v2.util.DocumentUtil;
import org.jboss.identity.federation.core.saml.v2.util.StatementUtil;
import org.jboss.identity.federation.saml.v2.assertion.AssertionType;
import org.jboss.identity.federation.saml.v2.assertion.AttributeStatementType;
import org.jboss.identity.federation.saml.v2.protocol.RequestAbstractType;
import org.jboss.identity.federation.saml.v2.protocol.ResponseType;
import org.jboss.identity.federation.web.interfaces.TrustKeyManager;
import org.jboss.identity.federation.web.util.HTTPRedirectUtil;
import org.jboss.identity.federation.web.util.PostBindingUtil;
import org.jboss.identity.federation.web.util.RedirectBindingSignatureUtil;
import org.jboss.identity.federation.web.util.RedirectBindingUtil;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IDPWebRequestUtil {
    private static Logger log = Logger.getLogger(IDPWebRequestUtil.class);
    private boolean trace = log.isTraceEnabled();
    private boolean redirectProfile = false;
    private boolean postProfile = false;
    private IDPType idpConfiguration;
    private TrustKeyManager keyManager;
    private AttributeManager attributeManager;
    private List<String> attribKeys;

    public IDPWebRequestUtil(HttpServletRequest request, IDPType idp, TrustKeyManager keym) {
        this.idpConfiguration = idp;
        this.keyManager = keym;
        this.redirectProfile = "GET".equals(request.getMethod());
        this.postProfile = "POST".equals(request.getMethod());
    }

    public void setAttributeKeys(List<String> attribKeys) {
        this.attribKeys = attribKeys;
    }

    public void setAttributeManager(AttributeManager attributeManager) {
        this.attributeManager = attributeManager;
    }

    public boolean hasSAMLRequestInRedirectProfile() {
        return this.redirectProfile;
    }

    public boolean hasSAMLRequestInPostProfile() {
        return this.postProfile;
    }

    public RequestAbstractType getSAMLRequest(String samlMessage) throws ParsingException, IOException {
        InputStream is = null;
        SAML2Request saml2Request = new SAML2Request();
        if (this.redirectProfile) {
            is = RedirectBindingUtil.base64DeflateDecode(samlMessage);
        } else {
            byte[] samlBytes = PostBindingUtil.base64Decode(samlMessage);
            if (this.trace) {
                log.trace((Object)("SAMLRequest=" + new String(samlBytes)));
            }
            is = new ByteArrayInputStream(samlBytes);
        }
        return saml2Request.getRequestType(is);
    }

    public Document getResponse(String assertionConsumerURL, Principal userPrincipal, List<String> roles, String identityURL, long assertionValidity, boolean supportSignature) throws ConfigurationException, IssueInstantMissingException {
        Document samlResponseDocument;
        block15: {
            samlResponseDocument = null;
            if (this.trace) {
                log.trace((Object)("AssertionConsumerURL=" + assertionConsumerURL + "::assertion validity=" + assertionValidity));
            }
            ResponseType responseType = null;
            SAML2Response saml2Response = new SAML2Response();
            String id = IDGenerator.create((String)"ID_");
            IssuerInfoHolder issuerHolder = new IssuerInfoHolder(identityURL);
            issuerHolder.setStatusCode(JBossSAMLURIConstants.STATUS_SUCCESS.get());
            IDPInfoHolder idp = new IDPInfoHolder();
            idp.setNameIDFormatValue(userPrincipal.getName());
            idp.setNameIDFormat(JBossSAMLURIConstants.NAMEID_FORMAT_PERSISTENT.get());
            SPInfoHolder sp = new SPInfoHolder();
            sp.setResponseDestinationURI(assertionConsumerURL);
            responseType = saml2Response.createResponseType(id, sp, idp, issuerHolder);
            AssertionType assertion = (AssertionType)responseType.getAssertionOrEncryptedAssertion().get(0);
            AttributeStatementType attrStatement = saml2Response.createAttributeStatement(roles);
            assertion.getStatementOrAuthnStatementOrAuthzDecisionStatement().add(attrStatement);
            saml2Response.createTimedConditions(assertion, assertionValidity);
            if (this.attributeManager != null) {
                try {
                    Map attribs = this.attributeManager.getAttributes(userPrincipal, this.attribKeys);
                    AttributeStatementType attStatement = StatementUtil.createAttributeStatement((Map)attribs);
                    assertion.getStatementOrAuthnStatementOrAuthzDecisionStatement().add(attStatement);
                }
                catch (Exception e) {
                    log.error((Object)"Exception in generating attributes:", (Throwable)e);
                }
            }
            if (log.isTraceEnabled()) {
                StringWriter sw = new StringWriter();
                try {
                    saml2Response.marshall(responseType, (Writer)sw);
                }
                catch (JAXBException e) {
                    log.trace((Object)e);
                }
                catch (SAXException e) {
                    log.trace((Object)e);
                }
                log.trace((Object)("Response=" + sw.toString()));
            }
            if (this.trace) {
                log.trace((Object)("Support Sig=" + supportSignature + " ::Post Profile?=" + this.hasSAMLRequestInPostProfile()));
            }
            if (supportSignature && this.hasSAMLRequestInPostProfile()) {
                try {
                    SAML2Signature saml2Signature = new SAML2Signature();
                    samlResponseDocument = saml2Signature.sign(responseType, this.keyManager.getSigningKeyPair());
                }
                catch (Exception e) {
                    if (this.trace) {
                        log.trace((Object)e);
                    }
                    break block15;
                }
            }
            try {
                samlResponseDocument = saml2Response.convert(responseType);
            }
            catch (Exception e) {
                log.trace((Object)e);
            }
        }
        return samlResponseDocument;
    }

    public void isTrusted(String issuer) throws IssuerNotTrustedException {
        if (this.idpConfiguration == null) {
            throw new IllegalStateException("IDP Configuration is null");
        }
        try {
            String issuerDomain = IDPWebRequestUtil.getDomain(issuer);
            TrustType idpTrust = this.idpConfiguration.getTrust();
            if (idpTrust != null) {
                String domainsTrusted = idpTrust.getDomains();
                if (this.trace) {
                    log.trace((Object)("Domains that IDP trusts=" + domainsTrusted + " and issuer domain=" + issuerDomain));
                }
                if (domainsTrusted.indexOf(issuerDomain) < 0) {
                    StringTokenizer st = new StringTokenizer(domainsTrusted, ",");
                    while (st != null && st.hasMoreTokens()) {
                        String uriBit = st.nextToken();
                        if (this.trace) {
                            log.trace((Object)("Matching uri bit=" + uriBit));
                        }
                        if (issuerDomain.indexOf(uriBit) <= 0) continue;
                        if (this.trace) {
                            log.trace((Object)("Matched " + uriBit + " trust for " + issuerDomain));
                        }
                        return;
                    }
                    throw new IssuerNotTrustedException(issuer);
                }
            }
        }
        catch (Exception e) {
            throw new IssuerNotTrustedException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public void send(Document responseDoc, String destination, String relayState, HttpServletResponse response, boolean supportSignature, PrivateKey signingKey) throws IOException, GeneralSecurityException {
        byte[] responseBytes;
        block10: {
            if (responseDoc == null) {
                throw new IllegalArgumentException("responseType is null");
            }
            responseBytes = null;
            try {
                responseBytes = DocumentUtil.getDocumentAsString((Document)responseDoc).getBytes("UTF-8");
            }
            catch (TransformerFactoryConfigurationError e) {
                if (this.trace) {
                    log.trace((Object)e);
                }
            }
            catch (TransformerException e) {
                if (!this.trace) break block10;
                log.trace((Object)e);
            }
        }
        if (this.redirectProfile) {
            String urlEncodedResponse = RedirectBindingUtil.deflateBase64URLEncode(responseBytes);
            if (this.trace) {
                log.trace((Object)("IDP:Destination=" + destination));
            }
            if (relayState != null && relayState.length() > 0) {
                relayState = RedirectBindingUtil.urlEncode(relayState);
            }
            String finalDest = destination + this.getDestination(urlEncodedResponse, relayState, supportSignature);
            if (this.trace) {
                log.trace((Object)("Redirecting to=" + finalDest));
            }
            HTTPRedirectUtil.sendRedirectForResponder(finalDest, response);
        } else {
            String samlResponse = PostBindingUtil.base64Encode(new String(responseBytes));
            PostBindingUtil.sendPost(new DestinationInfoHolder(destination, samlResponse, relayState), response, false);
        }
    }

    public String getDestination(String urlEncodedResponse, String urlEncodedRelayState, boolean supportSignature) {
        StringBuilder sb = new StringBuilder();
        if (supportSignature) {
            try {
                sb.append(RedirectBindingSignatureUtil.getSAMLResponseURLWithSignature(urlEncodedResponse, urlEncodedRelayState, this.keyManager.getSigningKey()));
            }
            catch (Exception e) {
                if (this.trace) {
                    log.trace((Object)e);
                }
            }
        } else {
            sb.append("?SAMLResponse=").append(urlEncodedResponse);
            if (urlEncodedRelayState != null && urlEncodedRelayState.length() > 0) {
                sb.append("&RelayState=").append(urlEncodedRelayState);
            }
        }
        return sb.toString();
    }

    public Document getErrorResponse(String responseURL, String status, String identityURL, boolean supportSignature) {
        Document samlResponse;
        block13: {
            samlResponse = null;
            ResponseType responseType = null;
            SAML2Response saml2Response = new SAML2Response();
            String id = IDGenerator.create((String)"ID_");
            IssuerInfoHolder issuerHolder = new IssuerInfoHolder(identityURL);
            issuerHolder.setStatusCode(status);
            IDPInfoHolder idp = new IDPInfoHolder();
            idp.setNameIDFormatValue(null);
            idp.setNameIDFormat(JBossSAMLURIConstants.NAMEID_FORMAT_PERSISTENT.get());
            SPInfoHolder sp = new SPInfoHolder();
            sp.setResponseDestinationURI(responseURL);
            try {
                responseType = saml2Response.createResponseType(id, sp, idp, issuerHolder);
            }
            catch (ConfigurationException e1) {
                if (this.trace) {
                    log.trace((Object)e1);
                }
                responseType = saml2Response.createResponseType();
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)"Error_ResponseType = ");
                StringWriter sw = new StringWriter();
                try {
                    saml2Response.marshall(responseType, (Writer)sw);
                }
                catch (JAXBException e) {
                    log.trace((Object)e);
                }
                catch (SAXException e) {
                    log.trace((Object)e);
                }
                log.trace((Object)("Response=" + sw.toString()));
            }
            if (supportSignature) {
                try {
                    SAML2Signature ss = new SAML2Signature();
                    samlResponse = ss.sign(responseType, this.keyManager.getSigningKeyPair());
                }
                catch (Exception e) {
                    if (this.trace) {
                        log.trace((Object)e);
                    }
                    break block13;
                }
            }
            try {
                samlResponse = saml2Response.convert(responseType);
            }
            catch (Exception e) {
                if (!this.trace) break block13;
                log.trace((Object)e);
            }
        }
        return samlResponse;
    }

    private static String getDomain(String domainURL) throws IOException {
        URL url = new URL(domainURL);
        return url.getHost();
    }
}

