/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.federation.web.core;

import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;

public class IdentityServer
implements HttpSessionListener {
    private STACK stack = new STACK();

    public STACK stack() {
        return this.stack;
    }

    public void sessionCreated(HttpSessionEvent sessionEvent) {
        String id = sessionEvent.getSession().getId();
        this.stack.put(id);
    }

    public void sessionDestroyed(HttpSessionEvent sessionEvent) {
        this.stack.remove(sessionEvent.getSession().getId());
    }

    public class STACK {
        private ConcurrentHashMap<String, Stack<String>> sessionParticipantsMap = new ConcurrentHashMap();
        private ConcurrentHashMap<String, Set<String>> inTransitMap = new ConcurrentHashMap();

        public String peek(String sessionID) {
            Stack<String> stack = this.sessionParticipantsMap.get(sessionID);
            if (stack != null) {
                return stack.peek();
            }
            return "";
        }

        public String pop(String sessionID) {
            String result = null;
            Stack<String> stack = this.sessionParticipantsMap.get(sessionID);
            if (stack != null) {
                result = stack.pop();
            }
            return result;
        }

        public void register(String sessionID, String participant) {
            Stack<String> stack = this.sessionParticipantsMap.get(sessionID);
            if (!stack.contains(participant)) {
                stack.push(participant);
            }
        }

        public int getParticipants(String sessionID) {
            Stack<String> stack = this.sessionParticipantsMap.get(sessionID);
            if (stack != null) {
                return stack.size();
            }
            return 0;
        }

        public boolean registerTransitParticipant(String sessionID, String participant) {
            Set<String> transitSet = this.inTransitMap.get(sessionID);
            if (transitSet != null) {
                return transitSet.add(participant);
            }
            return false;
        }

        public boolean deRegisterTransitParticipant(String sessionID, String participant) {
            Set<String> transitSet = this.inTransitMap.get(sessionID);
            if (transitSet != null) {
                return transitSet.remove(participant);
            }
            return false;
        }

        public int getNumOfParticipantsInTransit(String sessionID) {
            Set<String> transitSet = this.inTransitMap.get(sessionID);
            if (transitSet != null) {
                return transitSet.size();
            }
            return 0;
        }

        public int totalSessions() {
            return this.sessionParticipantsMap.keySet().size();
        }

        private void put(String id) {
            this.sessionParticipantsMap.put(id, new Stack());
            this.inTransitMap.put(id, new HashSet());
        }

        private void remove(String id) {
            this.sessionParticipantsMap.remove(id);
            this.inTransitMap.remove(id);
        }
    }
}

