/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.federation.web.process;

import java.io.IOException;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.jboss.identity.federation.core.exceptions.ConfigurationException;
import org.jboss.identity.federation.core.exceptions.ParsingException;
import org.jboss.identity.federation.core.exceptions.ProcessingException;
import org.jboss.identity.federation.core.interfaces.ProtocolContext;
import org.jboss.identity.federation.core.saml.v2.common.SAMLDocumentHolder;
import org.jboss.identity.federation.core.saml.v2.holders.IssuerInfoHolder;
import org.jboss.identity.federation.core.saml.v2.impl.DefaultSAML2HandlerRequest;
import org.jboss.identity.federation.core.saml.v2.impl.DefaultSAML2HandlerResponse;
import org.jboss.identity.federation.core.saml.v2.interfaces.SAML2Handler;
import org.jboss.identity.federation.core.saml.v2.interfaces.SAML2HandlerRequest;
import org.jboss.identity.federation.core.saml.v2.interfaces.SAML2HandlerResponse;
import org.jboss.identity.federation.core.util.StringUtil;
import org.jboss.identity.federation.web.core.HTTPContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceProviderBaseProcessor {
    protected static Logger log = Logger.getLogger(ServiceProviderBaseProcessor.class);
    protected boolean postBinding;
    protected String serviceURL;

    public ServiceProviderBaseProcessor(boolean postBinding, String serviceURL) {
        this.postBinding = postBinding;
        this.serviceURL = serviceURL;
    }

    public SAML2HandlerResponse process(HTTPContext httpContext, Set<SAML2Handler> handlers) throws ProcessingException, IOException, ParsingException, ConfigurationException {
        SAML2HandlerRequest saml2HandlerRequest = this.getSAML2HandlerRequest(null, httpContext);
        DefaultSAML2HandlerResponse saml2HandlerResponse = new DefaultSAML2HandlerResponse();
        try {
            for (SAML2Handler handler : handlers) {
                handler.reset();
                if (saml2HandlerResponse.isInError()) {
                    httpContext.getResponse().sendError(saml2HandlerResponse.getErrorCode());
                    break;
                }
                if (this.isLogOutRequest(httpContext)) {
                    saml2HandlerRequest.setTypeOfRequestToBeGenerated(SAML2HandlerRequest.GENERATE_REQUEST_TYPE.LOGOUT);
                } else {
                    saml2HandlerRequest.setTypeOfRequestToBeGenerated(SAML2HandlerRequest.GENERATE_REQUEST_TYPE.AUTH);
                }
                handler.generateSAMLRequest(saml2HandlerRequest, (SAML2HandlerResponse)saml2HandlerResponse);
            }
        }
        catch (ProcessingException pe) {
            log.error((Object)"Processing Exception:", (Throwable)pe);
            throw new RuntimeException(pe);
        }
        return saml2HandlerResponse;
    }

    protected SAML2HandlerRequest getSAML2HandlerRequest(SAMLDocumentHolder documentHolder, HTTPContext httpContext) {
        IssuerInfoHolder holder = new IssuerInfoHolder(this.serviceURL);
        return new DefaultSAML2HandlerRequest((ProtocolContext)httpContext, holder.getIssuer(), documentHolder, SAML2Handler.HANDLER_TYPE.SP);
    }

    protected boolean isLogOutRequest(HTTPContext httpContext) {
        HttpServletRequest request = httpContext.getRequest();
        String gloStr = request.getParameter("GLO");
        return StringUtil.isNotNull((String)gloStr) && "true".equalsIgnoreCase(gloStr);
    }
}

