/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors. 
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.identity.xmlkey.common;

import java.net.URL;

import javax.xml.XMLConstants;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;

/**
 * Utility for JAXB2
 * @author Anil.Saldhana@redhat.com
 * @since Jan 7, 2009
 */
public class JBossJAXBUtil
{
   /**
    * Get the JAXB Marshaller
    * @param pkgName The package name for the jaxb context
    * @param schemaLocation location of the schema to validate against 
    * @return Marshaller
    * @throws Exception
    */
   public static Marshaller getValidatingMarshaller(String pkgName, String schemaLocation)
   throws Exception
   {
      if(pkgName == null)
         throw new IllegalArgumentException("pkgName is null");
      
      JAXBContext jc = JAXBContext.newInstance(pkgName);
      Marshaller marshaller = jc.createMarshaller();
      marshaller.setProperty(Marshaller.JAXB_ENCODING, "UTF-8");
      //Validate against schema
      ClassLoader tcl = SecurityActions.getContextClassLoader();
      URL schemaURL = tcl.getResource(schemaLocation);
      if(schemaURL == null)
         throw new IllegalStateException("Schema URL is null:" + schemaLocation);
      SchemaFactory scFact = SchemaFactory.newInstance(XMLConstants.W3C_XML_SCHEMA_NS_URI);
      Schema schema = scFact.newSchema(schemaURL);
      marshaller.setSchema(schema); 
 
      return marshaller;
   }
   
   /**
    * Get the JAXB Unmarshaller
    * @param pkgName The package name for the jaxb context
    * @param schemaLocation location of the schema to validate against
    * @param schemaValidating need a validating schema unmarshaller?
    * @return unmarshaller
    * @throws Exception
    */
   public static Unmarshaller getValidatingUnmarshaller(String pkgName, String schemaLocation)
   throws Exception
   {
      if(pkgName == null)
         throw new IllegalArgumentException("pkgName is null");
      
      JAXBContext jc = JAXBContext.newInstance(pkgName);
      Unmarshaller unmarshaller = jc.createUnmarshaller(); 
      //Validate against schema
      ClassLoader tcl = SecurityActions.getContextClassLoader();
      URL schemaURL = tcl.getResource(schemaLocation);
      if(schemaURL == null)
         throw new IllegalStateException("Schema URL is null:" + schemaLocation);
      SchemaFactory scFact = SchemaFactory.newInstance(XMLConstants.W3C_XML_SCHEMA_NS_URI);
      Schema schema = scFact.newSchema(schemaURL);
      unmarshaller.setSchema(schema); 
 
      return unmarshaller;
   }
}