/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.injection.injector;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.injection.injector.metadata.EnvironmentEntryType;
import org.jboss.injection.injector.metadata.InjectionTargetType;
import org.jboss.injection.injector.metadata.JndiEnvironmentRefsGroup;
import org.jboss.injection.injector.util.InjectionPoint;
import org.jboss.injection.injector.util.InjectionPointFactory;
import org.jboss.injection.injector.util.NoSuchPropertyException;
import org.jboss.injection.manager.spi.InjectionContext;
import org.jboss.injection.manager.spi.InjectionException;
import org.jboss.injection.manager.spi.Injector;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EEInjector
implements Injector {
    private static Logger logger = Logger.getLogger(EEInjector.class);
    private JndiEnvironmentRefsGroup environment;
    private Context context;

    public EEInjector(JndiEnvironmentRefsGroup environment) {
        this.environment = environment;
        try {
            this.context = new InitialContext();
        }
        catch (NamingException ne) {
            throw new RuntimeException(ne);
        }
    }

    protected JndiEnvironmentRefsGroup getEnvironment() {
        return this.environment;
    }

    public <T> void inject(InjectionContext<T> injectionContext) {
        try {
            this.inject(injectionContext.getInjectedType(), injectionContext.getInjectionTarget());
            injectionContext.proceed();
        }
        catch (NamingException e) {
            throw new InjectionException((Throwable)e);
        }
    }

    public void inject(Object instance) throws NamingException {
        this.inject(instance.getClass(), instance);
    }

    private void inject(Class<?> cls, Object instance) throws NamingException {
        try {
            for (EnvironmentEntryType entry : this.environment.getEntries()) {
                String name = entry.getName();
                for (InjectionTargetType target : entry.getInjectionTargets()) {
                    if (!target.getInjectionTargetClass().isAssignableFrom(cls)) continue;
                    logger.debug((Object)("Looking up " + name + " for injecting into targetclass " + target.getInjectionTargetClass() + " targetname " + target.getInjectionTargetName()));
                    Object value = this.lookup(name);
                    this.inject(value, target.getInjectionTargetClass(), instance, target.getInjectionTargetName());
                }
            }
        }
        catch (NoSuchPropertyException e) {
            throw new RuntimeException(e);
        }
    }

    private Object lookup(String jndiName) throws NamingException {
        if (jndiName.startsWith("java:comp/") || jndiName.startsWith("java:module/") || jndiName.startsWith("java:app/") || jndiName.startsWith("java:global/")) {
            return this.context.lookup(jndiName);
        }
        return this.context.lookup("java:comp/" + jndiName);
    }

    private void inject(Object value, Class<?> cls, Object instance, String name) throws NoSuchPropertyException {
        Class<?> valueType = value == null ? null : value.getClass();
        InjectionPoint p = InjectionPointFactory.create(cls, name, valueType);
        p.set(instance, value);
    }
}

